/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<long[]> {
    private static final int TYPE_LONG_ARRAY_MIN = 65;
    private static final int TYPE_LONG_ARRAY_MAX = 67;

    @Override
    public Class<long[]> getTypeClass() {
        return long[].class;
    }

    @Override
    public int getMinValue() {
        return 65;
    }

    @Override
    public int getMaxValue() {
        return 67;
    }

    @Override
    public long[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 65, 67);
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, long[] lArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, lArray.length, 65, 67);
        for (int i = 0; i < lArray.length; ++i) {
            dataOutputStream.writeLong(lArray[i]);
        }
    }
}

