/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.remote.SessionExpiredException;
import javax.rad.server.AbstractSessionManager;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.ServerContext;
import javax.rad.server.event.ISessionListener;
import javax.rad.server.push.IPushHandler;
import javax.rad.server.push.IPushReceiver;
import javax.rad.server.push.PushMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractSessionManager
implements IPushHandler {
    private static final long CONTROLLER_INTERVAL = 10000L;
    private static final String[] USED_SYSPROPS = new String[]{"user.timezone", "user.name", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.version", "java.vm.name", "file.encoding", "file.separator", "path.separator", "line.separator"};
    private static final String PROPERTY_INIT = "<init>";
    private static final Object INIT = new Object();
    private Hashtable<Object, AbstractSession> htSessions = new Hashtable();
    private Hashtable<String, ISecurityManager> htApplicationSecManager = null;
    private GroupHashtable<String, Object, ISecurityManager> ghtSessionSecManager = null;
    private Hashtable<String, String> htSecManagerClass = null;
    private ArrayUtil<ISessionListener> auEvents = new ArrayUtil();
    private Hashtable<Object, IPushReceiver> htPushReceiver = new Hashtable();
    private Object oSync = new Object();
    private Thread thController = null;
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private static long lControllerInterval = 10000L;

    protected DefaultSessionManager(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AbstractSession get(Object object) {
        AbstractSession abstractSession = null;
        if (object != null) {
            Object object2 = this.oSync;
            synchronized (object2) {
                abstractSession = this.htSessions.get(object);
            }
            if (abstractSession != null) {
                long l = System.currentTimeMillis();
                if (abstractSession.isInactive(l) || !abstractSession.isAlive(l)) {
                    this.log.debug("Destroy invalid session: ", object, abstractSession.isInactive(l), !abstractSession.isAlive(l));
                    this.destroy(object);
                    throw new SessionExpiredException("Session expired '" + object + "'");
                }
                return abstractSession;
            }
            throw new SessionExpiredException("Session expired '" + object + "'");
        }
        throw new SecurityException("Invalid session id '" + object + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addSessionListener(ISessionListener iSessionListener) {
        ArrayUtil<ISessionListener> arrayUtil = this.auEvents;
        synchronized (arrayUtil) {
            this.auEvents.add(iSessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSessionListener(ISessionListener iSessionListener) {
        ArrayUtil<ISessionListener> arrayUtil = this.auEvents;
        synchronized (arrayUtil) {
            this.auEvents.remove(iSessionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ISessionListener[] getSessionListeners() {
        ArrayUtil<ISessionListener> arrayUtil = this.auEvents;
        synchronized (arrayUtil) {
            ISessionListener[] iSessionListenerArray = new ISessionListener[this.auEvents.size()];
            return this.auEvents.toArray(iSessionListenerArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(Object object) {
        if (object != null) {
            Object object2 = object instanceof ISession ? ((ISession)object).getId() : object;
            Object object3 = this.oSync;
            synchronized (object3) {
                return this.htSessions.get(object2) != null;
            }
        }
        return false;
    }

    @Override
    public void registerPushReceiver(Object object, IPushReceiver iPushReceiver) {
        if (object == null) {
            throw new IllegalArgumentException("Can't register a push receiver without connection identifier!");
        }
        if (iPushReceiver == null) {
            throw new IllegalArgumentException("Push receiver can't be null!");
        }
        this.htPushReceiver.put(object, iPushReceiver);
    }

    @Override
    public void unregisterPushReceiver(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't unregister a push receiver without connection identifier!");
        }
        this.htPushReceiver.remove(object);
    }

    @Override
    public void push(PushMessage pushMessage) {
        IPushReceiver iPushReceiver = this.htPushReceiver.get(pushMessage.getSession().getId());
        if (iPushReceiver != null) {
            iPushReceiver.receivedMessage(pushMessage);
        } else {
            this.log.error("Can't push to session ", pushMessage.getSession().getId(), " because receiver wasn't found!");
        }
    }

    /*
     * Exception decompiling
     */
    public final Object createSession(IRequest var1_1, ISerializer var2_2, ChangedHashtable<String, Object> var3_3) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final Object createSubSession(IRequest var1_1, AbstractSession var2_2, ChangedHashtable<String, Object> var3_3) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void destroy(Object object) {
        Object object2 = object instanceof ISession ? ((ISession)object).getId() : object;
        this.destroy(object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void destroy(Object var1_1, boolean var2_2) {
        if (var1_1 != null) {
            var3_3 = null;
            var4_4 = ProtocolFactory.openRecord("SESSION_MANAGER", "DESTROY", new Object[0]);
            try {
                if (var4_4 != null) {
                    var4_4.addIdentifier(var1_1);
                }
                var6_5 = this.oSync;
                synchronized (var6_5) {
                    var5_6 = this.htSessions.remove(var1_1);
                }
                try {
                    if (var5_6 == null) {
                        if (this.ghtSessionSecManager != null) {
                            var6_5 = this.ghtSessionSecManager;
                            synchronized (var6_5) {
                                var7_8 = this.ghtSessionSecManager.removeKey(var1_1);
                                if (var7_8 != null) {
                                    for (ISecurityManager var9_13 : var7_8) {
                                        this.releaseSecurityManager(var9_13);
                                    }
                                }
                            }
                        }
                        throw new SessionExpiredException("Session expired '" + var1_1 + "'");
                    }
                    var6_5 = ServerContext.getCurrentInstance();
                    if (var6_5 instanceof ServerContextImpl) {
                        var3_3 = ((ServerContextImpl)var6_5).getSession();
                        ((ServerContextImpl)var6_5).setSession(var5_6);
                    }
                    if (var5_6 instanceof MasterSession) {
                        var7_9 = false;
                        if (this.getCacheMode(var5_6) == CacheMode.Application) {
                            var6_5 = this.htApplicationSecManager.get(var5_6.getApplicationName());
                        } else {
                            var6_5 = this.ghtSessionSecManager.remove(var5_6.getApplicationName(), var5_6.getId());
                            var7_9 = true;
                        }
                        try {
                            try {
                                var6_5.logout(var5_6);
                            }
                            catch (Throwable var8_11) {
                                this.log.error(new Object[]{var8_11});
                            }
                            var8_12 = ((MasterSession)var5_6).removeSubSessions();
                            if (var8_12 != null) {
                                var10_16 = var8_12.size();
                                for (var9_14 = 0; var9_14 < var10_16; ++var9_14) {
                                    try {
                                        this.destroy(var8_12.get(var9_14).getId(), true);
                                        continue;
                                    }
                                    catch (Throwable var11_17) {
                                        this.log.info(new Object[]{var11_17});
                                    }
                                }
                            }
                            var13_18 = null;
                            if (!var7_9) ** GOTO lbl72
                            this.releaseSecurityManager((ISecurityManager)var6_5);
                        }
                        catch (Throwable var12_20) {
                            var13_19 = null;
                            if (var7_9) {
                                this.releaseSecurityManager((ISecurityManager)var6_5);
                            }
                            throw var12_20;
                        }
                    } else if (var5_6 instanceof SubSession) {
                        if (!var2_2 && var4_4 != null) {
                            var4_4.addIdentifier("DESTROY", 0);
                            var4_4.addIdentifier(((SubSession)var5_6).getMasterSession().getId(), 0);
                        }
                        ((SubSession)var5_6).getMasterSession().removeSubSession((SubSession)var5_6);
                    }
lbl72:
                    // 5 sources

                    var15_21 = null;
                    this.fireSessionDestroyed(var5_6);
                }
                catch (Throwable var14_23) {
                    var15_22 = null;
                    this.fireSessionDestroyed(var5_6);
                    throw var14_23;
                }
                var17_24 = null;
            }
            catch (Throwable var16_26) {
                var17_25 = null;
                CommonUtil.close(new Object[]{var4_4});
                if (var3_3 != null) {
                    ((ServerContextImpl)ServerContext.getCurrentInstance()).setSession(var3_3);
                }
                this.htPushReceiver.remove(var1_1);
                throw var16_26;
            }
            CommonUtil.close(new Object[]{var4_4});
            if (var3_3 != null) {
                ((ServerContextImpl)ServerContext.getCurrentInstance()).setSession(var3_3);
            }
            this.htPushReceiver.remove(var1_1);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIntern(AbstractSession abstractSession) {
        Object object = this.oSync;
        synchronized (object) {
            this.htSessions.put(abstractSession.getId(), abstractSession);
        }
        this.fireSessionCreated(abstractSession);
        this.startController();
    }

    final ISecurityManager getSecurityManager(ISession iSession) throws Exception {
        String string = iSession.getApplicationName();
        ISecurityManager iSecurityManager = null;
        String string2 = null;
        CacheMode cacheMode = this.getCacheMode(iSession);
        if (cacheMode == CacheMode.Application) {
            if (this.htApplicationSecManager != null) {
                iSecurityManager = this.htApplicationSecManager.get(string);
            }
            string2 = iSession.getConfig().getProperty("/application/securitymanager/class");
            if (!(iSecurityManager == null || string2 != null && string2.equals(this.htSecManagerClass.get(string)))) {
                this.htApplicationSecManager.remove(string);
                this.htSecManagerClass.remove(string);
                this.releaseSecurityManager(iSecurityManager);
                iSecurityManager = null;
            }
        } else if (this.ghtSessionSecManager != null) {
            iSecurityManager = this.ghtSessionSecManager.get(string, iSession.getId());
        }
        if (iSecurityManager == null) {
            try {
                iSecurityManager = this.createSecurityManager(iSession);
                if (cacheMode == CacheMode.Application) {
                    if (this.htApplicationSecManager == null) {
                        this.htApplicationSecManager = new Hashtable();
                        this.htSecManagerClass = new Hashtable();
                    }
                    this.htApplicationSecManager.put(string, iSecurityManager);
                    this.htSecManagerClass.put(string, string2);
                } else {
                    if (this.ghtSessionSecManager == null) {
                        this.ghtSessionSecManager = new GroupHashtable();
                    }
                    this.ghtSessionSecManager.put(string, iSession.getId(), iSecurityManager);
                }
            }
            catch (Throwable throwable) {
                throw new Exception("Error during instantiation of security manager", throwable);
            }
        }
        return iSecurityManager;
    }

    final ISecurityManager[] getSecurityManagerFromCache(String string) {
        Object object;
        ArrayUtil<Object> arrayUtil = null;
        if (this.htApplicationSecManager != null) {
            arrayUtil = new ArrayUtil<Object>();
            object = this.htApplicationSecManager.get(string);
            if (object != null) {
                arrayUtil.add(object);
            }
        }
        if (this.ghtSessionSecManager != null && (object = this.ghtSessionSecManager.get(string)) != null) {
            if (arrayUtil == null) {
                arrayUtil = new ArrayUtil();
            }
            Enumeration enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                arrayUtil.add(enumeration.nextElement());
            }
        }
        if (arrayUtil != null && !arrayUtil.isEmpty()) {
            return arrayUtil.toArray(new ISecurityManager[arrayUtil.size()]);
        }
        return null;
    }

    protected ISecurityManager createSecurityManager(ISession iSession) throws Exception {
        return this.createSecurityManager(null, iSession);
    }

    protected ISecurityManager createSecurityManager(ClassLoader classLoader, ISession iSession) throws Exception {
        return AbstractSecurityManager.createSecurityManager(classLoader, iSession);
    }

    protected void releaseSecurityManager(ISecurityManager iSecurityManager) {
        try {
            iSecurityManager.release();
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getSessionCount() {
        Object object = this.oSync;
        synchronized (object) {
            return this.htSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayUtil<Object> getSessionIds() {
        Object object = this.oSync;
        synchronized (object) {
            return new ArrayUtil<Object>((Collection<Object>)this.htSessions.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionCreated(ISession iSession) {
        ArrayUtil<ISessionListener> arrayUtil;
        if (iSession == null) {
            return;
        }
        ArrayUtil<ISessionListener> arrayUtil2 = this.auEvents;
        synchronized (arrayUtil2) {
            arrayUtil = new ArrayUtil<ISessionListener>((Collection<ISessionListener>)this.auEvents);
        }
        int n = arrayUtil.size();
        for (int i = 0; i < n; ++i) {
            arrayUtil.get(i).sessionCreated(iSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionDestroyed(ISession iSession) {
        ArrayUtil<ISessionListener> arrayUtil;
        if (iSession == null) {
            return;
        }
        ArrayUtil<ISessionListener> arrayUtil2 = this.auEvents;
        synchronized (arrayUtil2) {
            arrayUtil = new ArrayUtil<ISessionListener>((Collection<ISessionListener>)this.auEvents);
        }
        int n = arrayUtil.size();
        for (int i = 0; i < n; ++i) {
            arrayUtil.get(i).sessionDestroyed(iSession);
        }
    }

    private void startController() {
        if (ThreadHandler.isStopped(this.thController)) {
            this.thController = ThreadHandler.start(new Controller());
            this.log.debug("Start Controller: ", this.thController.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateSessions() {
        ArrayUtil<Object> arrayUtil = this.getSessionIds();
        long l = System.currentTimeMillis();
        ServerContext serverContext = ((Server)this.getServer()).createServerContext();
        try {
            Record record = null;
            int i = 0;
            int n = arrayUtil.size();
            while (true) {
                if (i >= n) {
                    Object var14_12 = null;
                    serverContext.release();
                    return;
                }
                Object object = arrayUtil.get(i);
                ISession iSession = this.htSessions.get(object);
                if (serverContext instanceof ServerContextImpl) {
                    ((ServerContextImpl)serverContext).setSession(iSession);
                }
                if (iSession != null && (iSession.isInactive(l) || !iSession.isAlive(l))) {
                    Object var12_9;
                    iSession.getProperties().put("expired", Boolean.TRUE);
                    record = ProtocolFactory.openRecord("SESSION_MANAGER", "VALIDATESESSIONS", new Object[0]);
                    try {
                        try {
                            if (record != null) {
                                record.addIdentifier("(thread)");
                            }
                            this.log.debug("Destroy invalid session: ", object, ", ", iSession.isInactive(l), ", ", !iSession.isAlive(l));
                            this.destroy(object);
                        }
                        catch (RuntimeException runtimeException) {
                            if (record == null) throw runtimeException;
                            record.setException(runtimeException);
                            throw runtimeException;
                        }
                        var12_9 = null;
                    }
                    catch (Throwable throwable) {
                        var12_9 = null;
                        CommonUtil.close(record);
                        throw throwable;
                    }
                    CommonUtil.close(record);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            serverContext.release();
            throw throwable;
        }
    }

    private ChangedHashtable<String, Object> getInitialProperties(ChangedHashtable<String, Object> changedHashtable, IRequest iRequest) throws Exception {
        String string;
        ServerContext serverContext;
        Hashtable<String, Object> hashtable;
        Object object;
        ChangedHashtable<String, Object> changedHashtable2 = changedHashtable != null ? changedHashtable : new ChangedHashtable();
        changedHashtable2.put("server.server_version", "0.4.1");
        changedHashtable2.put("server.spec_version", "0.4.1");
        try {
            object = InetAddress.getLocalHost();
            changedHashtable2.put("server.hostname", ((InetAddress)object).getHostName());
            changedHashtable2.put("server.address", ((InetAddress)object).getHostAddress());
        }
        catch (Exception exception) {
            this.log.error(exception);
        }
        changedHashtable2.put("server.session.creationTime", new Date());
        if (ProtocolFactory.getInstance() != null) {
            changedHashtable2.put("server.usingProtocol", "true");
        }
        String string2 = "server.sysprop.";
        int n = USED_SYSPROPS.length;
        for (int i = 0; i < n; ++i) {
            object = System.getProperty(USED_SYSPROPS[i]);
            if (object == null) continue;
            changedHashtable2.put(string2 + USED_SYSPROPS[i], object);
        }
        if (iRequest != null && (hashtable = iRequest.getProperties()) != null) {
            string2 = "server.request.";
            for (Map.Entry<String, Object> entry : hashtable.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                changedHashtable2.put(string2 + entry.getKey(), (String)entry.getValue());
            }
        }
        if ((serverContext = ServerContext.getCurrentInstance()) != null && (string = serverContext.getSystemIdentifier()) != null) {
            changedHashtable2.put("server.request.systemIdentifier", new SystemIdentifier(string));
        }
        return changedHashtable2;
    }

    protected void postCreateSession(ISession iSession) {
    }

    protected void postCreateSubSession(ISession iSession, ISession iSession2) {
    }

    protected void sessionCreationError(Throwable throwable) {
    }

    protected void subSessionCreationError(Throwable throwable) {
    }

    public boolean isInitializing(ISession iSession) {
        return iSession != null && iSession.getProperties().get(PROPERTY_INIT) == INIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Object object) {
        if (object != null) {
            ISession iSession;
            Object object2 = object instanceof ISession ? ((ISession)object).getId() : object;
            Object object3 = this.oSync;
            synchronized (object3) {
                iSession = this.htSessions.get(object2);
            }
            if (iSession != null) {
                long l = System.currentTimeMillis();
                return !iSession.isInactive(l) && iSession.isAlive(l);
            }
        }
        return false;
    }

    public static void setControllerInterval(long l) {
        lControllerInterval = l <= 0L ? 10000L : l;
    }

    public static long getControllerInterval() {
        return lControllerInterval;
    }

    private CacheMode getCacheMode(ISession iSession) {
        CacheMode cacheMode = (CacheMode)((Object)iSession.getProperty("server.session.cacheMode"));
        if (cacheMode != null) {
            return cacheMode;
        }
        IConfiguration iConfiguration = iSession.getConfig();
        String string = iConfiguration.getProperty("/application/securitymanager/cacheMode");
        try {
            cacheMode = CacheMode.valueOf(StringUtil.formatInitCap(string));
        }
        catch (Exception exception) {
            cacheMode = CacheMode.Application;
        }
        if (iSession instanceof SubSession) {
            ((SubSession)iSession).getMasterSession().setProperty("server.session.cacheMode", (Object)cacheMode);
        }
        iSession.setProperty("server.session.cacheMode", (Object)cacheMode);
        return cacheMode;
    }

    ISession getMasterSession(ISession iSession) {
        if (iSession instanceof SubSession) {
            return ((SubSession)iSession).getMasterSession();
        }
        return iSession;
    }

    boolean hasPushReceiver(ISession iSession) {
        return this.htPushReceiver.get(iSession.getId()) != null;
    }

    static final class SystemIdentifier {
        String systemIdentifier;

        private SystemIdentifier(String string) {
            this.systemIdentifier = string;
        }

        public String toString() {
            return this.systemIdentifier;
        }
    }

    private final class Controller
    extends Thread {
        private Controller() {
        }

        public void run() {
            try {
                while (!ThreadHandler.isStopped()) {
                    DefaultSessionManager.this.validateSessions();
                    Thread.sleep(lControllerInterval);
                }
            }
            catch (Throwable throwable) {
                DefaultSessionManager.this.log.debug(throwable);
            }
            DefaultSessionManager.this.log.error("Controller stopped: ", this.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheMode {
        Application,
        Session;

    }
}

