/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import javax.rad.server.ISession;
import javax.rad.server.event.ISessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monitoring
implements ISessionListener {
    private Server server = null;
    private Object oLastDestroyedSessionId = null;

    public Monitoring(Server server) {
        this.server = server;
        this.server.getSessionManager().addSessionListener(this);
    }

    @Override
    public void sessionCreated(ISession iSession) {
    }

    @Override
    public void sessionDestroyed(ISession iSession) {
        if (iSession != null) {
            this.oLastDestroyedSessionId = iSession.getId();
        }
    }

    public long getServerStartupTime() {
        return this.server.getStartupTime();
    }

    public int getSessionCount() {
        return this.server.getSessionManager().getSessionCount();
    }

    public Object getLastDestroyedSessionId() {
        return this.oLastDestroyedSessionId;
    }

    public ArrayUtil<Object> getSessionIds() {
        return this.server.getSessionManager().getSessionIds();
    }

    public ArrayUtil<Object> getMasterSessionIds() {
        return this.getMasterSessionIds(null);
    }

    public ArrayUtil<Object> getMasterSessionIds(String string) {
        DefaultSessionManager defaultSessionManager = this.server.getSessionManager();
        ArrayUtil<Object> arrayUtil = defaultSessionManager.getSessionIds();
        for (int i = arrayUtil.size() - 1; i >= 0; --i) {
            try {
                AbstractSession abstractSession = defaultSessionManager.get(arrayUtil.get(i));
                if (!(abstractSession instanceof MasterSession)) {
                    arrayUtil.remove(i);
                    continue;
                }
                if (string == null || string.equals(abstractSession.getApplicationName())) continue;
                arrayUtil.remove(i);
                continue;
            }
            catch (Throwable throwable) {
                arrayUtil.remove(i);
            }
        }
        return arrayUtil;
    }

    public ArrayUtil<Object> getSubSessionIds(Object object) {
        ArrayUtil<Object> arrayUtil;
        block5: {
            DefaultSessionManager defaultSessionManager = this.server.getSessionManager();
            arrayUtil = new ArrayUtil<Object>();
            try {
                AbstractSession abstractSession = defaultSessionManager.get(object);
                if (abstractSession instanceof MasterSession) {
                    ArrayUtil<SubSession> arrayUtil2 = ((MasterSession)abstractSession).getSubSessions();
                    if (arrayUtil2 != null) {
                        int n = arrayUtil2.size();
                        for (int i = 0; i < n; ++i) {
                            arrayUtil.add(arrayUtil2.get(i).getId());
                        }
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Given session is not a master session!");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayUtil;
    }

    public void closeConnections(String string) {
        DefaultSessionManager defaultSessionManager = this.server.getSessionManager();
        ArrayUtil<Object> arrayUtil = defaultSessionManager.getSessionIds();
        for (Object e : arrayUtil) {
            try {
                AbstractSession abstractSession = defaultSessionManager.get(e);
                if (!string.equals(abstractSession.getApplicationName())) continue;
                this.server.destroySession(e);
            }
            catch (Throwable throwable) {}
        }
        this.releaseSecurityManager(defaultSessionManager.getSecurityManagerFromCache(string));
    }

    public void releaseSecurityManager(String string) {
        this.releaseSecurityManager(this.server.getSessionManager().getSecurityManagerFromCache(string));
    }

    private void releaseSecurityManager(ISecurityManager[] iSecurityManagerArray) {
        if (iSecurityManagerArray != null) {
            for (int i = 0; i < iSecurityManagerArray.length; ++i) {
                iSecurityManagerArray[i].release();
            }
        }
    }
}

