/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import java.util.Hashtable;
import javax.rad.server.ICloseableSession;
import javax.rad.server.IConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WrappedSession
implements ICloseableSession {
    protected final AbstractSession session;
    private final boolean bCloseable;

    WrappedSession(AbstractSession abstractSession) {
        this(abstractSession, false);
    }

    WrappedSession(AbstractSession abstractSession, boolean bl) {
        this.session = abstractSession;
        this.bCloseable = bl;
    }

    @Override
    public Object getId() {
        return this.session.getId();
    }

    @Override
    public String getLifeCycleName() {
        return this.session.getLifeCycleName();
    }

    @Override
    public String getApplicationName() {
        return this.session.getApplicationName();
    }

    @Override
    public String getUserName() {
        return this.session.getUserName();
    }

    @Override
    public String getPassword() {
        return this.session.getPassword();
    }

    @Override
    public Object getProperty(String string) {
        return this.session.getProperty(string);
    }

    @Override
    public Hashtable<String, Object> getProperties() {
        return (Hashtable)this.session.getProperties().clone();
    }

    @Override
    public void setProperty(String string, Object object) {
        if (string != null && string.startsWith("client.")) {
            throw new SecurityException("It's not allowed to change client properties through the SessionContext!");
        }
        this.session.setProperty(string, object);
    }

    @Override
    public long getStartTime() {
        return this.session.getStartTime();
    }

    @Override
    public long getLastAccessTime() {
        return this.session.getLastAccessTime();
    }

    @Override
    public long getLastAliveTime() {
        return this.session.getLastAliveTime();
    }

    @Override
    public void setAliveInterval(long l) {
        this.session.setAliveInterval(l);
    }

    @Override
    public long getAliveInterval() {
        return this.session.getAliveInterval();
    }

    @Override
    public boolean isAlive(long l) {
        return this.session.isAlive(l);
    }

    @Override
    public void setMaxInactiveInterval(int n) {
        this.session.setMaxInactiveInterval(n);
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public boolean isInactive(long l) {
        return this.session.isInactive(l);
    }

    @Override
    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        return this.session.call(string, string2, objectArray);
    }

    @Override
    public Object callAction(String string, Object ... objectArray) throws Throwable {
        return this.session.callAction(string, objectArray);
    }

    @Override
    public Object get(String string) throws Throwable {
        return this.session.get(string);
    }

    @Override
    public Object put(String string, Object object) throws Throwable {
        return this.session.put(string, object);
    }

    @Override
    public IConfiguration getConfig() {
        return this.session.getApplicationZone().getConfig();
    }

    @Override
    public void close() {
        if (!this.bCloseable) {
            throw new SecurityException("It's not allowed to close the session!");
        }
        this.session.getSessionManager().destroy(this.session);
    }

    public boolean isValid() {
        return this.session != null && this.session.getSessionManager().isValid(this.session);
    }
}

