/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.AppSettings;
import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.IVirtualZone;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.rad.server.config.UpToDateConfigFile;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private static final String NAME_RAD = "rad";
    private static final String NAME_APPS = "apps";
    private static final String NAME_SERVER = "server";
    private static String sOldBaseDir = null;
    private static File fiBaseDir = null;
    private static File fiConfigDir = null;
    private static File fiAppsDir = null;
    private static File fiServerDir = null;
    private static Hashtable<String, ApplicationZone> htAppZones = null;
    private static ServerZone zoServer = null;
    private static AppSettings asApps = null;

    private Configuration() {
    }

    private static void initDirectories() {
        String string = ResourceUtil.getAccessibleProperty("Configuration.basedir", "");
        if (sOldBaseDir == null || !string.equals(sOldBaseDir)) {
            Configuration.clearCache();
            String string2 = ResourceUtil.getFqClassName(Configuration.class);
            String string3 = ResourceUtil.getLocationForClass(string2);
            if (string3 != null) {
                Object object;
                Object object2;
                if (string.trim().length() == 0 || !new File(string).exists()) {
                    object2 = new File(string3);
                    if (!((File)object2).isDirectory()) {
                        object2 = new File(((File)object2).getParentFile().getParentFile(), "classes");
                    }
                    fiBaseDir = ((File)object2).getParentFile();
                } else {
                    fiBaseDir = new File(string);
                }
                fiConfigDir = new File(fiBaseDir, NAME_RAD);
                if (!fiConfigDir.exists()) {
                    object2 = fiBaseDir;
                    for (int i = 0; object2 != null && i < 5; ++i) {
                        object = ((File)object2).getName();
                        if (((String)object).equalsIgnoreCase(NAME_APPS) || ((String)object).equalsIgnoreCase(NAME_SERVER)) {
                            if ((object2 = ((File)object2).getParentFile()) == null || !((File)object2).getName().equals(NAME_RAD)) continue;
                            fiBaseDir = ((File)object2).getParentFile();
                            fiConfigDir = new File(fiBaseDir, NAME_RAD);
                            object2 = null;
                            continue;
                        }
                        object2 = ((File)object2).getParentFile();
                    }
                }
                if (!fiConfigDir.exists()) {
                    Object object3;
                    Object object4;
                    object2 = null;
                    object = null;
                    try {
                        object4 = ResourceUtil.getResource("/jvx_rad.jar");
                        object3 = ((URL)object4).openStream();
                        if (object3 != null) {
                            object = object4;
                            object2 = object3;
                        }
                    }
                    catch (Exception exception) {
                        LoggerFactory.getInstance(Configuration.class).debug("Loading /jvx_rad.jar failed!", exception);
                    }
                    if (object2 == null) {
                        object4 = ResourceUtil.getResource(ResourceUtil.getFqClassName(Configuration.class));
                        object3 = ((URL)object4).toExternalForm();
                        object3 = ((String)object3).substring(0, ((String)object3).indexOf(string2));
                        try {
                            int n = ((String)object3).lastIndexOf(47);
                            n = ((String)object3).lastIndexOf(47, n - 1);
                            String string4 = ((String)object3).substring(0, n);
                            object3 = string4 + "/lib/jvx_rad.jar";
                            try {
                                URL uRL = new URL((String)object3);
                                InputStream inputStream = uRL.openStream();
                                if (inputStream != null) {
                                    object = uRL;
                                    object2 = inputStream;
                                }
                            }
                            catch (Exception exception) {
                                LoggerFactory.getInstance(Configuration.class).debug("Loading /lib/jvx_rad.jar failed!", exception);
                            }
                            if (object2 == null) {
                                object3 = string4 + "/rad.zip";
                                object = new URL((String)object3);
                                object2 = ((URL)object).openStream();
                            }
                        }
                        catch (Exception exception) {
                            object = null;
                            LoggerFactory.getInstance(Configuration.class).debug("Loading /rad.zip failed!", exception);
                        }
                    }
                    if (object2 != null) {
                        try {
                            object4 = SecureHash.getHash("MD5", (InputStream)object2);
                            object2 = (InputStream)CommonUtil.close(object2);
                            object2 = ((URL)object).openStream();
                            object3 = new File(System.getProperty("java.io.tmpdir"), "rad_" + (String)object4);
                            if (!((File)object3).exists()) {
                                FileUtil.unzip((InputStream)object2, (File)object3);
                            }
                            fiConfigDir = new File((File)object3, NAME_RAD);
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Base directory is not available!", exception);
                        }
                    }
                }
                fiAppsDir = new File(fiConfigDir, NAME_APPS);
                fiServerDir = new File(fiConfigDir, NAME_SERVER);
                sOldBaseDir = string;
            }
        }
    }

    public static File getConfigurationDir() {
        Configuration.initDirectories();
        return fiConfigDir;
    }

    public static File getApplicationsDir() {
        Configuration.initDirectories();
        return fiAppsDir;
    }

    public static File getServerDir() {
        Configuration.initDirectories();
        return fiServerDir;
    }

    public static ApplicationZone getApplicationZone(String string) throws Exception {
        ApplicationZone applicationZone = null;
        if (string == null || string.trim().length() == 0) {
            applicationZone = new ApplicationZone((File)null);
        } else {
            if (htAppZones != null && (applicationZone = htAppZones.get(string)) != null) {
                applicationZone.setUpdateEnabled(true);
            }
            if (applicationZone != null && !applicationZone.isValid()) {
                htAppZones.remove(string);
                applicationZone = null;
            }
            if (applicationZone == null) {
                Object object;
                Object object2;
                int n;
                Object object3;
                Object object4;
                File file = new File(Configuration.getApplicationsDir(), string);
                if (!ApplicationZone.isValid(file)) {
                    object4 = Configuration.getAppSettings();
                    object3 = ((AppSettings)object4).getAppLocations();
                    if (object3 != null) {
                        int n2 = object3.size();
                        for (n = 0; n < n2 && applicationZone == null; ++n) {
                            object2 = object3.get(n);
                            object = new File(((AppSettings.AppLocation)object2).getPath(), string);
                            if (!ApplicationZone.isValid((File)object)) continue;
                            applicationZone = new ApplicationZone((File)object);
                        }
                    }
                } else {
                    applicationZone = new ApplicationZone(file);
                }
                if (applicationZone == null) {
                    object = new XmlWorker();
                    n = 0;
                    for (object4 = Configuration.getApplicationsDir(); object4 != null && applicationZone == null && n < 5; object4 = ((File)object4).getParentFile()) {
                        ++n;
                        object3 = new File((File)object4, "config.xml");
                        if (!((File)object3).exists() || !((File)object3).canRead()) continue;
                        if (string.equals(((File)object4).getName())) {
                            applicationZone = new ApplicationZone((File)object4);
                            continue;
                        }
                        try {
                            object2 = ((XmlWorker)object).read((File)object3);
                            if (object2 != null && ((XmlNode)object2).size() != 0 && ((XmlNode)object2).getNode("/application") == null) continue;
                            applicationZone = new ApplicationZone((File)object4);
                            continue;
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Invalid config.xml '", object3, "'", exception);
                        }
                    }
                }
                if (applicationZone == null && (object4 = Configuration.loadConfiguration(string.toLowerCase())) != null) {
                    applicationZone = new ApplicationZone((InputStream)object4);
                }
                if (applicationZone == null && Configuration.isSearchClassPath()) {
                    object4 = ResourceUtil.getResourceAsStream("/rad/apps/" + string.toLowerCase() + "/config.xml");
                    if (object4 == null) {
                        object4 = ResourceUtil.getResourceAsStream(string.toLowerCase() + ".xml");
                    }
                    if (object4 == null) {
                        object4 = ResourceUtil.getResourceAsStream("/config.xml");
                    }
                    if (object4 != null) {
                        applicationZone = new ApplicationZone((InputStream)object4);
                    }
                }
                if (applicationZone == null) {
                    applicationZone = new ApplicationZone(file);
                }
                if (htAppZones == null) {
                    htAppZones = new Hashtable();
                }
                htAppZones.put(string, applicationZone);
            }
        }
        return applicationZone;
    }

    public static ServerZone getServerZone() {
        if (zoServer == null) {
            Object object;
            Object object2;
            File file = Configuration.getServerDir();
            if (file != null) {
                if (!file.exists()) {
                    XmlWorker xmlWorker = new XmlWorker();
                    Object var5_5 = null;
                    int n = 0;
                    for (object2 = file; object2 != null && var5_5 == null && n < 5; object2 = ((File)object2).getParentFile()) {
                        ++n;
                        object = new File((File)object2, "server.xml");
                        if (!((File)object).exists() || !((File)object).canRead()) continue;
                        try {
                            XmlNode xmlNode = xmlWorker.read((File)object);
                            if (xmlNode != null && xmlNode.size() != 0 && xmlNode.getNode("/server") == null) continue;
                            zoServer = new ServerZone((File)object2, "server.xml");
                            return zoServer;
                        }
                        catch (Exception exception) {
                            LoggerFactory.getInstance(Configuration.class).debug("Invalid server.xml '", object, "'", exception);
                        }
                    }
                } else {
                    try {
                        object2 = new ServerZone(file);
                        if (((UpToDateConfigFile)object2).getNode("/server") != null) {
                            zoServer = object2;
                            return zoServer;
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
            if ((object2 = Configuration.loadConfiguration(NAME_SERVER)) != null) {
                try {
                    zoServer = new ServerZone((InputStream)object2);
                    return zoServer;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (Configuration.isSearchClassPath()) {
                object = ResourceUtil.getResourceAsStream("/rad/server/config.xml");
                if (object == null) {
                    object = ResourceUtil.getResourceAsStream("/server.xml");
                }
                if (object != null) {
                    try {
                        zoServer = new ServerZone((InputStream)object);
                        return zoServer;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
            zoServer = new ServerZone();
        } else if (!zoServer.isValid()) {
            zoServer = null;
        } else {
            zoServer.setUpdateEnabled(true);
        }
        return zoServer;
    }

    public static List<String> listApplicationNames(ApplicationListOption applicationListOption) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (File file : Configuration.listApplicationDirectories(applicationListOption)) {
            arrayUtil.add(file.getName());
        }
        return arrayUtil;
    }

    public static boolean isApplication(String string) {
        if (string != null) {
            if (!ApplicationZone.isValid(new File(Configuration.getApplicationsDir(), string))) {
                AppSettings appSettings = Configuration.getAppSettings();
                List<AppSettings.AppLocation> list = appSettings.getAppLocations();
                if (list != null) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        File file = new File(list.get(i).getPath(), string);
                        if (!ApplicationZone.isValid(file)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static AppSettings getAppSettings() {
        if (asApps == null) {
            Configuration.initDirectories();
            try {
                asApps = new AppSettings(fiConfigDir);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return asApps;
    }

    public static List<File> listApplicationDirectories(ApplicationListOption applicationListOption) {
        ArrayUtil<File> arrayUtil = new ArrayUtil<File>();
        File[] fileArray = Configuration.getApplicationsDir().listFiles();
        AppSettings appSettings = Configuration.getAppSettings();
        List<AppSettings.AppLocation> list = appSettings.getAppLocations();
        if (list != null) {
            for (AppSettings.AppLocation object : list) {
                File[] fileArray2;
                File file = new File(object.getPath());
                if (!file.exists() || (fileArray2 = file.listFiles()) == null || fileArray2.length <= 0) continue;
                for (int i = 0; i < fileArray2.length; ++i) {
                    if (!fileArray2[i].isDirectory() || !object.isIncluded(fileArray2[i].getName())) continue;
                    fileArray = ArrayUtil.add(fileArray, fileArray2[i]);
                }
            }
        }
        if (fileArray != null) {
            if (applicationListOption == null) {
                applicationListOption = ApplicationListOption.Visible;
            }
            block6: for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                switch (applicationListOption) {
                    case Hidden: {
                        if (!file.isHidden() && file.getName().charAt(0) != '.') continue block6;
                        arrayUtil.add(file);
                        continue block6;
                    }
                    case Visible: {
                        if (file.isHidden() || file.getName().charAt(0) == '.') continue block6;
                        arrayUtil.add(file);
                        continue block6;
                    }
                    default: {
                        arrayUtil.add(file);
                    }
                }
            }
        }
        return arrayUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadConfiguration(String string) {
        try {
            InputStream inputStream;
            InitialContext initialContext;
            block12: {
                InputStream inputStream2;
                block11: {
                    InputStream inputStream3;
                    block10: {
                        InputStream inputStream4;
                        block9: {
                            ByteArrayInputStream byteArrayInputStream;
                            block8: {
                                initialContext = new InitialContext();
                                try {
                                    Object object = initialContext.lookup("java:/comp/env/jvx/" + string + "/config");
                                    if (object instanceof String) {
                                        InputStream inputStream5 = ResourceUtil.getResourceAsStream((String)object);
                                        if (inputStream5 == null) {
                                            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(((String)object).getBytes("UTF-8"));
                                            XmlWorker.readNode(byteArrayInputStream2);
                                            byteArrayInputStream2.reset();
                                            byteArrayInputStream = byteArrayInputStream2;
                                            Object var7_11 = null;
                                            break block8;
                                        }
                                        inputStream4 = inputStream5;
                                        break block9;
                                    }
                                    if (object instanceof IVirtualZone) {
                                        inputStream3 = ((IVirtualZone)object).getConfiguration();
                                        break block10;
                                    }
                                    if (object instanceof InputStream) {
                                        inputStream2 = (InputStream)object;
                                        break block11;
                                    }
                                    inputStream = null;
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    Object var7_16 = null;
                                    initialContext.close();
                                    throw throwable;
                                }
                            }
                            initialContext.close();
                            return byteArrayInputStream;
                        }
                        Object var7_12 = null;
                        initialContext.close();
                        return inputStream4;
                    }
                    Object var7_13 = null;
                    initialContext.close();
                    return inputStream3;
                }
                Object var7_14 = null;
                initialContext.close();
                return inputStream2;
            }
            Object var7_15 = null;
            initialContext.close();
            return inputStream;
        }
        catch (Exception exception) {
            LoggerFactory.getInstance(Configuration.class).debug("Couldn't load virtual zone '", string, "' via JNDI!", exception);
            return null;
        }
    }

    public static void clearCache() {
        zoServer = null;
        htAppZones = null;
        asApps = null;
    }

    public static boolean isSearchClassPath() {
        return ResourceUtil.getAccessibleBoolean("Configuration.search.classpath", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationListOption {
        All,
        Visible,
        Hidden;

    }
}

