/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http.rest;

import com.sibvisions.rad.server.DirectServerSession;
import com.sibvisions.rad.server.http.HttpContext;
import com.sibvisions.rad.server.http.rest.LifeCycleConnector;
import com.sibvisions.rad.server.http.rest.RESTAdapter;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.util.HashMap;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class SecurityManagerVerifier
implements Verifier {
    private RESTAdapter adapter;
    private boolean bIgnoreChallengeResponse;

    public SecurityManagerVerifier(RESTAdapter rESTAdapter) {
        this(rESTAdapter, false);
    }

    public SecurityManagerVerifier(RESTAdapter rESTAdapter, boolean bl) {
        this.adapter = rESTAdapter;
        this.bIgnoreChallengeResponse = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int verify(Request request, Response response) {
        Throwable throwable4;
        int n;
        if (!this.bIgnoreChallengeResponse && request.getChallengeResponse() == null) {
            return 0;
        }
        String string = (String)request.getAttributes().get("APP_NAME");
        if (string == null) {
            return 0;
        }
        String string2 = this.getIdentifier(request, response);
        String string3 = this.getSecret(request, response);
        HttpContext httpContext = null;
        httpContext = new HttpContext(ServletUtils.getRequest((Request)request), ServletUtils.getResponse((Response)response));
        DirectServerSession directServerSession = null;
        try {
            HashMap<String, Object> hashMap = RESTAdapter.createConnectionProperties(this.adapter, request);
            directServerSession = DirectServerSession.createMasterSession(string, string2, string3, hashMap);
            this.adapter.configureSession(directServerSession);
            request.getClientInfo().setUser((User)new LifeCycleConnector(this.adapter, directServerSession, hashMap, (String)request.getAttributes().get("LCO_CLASS")));
            n = 4;
        }
        catch (Throwable throwable2) {
            try {
                if (!this.bIgnoreChallengeResponse) {
                    LoggerFactory.getInstance(SecurityManagerVerifier.class).error(throwable2);
                }
                if (directServerSession != null) {
                    try {
                        directServerSession.destroy();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                int n2 = -1;
                Object var11_14 = null;
                httpContext.release();
                return n2;
            }
            catch (Throwable throwable4) {
                Object var11_15 = null;
                httpContext.release();
            }
        }
        Object var11_13 = null;
        httpContext.release();
        return n;
        throw throwable4;
    }

    protected String getIdentifier(Request request, Response response) {
        String string;
        ChallengeResponse challengeResponse;
        if (!this.bIgnoreChallengeResponse && (challengeResponse = request.getChallengeResponse()) != null && !StringUtil.isEmpty(string = challengeResponse.getIdentifier())) {
            return string;
        }
        return null;
    }

    protected String getSecret(Request request, Response response) {
        char[] cArray;
        ChallengeResponse challengeResponse;
        if (!this.bIgnoreChallengeResponse && (challengeResponse = request.getChallengeResponse()) != null && (cArray = challengeResponse.getSecret()) != null && cArray.length > 0) {
            return new String(cArray);
        }
        return null;
    }
}

