/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.annotation.Replacement;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.LoggerFactory;

public class DefaultAccessController
implements IAccessController {
    private ArrayUtil<String> auAllowedLCO = null;

    public boolean isAllowed(String string) {
        if (string != null && this.auAllowedLCO != null) {
            return this.auAllowedLCO.contains(string);
        }
        return false;
    }

    public void addAccess(String string) {
        if (string == null) {
            return;
        }
        if (this.auAllowedLCO == null || !this.auAllowedLCO.contains(string)) {
            if (this.auAllowedLCO == null) {
                this.auAllowedLCO = new ArrayUtil();
            }
            this.auAllowedLCO.add(string);
        }
    }

    public void removeAccess(String string) {
        if (string == null || this.auAllowedLCO == null) {
            return;
        }
        this.auAllowedLCO.remove(string);
        if (this.auAllowedLCO.size() == 0) {
            this.auAllowedLCO = null;
        }
    }

    public String find(ClassLoader classLoader, String string) {
        if (string == null || this.auAllowedLCO == null) {
            return null;
        }
        String string2 = string;
        if (!string.startsWith(".")) {
            string2 = "." + string2;
        }
        int n = 0;
        String string3 = null;
        int n2 = this.auAllowedLCO.size();
        for (int i = 0; i < n2; ++i) {
            String string4 = this.auAllowedLCO.get(i);
            if (string.equals(string4)) {
                return string4;
            }
            if (!string4.endsWith(string2)) continue;
            ++n;
            string3 = string4;
        }
        if (n == 1) {
            return string3;
        }
        String string5 = string.startsWith(".") ? string.substring(1) : string;
        return this.findReplacement(classLoader, string5);
    }

    protected String findReplacement(ClassLoader classLoader, String string) {
        if (this.auAllowedLCO == null) {
            return null;
        }
        String string2 = null;
        int n = 0;
        int n2 = this.auAllowedLCO.size();
        for (int i = 0; i < n2; ++i) {
            String string3 = this.auAllowedLCO.get(i);
            try {
                Class<?> clazz = classLoader == null ? Class.forName(string3) : Class.forName(string3, false, classLoader);
                Replacement replacement = clazz.getAnnotation(Replacement.class);
                if (replacement == null || !string.equals(replacement.name())) continue;
                ++n;
                string2 = string3;
                continue;
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(DefaultAccessController.class).debug(exception);
            }
        }
        if (n == 1) {
            return string2;
        }
        return null;
    }

    protected void resetAccess() {
        this.auAllowedLCO = null;
    }

    protected int getAccessCount() {
        return this.auAllowedLCO == null ? 0 : this.auAllowedLCO.size();
    }
}

