/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.security.DBSecurityManager;
import com.sibvisions.rad.server.security.ntlm.NtlmAuthInfo;
import com.sibvisions.rad.server.security.ntlm.NtlmHelper;
import com.sibvisions.util.ObjectCache;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import javax.rad.server.ISession;

public class NtlmDBSecurityManager
extends DBSecurityManager {
    private ILogger log = LoggerFactory.getInstance(this.getClass());

    public void validateAuthentication(ISession iSession) throws Exception {
        NtlmAuthInfo ntlmAuthInfo = this.getAuthInfo(iSession);
        if (ntlmAuthInfo != null) {
            ((AbstractSession)iSession).setUserName(ntlmAuthInfo.getNtlmAuth().getUsername());
        } else {
            int n;
            String string = iSession.getUserName();
            if (string != null && (n = string.indexOf(92)) > 0) {
                ((AbstractSession)iSession).setUserName(string.substring(n + 1));
                iSession.setProperty("client.domain", string.substring(0, n));
            }
        }
        super.validateAuthentication(iSession);
    }

    protected boolean isPasswordValid(ISession iSession, String string) throws Exception {
        return super.isPasswordValid(iSession, string) || this.isNtlmAuthenticated(iSession);
    }

    protected boolean isNtlmAuthenticated(ISession iSession) {
        NtlmAuthInfo ntlmAuthInfo = this.getAuthInfo(iSession);
        if (ntlmAuthInfo != null) {
            return true;
        }
        NtlmHelper ntlmHelper = NtlmHelper.getInstance();
        ntlmHelper.setApplicatioName(iSession.getApplicationName());
        NtlmAuthInfo ntlmAuthInfo2 = null;
        try {
            String string = (String)iSession.getProperty("client.AuthLocal");
            ntlmAuthInfo2 = string != null ? ntlmHelper.logon() : ntlmHelper.logon((String)iSession.getProperty("client.domain"), iSession.getUserName(), iSession.getPassword());
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
        }
        return ntlmAuthInfo2 != null;
    }

    private NtlmAuthInfo getAuthInfo(ISession iSession) {
        Object object = iSession.getProperty("client.authkey");
        return (NtlmAuthInfo)ObjectCache.get(object);
    }
}

