/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.awt.impl.AwtDimension;
import com.sibvisions.rad.ui.celleditor.AbstractLinkedCellEditor;
import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxComboBase;
import com.sibvisions.rad.ui.swing.ext.JVxTable;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxIconRenderer;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxRendererContainer;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.IAlignmentConstants;
import javax.rad.ui.control.IPlaceholder;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.plaf.TextUIWrapper;
import org.jdesktop.swingx.prompt.PromptSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxLinkedCellEditor
extends AbstractLinkedCellEditor
implements ICellRenderer<JComponent> {
    private JVxRendererContainer cellRenderer = null;
    private DefaultTableCellRenderer textRenderer = null;
    private JVxIconRenderer iconRenderer = null;

    public JVxLinkedCellEditor() {
        this(null);
    }

    public JVxLinkedCellEditor(ReferenceDefinition referenceDefinition) {
        this.horizontalAlignment = -1;
        this.popupSize = new AwtDimension(400, 200);
        this.setLinkReference(referenceDefinition);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public JComponent getCellRendererComponent(JComponent jComponent, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxRendererContainer();
            this.textRenderer = new DefaultTableCellRenderer();
            this.textRenderer.setFont(null);
            this.textRenderer.setOpaque(false);
            this.iconRenderer = new JVxIconRenderer();
            this.iconRenderer.setImage(JVxUtil.getImage("/com/sibvisions/rad/ui/swing/ext/images/combobox.png"));
            this.iconRenderer.setOpaque(false);
            this.cellRenderer.add((Component)this.textRenderer, "Center");
            this.cellRenderer.add((Component)this.iconRenderer, "East");
        }
        this.textRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getDefaultHorizontalAlignment(iDataRow, string)));
        this.textRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        IDataBook iDataBook = iDataPage.getDataBook();
        try {
            this.iconRenderer.setVisible(bl && !iDataBook.isReadOnly() && iDataBook.isUpdateAllowed() && !iDataBook.getRowDefinition().getColumnDefinition(string).isReadOnly());
        }
        catch (Exception exception) {
            this.iconRenderer.setVisible(false);
        }
        try {
            this.textRenderer.setText(this.getDisplayValue(iDataRow, string));
        }
        catch (Exception exception) {
            this.textRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    extends AbstractListModel
    implements ICellEditorHandler<JComponent>,
    ComboBoxModel,
    DocumentListener,
    KeyListener,
    PopupMenuListener,
    FocusListener,
    MouseListener,
    Runnable {
        private JVxLinkedCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String[] columnNames;
        private String[] referencedColumnNames;
        private String columnName;
        private String referencedColumnName;
        private String[] clearColumns;
        private String[] additionalClearColumns;
        private IDataBook referencedDataBook;
        private JVxComboBase cellEditorComponent;
        private IAlignmentConstants dynamicAlignment = null;
        private JVxTable table;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;
        private boolean popupChanged = false;

        public CellEditorHandler(JVxLinkedCellEditor jVxLinkedCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            int n;
            this.cellEditor = jVxLinkedCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.columnNames = this.cellEditor.linkReference.getColumnNames();
            this.referencedColumnNames = this.cellEditor.linkReference.getReferencedColumnNames();
            if (this.columnNames.length == 0 && this.referencedColumnNames.length == 1) {
                this.columnNames = new String[]{string};
            }
            if ((n = ArrayUtil.indexOf(this.columnNames, this.columnName)) < 0) {
                throw new IllegalArgumentException("The edited column " + this.columnName + " has to be part of in column names list in LinkReference!");
            }
            this.referencedColumnName = this.referencedColumnNames[n];
            this.referencedDataBook = this.cellEditor.linkReference.getReferencedDataBook();
            this.referencedDataBook.setSelectionMode(IDataBook.SelectionMode.DESELECTED);
            try {
                this.clearColumns = this.cellEditor.getClearColunms(this.dataRow, this.columnName);
                this.additionalClearColumns = this.cellEditor.getAdditionalClearColumns(this.dataRow);
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.table = new JVxTable();
            this.table.setDataBook(this.referencedDataBook);
            this.table.setBorder(BorderFactory.createEmptyBorder());
            this.table.setAutoResize(true);
            this.table.getJTable().setFocusable(false);
            this.cellEditorComponent = new JVxComboBase();
            this.cellEditorComponent.setPopupComponent(this.table);
            this.cellEditorComponent.setModel(this);
            if (this.cellEditor.getPopupSize() != null) {
                this.cellEditorComponent.setPopupSize((Dimension)this.cellEditor.getPopupSize().getResource());
            }
            if (this.cellEditorComponent.getEditorComponent() instanceof JTextField) {
                if (this.cellEditorListener.getControl() instanceof IAlignmentConstants && this.cellEditorListener.getControl() instanceof IEditorControl) {
                    this.dynamicAlignment = (IAlignmentConstants)((Object)this.cellEditorListener.getControl());
                } else {
                    ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getDefaultHorizontalAlignment(this.dataRow, this.columnName)));
                }
            }
            PromptSupport.setFocusBehavior((PromptSupport.FocusBehavior)PromptSupport.FocusBehavior.SHOW_PROMPT, (JTextComponent)this.cellEditorComponent.getEditorComponent());
            this.cellEditorComponent.getEditorComponent().getDocument().addDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().addKeyListener(this);
            this.cellEditorComponent.getEditorComponent().addFocusListener(this);
            this.cellEditorComponent.getEditorComponent().setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addPopupMenuListener(this);
            this.table.getJTable().addMouseListener(this);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getEditorComponent().getDocument().removeDocumentListener(this);
            this.cellEditorComponent.getEditorComponent().removeKeyListener(this);
            this.cellEditorComponent.getEditorComponent().removeFocusListener(this);
            this.cellEditorComponent.removePopupMenuListener(this);
            this.table.getJTable().removeKeyListener(this);
            this.table.getJTable().removeMouseListener(this);
            this.table.setDataBook(null);
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        private void setValuesAndClearIfNecessary(Object[] objectArray, Object object) throws ModelException {
            IDataRow iDataRow = this.dataRow.createDataRow(null);
            if (objectArray == null) {
                IDataRow iDataRow2 = this.dataRow.createDataRow(null);
                iDataRow2.setValues(this.clearColumns, null);
                iDataRow2.setValue(this.columnName, object);
                objectArray = iDataRow2.getValues(this.columnNames);
            }
            this.dataRow.setValues(this.columnNames, objectArray);
            if (!this.dataRow.equals(iDataRow, this.columnNames)) {
                this.dataRow.setValues(this.additionalClearColumns, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveEditing() throws ModelException {
            try {
                if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                    this.setValuesAndClearIfNecessary(this.referencedDataBook.getValues(this.referencedColumnNames), null);
                } else {
                    Object object = this.cellEditorComponent.getEditor().getItem();
                    if (object == null || "".equals(object)) {
                        this.setValuesAndClearIfNecessary(null, null);
                    } else {
                        this.referencedDataBook.setFilter(this.cellEditor.getSearchCondition(this.dataRow, this.cellEditor.getItemSearchCondition(false, this.getRelevantSearchColumnName(), object)));
                        if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                            this.setValuesAndClearIfNecessary(this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames), null);
                        } else if (this.cellEditor.isValidationEnabled()) {
                            this.referencedDataBook.setFilter(this.cellEditor.getSearchCondition(this.dataRow, this.cellEditor.getItemSearchCondition(true, this.getRelevantSearchColumnName(), object)));
                            if (this.referencedDataBook.getDataRow(0) != null && this.referencedDataBook.getDataRow(1) == null) {
                                this.setValuesAndClearIfNecessary(this.referencedDataBook.getDataRow(0).getValues(this.referencedColumnNames), null);
                            } else {
                                this.setValuesAndClearIfNecessary(this.dataRow.getValues(this.columnNames), null);
                            }
                        } else {
                            try {
                                object = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType().convertAndCheckToTypeClass(object);
                            }
                            catch (Exception exception) {
                                this.setValuesAndClearIfNecessary(this.dataRow.getValues(this.columnNames), null);
                                Object var4_3 = null;
                                this.popupChanged = false;
                                return;
                            }
                            this.setValuesAndClearIfNecessary(null, object);
                        }
                    }
                }
                Object var4_4 = null;
                this.popupChanged = false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.popupChanged = false;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                try {
                    try {
                        Font font;
                        Color color;
                        Object object;
                        boolean bl;
                        ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                        this.cellEditorComponent.setTranslation(this.cellEditorListener.getControl().getTranslation());
                        this.cellEditorComponent.setTranslationEnabled(this.cellEditorListener.getControl().isTranslationEnabled());
                        Object object2 = this.cellEditorComponent.getTreeLock();
                        synchronized (object2) {
                            this.cellEditorComponent.setSelectedItem(this.cellEditor.getDisplayValue(this.dataRow, this.columnName));
                        }
                        object2 = null;
                        Container container = this.cellEditorComponent.getParent();
                        boolean bl2 = bl = container == null || container.isEnabled();
                        if (this.dataRow instanceof IDataBook) {
                            boolean bl3;
                            object = (IDataBook)this.dataRow;
                            boolean bl4 = bl3 = bl && object.isUpdateAllowed() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0;
                            if (bl3 && object.getReadOnlyChecker() != null) {
                                try {
                                    bl3 = !object.getReadOnlyChecker().isReadOnly((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            this.cellEditorComponent.setEditorEditable(bl3);
                        } else {
                            this.cellEditorComponent.setEditorEditable(bl && !columnDefinition.isReadOnly());
                        }
                        if (this.cellEditorListener.getCellFormatter() != null) {
                            object = null;
                            IDataPage iDataPage = null;
                            int n = -1;
                            if (this.dataRow instanceof IDataBook) {
                                object = (IDataBook)this.dataRow;
                                iDataPage = object.getDataPage();
                                n = object.getSelectedRow();
                            } else if (this.dataRow instanceof IChangeableDataRow) {
                                iDataPage = ((IChangeableDataRow)this.dataRow).getDataPage();
                                n = ((IChangeableDataRow)this.dataRow).getRowIndex();
                                if (iDataPage != null) {
                                    object = iDataPage.getDataBook();
                                }
                            }
                            try {
                                object2 = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, iDataPage, this.dataRow, this.columnName, n, -1);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (object2 == null) {
                            object = null;
                            color = null;
                            font = null;
                        } else {
                            object = ((CellFormat)object2).getBackground();
                            color = ((CellFormat)object2).getForeground();
                            font = ((CellFormat)object2).getFont();
                        }
                        if (font == null) {
                            font = ((Component)((Object)this.cellEditorListener)).getFont();
                        }
                        if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                            color = ((Component)((Object)this.cellEditorListener)).getForeground();
                        }
                        if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                            object = ((Component)((Object)this.cellEditorListener)).getBackground();
                        }
                        this.cellEditorComponent.getEditorComponent().setFont(font);
                        if (this.cellEditorComponent.isEditorEditable()) {
                            if (object == null) {
                                object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                            }
                            if (this.cellEditorComponent.getEditorComponent().hasFocus()) {
                                this.cellEditorComponent.getEditorComponent().selectAll();
                            } else {
                                this.cellEditorComponent.getEditorComponent().select(0, 0);
                            }
                        } else if (object == null) {
                            object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                            this.cellEditorComponent.getEditorComponent().select(0, 0);
                        }
                        this.cellEditorComponent.getEditorComponent().setBackground((Color)object);
                        this.cellEditorComponent.getEditorComponent().setForeground(color);
                        this.cellEditorComponent.setBackground((Color)object);
                        this.cellEditorComponent.setForeground(color);
                        if (this.dynamicAlignment != null) {
                            int n = this.dynamicAlignment.getHorizontalAlignment();
                            if (n == -1) {
                                n = this.cellEditor.getDefaultHorizontalAlignment(this.dataRow, this.columnName);
                            }
                            ((JTextField)this.cellEditorComponent.getEditorComponent()).setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(n));
                        }
                        if (container instanceof JComponent) {
                            this.cellEditorComponent.getEditorComponent().putClientProperty("tabIndex", ((JComponent)container).getClientProperty("tabIndex"));
                        }
                        if (this.cellEditorListener.getControl() instanceof IPlaceholder) {
                            String string = this.cellEditor.getPlaceholderText((IPlaceholder)((Object)this.cellEditorListener.getControl()), columnDefinition.getLabel());
                            Font font2 = this.cellEditorComponent.getEditorComponent().getFont();
                            if (string == null) {
                                TextUIWrapper.getDefaultWrapper().uninstall(this.cellEditorComponent.getEditorComponent());
                            } else {
                                PromptSupport.setPrompt((String)string, (JTextComponent)this.cellEditorComponent.getEditorComponent());
                            }
                            this.cellEditorComponent.getEditorComponent().setFont(font2);
                        }
                        this.table.setCellFormatter(this.cellEditorListener.getCellFormatter());
                    }
                    catch (Exception exception) {
                        Object object = this.cellEditorComponent.getTreeLock();
                        synchronized (object) {
                            this.cellEditorComponent.setSelectedItem(null);
                        }
                        this.cellEditorComponent.setEditorEditable(false);
                        this.cellEditorComponent.getEditorComponent().setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                        throw new ModelException("Editor cannot be restored!", exception);
                    }
                    Object var12_19 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                    throw throwable;
                }
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                if (this.popupChanged && this.referencedDataBook.getSelectedRow() >= 0) {
                    return this.referencedDataBook.getValue(this.referencedColumnName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.cellEditorComponent.getEditor().getItem();
        }

        @Override
        public void setSelectedItem(Object object) {
            try {
                if (this.firstEditingStarted) {
                    this.referencedDataBook.setFilter(this.cellEditor.getSearchCondition(this.dataRow, null));
                    if (this.cellEditor.isSortByColumnName()) {
                        this.referencedDataBook.setSort(new SortDefinition(this.referencedColumnName));
                    }
                    if (object != null) {
                        String[] stringArray = new String[]{this.referencedColumnName};
                        IDataRow iDataRow = this.referencedDataBook.createEmptyDataRow(null);
                        iDataRow.setValue(this.referencedColumnName, object);
                        long l = System.currentTimeMillis();
                        this.referencedDataBook.setSelectedRow(-1);
                        int n = 0;
                        IChangeableDataRow iChangeableDataRow = this.referencedDataBook.getDataRow(n);
                        while (iChangeableDataRow != null && this.referencedDataBook.getSelectedRow() < 0 && System.currentTimeMillis() - l < 1000L) {
                            if (iDataRow.equals(iChangeableDataRow, stringArray)) {
                                this.referencedDataBook.setSelectedRow(n);
                                continue;
                            }
                            iChangeableDataRow = this.referencedDataBook.getDataRow(++n);
                        }
                    }
                } else if (object == null) {
                    this.referencedDataBook.setFilter(this.cellEditor.getSearchCondition(this.dataRow, null));
                } else {
                    this.referencedDataBook.setFilter(this.cellEditor.getSearchCondition(this.dataRow, this.cellEditor.getItemSearchCondition(true, this.getRelevantSearchColumnName(), object)));
                }
                this.table.setColumnView(this.cellEditor.getColumnView());
                if (this.cellEditor.autoTableHeaderVisibility) {
                    this.table.setTableHeaderVisible(this.referencedDataBook.getDataRow(0) != null && this.table.getColumnView().getColumnCount() > 2);
                } else {
                    this.table.setTableHeaderVisible(this.referencedDataBook.getDataRow(0) != null && this.cellEditor.isTableHeaderVisible());
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.popupChanged = false;
        }

        @Override
        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
                if (this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.cellEditorComponent.setPopupCanceled(true);
                        this.cellEditorComponent.setPopupVisible(false);
                        this.fireEditingComplete("ESCAPE_KEY", true);
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (this.cellEditorComponent.isPopupVisible()) {
                            this.popupChanged = true;
                            this.fireEditingStarted();
                            this.cellEditorComponent.setPopupVisible(false);
                        }
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY", true);
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY", true);
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY", true);
                        break;
                    }
                    case 38: 
                    case 40: {
                        if (!this.cellEditorComponent.isPopupVisible()) break;
                        this.table.keyPressed(keyEvent);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: 
                    case 40: {
                        if (!this.cellEditorComponent.isPopupVisible()) break;
                        this.table.keyReleased(keyEvent);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.fireEditingComplete("ESCAPE_KEY", false);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.cellEditorComponent.getEditorComponent().select(this.cellEditorComponent.getEditorComponent().getSelectionStart(), this.cellEditorComponent.getEditorComponent().getSelectionEnd());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            try {
                this.referencedDataBook.setReadOnly(this.cellEditor.isTableReadonly());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (this.firstEditingStarted && this.cellEditorComponent.isTextInputEnabled()) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.table.scrollToSelectedCell();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!this.cellEditorComponent.isPopupVisible() && this.cellEditorComponent.isEditorEditable()) {
                this.cellEditorComponent.getEditorComponent().selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && !this.cellEditorComponent.isPopupFocusEvent(focusEvent)) {
                this.fireEditingComplete("FOCUS_LOST", true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.popupChanged = true;
            this.fireEditingStarted();
            this.fireEditingComplete("ENTER_KEY", true);
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
                if (this.cellEditor.isAutoOpenPopup() && !this.cellEditorComponent.isPopupVisible()) {
                    this.cellEditorComponent.setPopupVisible(true);
                }
            }
        }

        protected void fireEditingComplete(String string, boolean bl) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                if (bl && this.cellEditorComponent.isPopupVisible()) {
                    this.ignoreEvent = true;
                    this.cellEditorComponent.setPopupCanceled(true);
                    this.cellEditorComponent.setPopupVisible(false);
                    this.ignoreEvent = false;
                }
                this.cellEditorListener.editingComplete(string);
            }
        }

        private String getRelevantSearchColumnName() {
            if (this.cellEditor.displayReferencedColumnName != null) {
                return this.cellEditor.displayReferencedColumnName;
            }
            return this.referencedColumnName;
        }
    }
}

