/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.StringUtil;
import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class JSBridge {
    private static Class<?> jsObject;
    private static Method metCall;
    private static Method metGetMember;
    private static Method metSetMember;
    private static Method metGetWindow;
    private Object objWindow;
    private Object objDocument;
    private static final SimpleDateFormat FORMAT_EXPIRE;

    public JSBridge(Applet applet) throws Throwable {
        this.objWindow = this.getWindow(applet);
        this.objDocument = this.getIntern(this.objWindow, "document");
    }

    public void setTitle(String string) throws Throwable {
        if (string == null) {
            string = "";
        }
        this.setIntern(this.objDocument, "title", string);
    }

    public String getTitle() throws Throwable {
        String string = (String)this.getIntern(this.objDocument, "title");
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public void setLocation(String string) throws Throwable {
        this.setIntern(this.objWindow, "location.href", string);
    }

    public String getLocation() throws Throwable {
        return (String)this.getIntern(this.objWindow, "location.href");
    }

    public void close() throws Throwable {
        this.call("self.close", new Object[0]);
    }

    public void requestFocus() throws Throwable {
        this.call("self.focus", new Object[0]);
    }

    public void openWindow(final String string, final String string2, int n, int n2, int n3, int n4, boolean bl) throws Throwable {
        int n5;
        final StringBuilder stringBuilder = new StringBuilder();
        if (n >= 0) {
            stringBuilder.append(",left=");
            if (bl) {
                n5 = ((Number)this.get("window.screen.width")).intValue();
                stringBuilder.append((n5 - n3) / 2);
            } else {
                stringBuilder.append(n);
            }
        }
        if (n2 >= 0) {
            stringBuilder.append(",top=");
            if (bl) {
                n5 = ((Number)this.get("window.screen.height")).intValue();
                stringBuilder.append((n5 - n4) / 2);
            } else {
                stringBuilder.append(n2);
            }
        }
        if (n3 > 0) {
            stringBuilder.append(",width=");
            stringBuilder.append(n3);
        }
        if (n4 > 0) {
            stringBuilder.append(",height=");
            stringBuilder.append(n4);
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(150L);
                    Object object = JSBridge.this.callIntern(JSBridge.this.objWindow, "window.open", new Object[]{string, string2, "status=no,location=no,menubar=no,toolbar=no,dependent=yes,resizable=yes" + stringBuilder.toString()});
                    if (object != null) {
                        JSBridge.this.callIntern(object, "focus", new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public Object call(String string, Object ... objectArray) throws Throwable {
        return this.callIntern(this.objWindow, string, objectArray);
    }

    private Object callIntern(Object object, String string, Object ... objectArray) throws Throwable {
        try {
            return this.invoke(object, metCall, string, new Object[]{objectArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public void set(String string, Object object) throws Throwable {
        this.setIntern(this.objWindow, string, object);
    }

    private void setIntern(Object object, String string, Object object2) throws Throwable {
        try {
            this.invoke(object, metSetMember, string, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public Object get(String string) throws Throwable {
        return this.getIntern(this.objWindow, string);
    }

    public Object getIntern(Object object, String string) throws Throwable {
        try {
            return this.invoke(object, metGetMember, string, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private Object getWindow(Applet applet) throws Throwable {
        try {
            return metGetWindow.invoke(this.objWindow, applet);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private Object invoke(Object object, Method method, String string, Object ... objectArray) throws Throwable {
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, ".", true);
        Object[] objectArray2 = new Object[1];
        if (objectArray != null) {
            objectArray2 = ArrayUtil.addAll(objectArray2, objectArray);
        }
        if (arrayUtil.size() > 1) {
            Object object2 = object;
            int n = arrayUtil.size() - 1;
            for (int i = 0; i < n; ++i) {
                object2 = metGetMember.invoke(object2, arrayUtil.get(i));
            }
            objectArray2[0] = arrayUtil.get(arrayUtil.size() - 1);
            return method.invoke(object2, objectArray2);
        }
        objectArray2[0] = string;
        return method.invoke(object, objectArray2);
    }

    public void setCookie(String string, String string2, long l) throws Throwable {
        String string3 = "0x" + CodecUtil.encodeHex(string);
        if (string2 == null) {
            l = -1L;
            string3 = string3 + "=";
        } else {
            string3 = string3 + "=0x" + CodecUtil.encodeHex(string2);
        }
        string3 = string3 + "; expires=" + FORMAT_EXPIRE.format(new Date(System.currentTimeMillis() + l * 1000L)) + "; path=/";
        this.setIntern(this.objDocument, "cookie", string3);
    }

    public String getCookie(String string) throws Throwable {
        String string2 = string + "=";
        String string3 = "0x" + CodecUtil.encodeHex(string) + "=";
        String string4 = (String)this.getIntern(this.objDocument, "cookie");
        if (string4 != null) {
            ArrayUtil<String> arrayUtil = StringUtil.separateList(string4, ";", true);
            for (String string5 : arrayUtil) {
                if (string5.startsWith(string2)) {
                    return string5.substring(string2.length());
                }
                if (!string5.startsWith(string3)) continue;
                return CodecUtil.decodeHex(string5.substring(string3.length() + 2));
            }
        }
        return null;
    }

    static {
        FORMAT_EXPIRE = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        FORMAT_EXPIRE.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            jsObject = Class.forName("netscape.javascript.JSObject");
        }
        catch (Throwable throwable) {
            jsObject = null;
        }
        if (jsObject != null) {
            try {
                metCall = jsObject.getMethod("call", String.class, Object[].class);
            }
            catch (Throwable throwable) {
                metCall = null;
            }
            try {
                metGetMember = jsObject.getMethod("getMember", String.class);
            }
            catch (Throwable throwable) {
                metGetMember = null;
            }
            try {
                metSetMember = jsObject.getMethod("setMember", String.class, Object.class);
            }
            catch (Throwable throwable) {
                metSetMember = null;
            }
            try {
                metGetWindow = jsObject.getMethod("getWindow", Applet.class);
            }
            catch (Throwable throwable) {
                metGetWindow = null;
            }
        }
    }
}

