/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl.component;

import com.sibvisions.rad.ui.ApplicationUtil;
import com.sibvisions.rad.ui.awt.impl.AwtInsets;
import com.sibvisions.rad.ui.swing.ext.JVxButton;
import com.sibvisions.rad.ui.swing.ext.JVxToggleButton;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import com.sibvisions.rad.ui.swing.impl.component.SwingAbstractLabeledIconButton;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.rad.ui.IImage;
import javax.rad.ui.IInsets;
import javax.rad.ui.component.IButton;
import javax.rad.ui.event.ActionHandler;
import javax.rad.ui.event.Key;
import javax.rad.ui.event.UIActionEvent;
import javax.rad.util.SilentAbortException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingAbstractButton<C extends AbstractButton>
extends SwingAbstractLabeledIconButton<C>
implements IButton,
ActionListener {
    protected IImage imgOver = null;
    protected IImage imgPressed = null;
    private ActionHandler eventActionPerformed = null;
    private String sActionCommand = null;
    private int iDefaultGap = -1;

    public SwingAbstractButton(C c) {
        super(c);
        ((AbstractButton)this.resource).addActionListener(this);
    }

    @Override
    public void setVerticalTextPosition(int n) {
        ((AbstractButton)this.resource).setVerticalTextPosition(SwingFactory.getVerticalSwingAlignment(n));
    }

    @Override
    public int getVerticalTextPosition() {
        return SwingFactory.getVerticalAlignment(((AbstractButton)this.resource).getVerticalTextPosition());
    }

    @Override
    public void setHorizontalTextPosition(int n) {
        ((AbstractButton)this.resource).setHorizontalTextPosition(SwingFactory.getHorizontalSwingAlignment(n));
    }

    @Override
    public int getHorizontalTextPosition() {
        return SwingFactory.getHorizontalAlignment(((AbstractButton)this.resource).getHorizontalTextPosition());
    }

    @Override
    public int getImageTextGap() {
        return ((AbstractButton)this.resource).getIconTextGap();
    }

    @Override
    public void setImageTextGap(int n) {
        this.iDefaultGap = -1;
        ((AbstractButton)this.resource).setIconTextGap(n);
    }

    @Override
    public boolean isBorderOnMouseEntered() {
        if (this.resource instanceof JVxButton) {
            return ((JVxButton)this.resource).isBorderOnMouseEntered();
        }
        if (this.resource instanceof JVxToggleButton) {
            return ((JVxToggleButton)this.resource).isBorderOnMouseEntered();
        }
        return false;
    }

    @Override
    public void setBorderOnMouseEntered(boolean bl) {
        if (this.resource instanceof JVxButton) {
            ((JVxButton)this.resource).setBorderOnMouseEntered(bl);
        } else if (this.resource instanceof JVxToggleButton) {
            ((JVxToggleButton)this.resource).setBorderOnMouseEntered(bl);
        }
    }

    @Override
    public void setAccelerator(Key key) {
        if (this.resource instanceof JVxButton) {
            ((JVxButton)this.resource).setAccelerator(SwingFactory.getKeyStroke(key));
        } else if (this.resource instanceof JVxToggleButton) {
            ((JVxToggleButton)this.resource).setAccelerator(SwingFactory.getKeyStroke(key));
        } else if (this.resource instanceof JMenuItem) {
            ((JMenuItem)this.resource).setAccelerator(SwingFactory.getKeyStroke(key));
        }
    }

    @Override
    public Key getAccelerator() {
        if (this.resource instanceof JVxButton) {
            return SwingFactory.getKey(((JVxButton)this.resource).getAccelerator());
        }
        if (this.resource instanceof JVxToggleButton) {
            return SwingFactory.getKey(((JVxToggleButton)this.resource).getAccelerator());
        }
        if (this.resource instanceof JMenuItem) {
            return SwingFactory.getKey(((JMenuItem)this.resource).getAccelerator());
        }
        return null;
    }

    @Override
    public void setBorderPainted(boolean bl) {
        ((AbstractButton)this.resource).setContentAreaFilled(bl);
        ((AbstractButton)this.resource).setBorderPainted(bl);
    }

    @Override
    public boolean isBorderPainted() {
        return ((AbstractButton)this.resource).isBorderPainted();
    }

    @Override
    public void setMouseOverImage(IImage iImage) {
        if (iImage == null) {
            ((AbstractButton)this.resource).setRolloverEnabled(false);
            ((AbstractButton)this.resource).setRolloverIcon(null);
        } else {
            ((AbstractButton)this.resource).setRolloverEnabled(true);
            ((AbstractButton)this.resource).setRolloverIcon((ImageIcon)iImage.getResource());
        }
        this.imgOver = iImage;
    }

    @Override
    public IImage getMouseOverImage() {
        return this.imgOver;
    }

    @Override
    public void setPressedImage(IImage iImage) {
        if (iImage == null) {
            ((AbstractButton)this.resource).setPressedIcon(null);
        } else {
            ((AbstractButton)this.resource).setPressedIcon((ImageIcon)iImage.getResource());
        }
        this.imgPressed = iImage;
    }

    @Override
    public IImage getPressedImage() {
        return this.imgPressed;
    }

    @Override
    public void setDefaultButton(boolean bl) {
        if (this.resource instanceof JVxButton) {
            ((JVxButton)this.resource).setDefaultButton(bl);
        }
    }

    @Override
    public boolean isDefaultButton() {
        if (this.resource instanceof JVxButton) {
            return ((JVxButton)this.resource).isDefaultButton();
        }
        return false;
    }

    @Override
    public String getActionCommand() {
        return this.sActionCommand;
    }

    @Override
    public void setActionCommand(String string) {
        this.sActionCommand = string;
        ((AbstractButton)this.resource).setActionCommand(string);
    }

    @Override
    public ActionHandler eventAction() {
        if (this.eventActionPerformed == null) {
            this.eventActionPerformed = new ActionHandler();
        }
        return this.eventActionPerformed;
    }

    @Override
    public void setMargins(IInsets iInsets) {
        if (iInsets != null) {
            ((AbstractButton)this.resource).setMargin((Insets)iInsets.getResource());
        } else {
            ((AbstractButton)this.resource).setMargin(null);
        }
    }

    @Override
    public IInsets getMargins() {
        return new AwtInsets(((AbstractButton)this.resource).getMargin());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.eventActionPerformed == null) return;
        JVxUtil.setGlobalCursor((Component)this.resource, Cursor.getPredefinedCursor(3));
        try {
            try {
                this.eventActionPerformed.dispatchEvent(new UIActionEvent(this.eventSource, 1001, actionEvent.getWhen(), actionEvent.getModifiers(), this.sActionCommand));
            }
            catch (SilentAbortException silentAbortException) {
                Object var4_3 = null;
                JVxUtil.setGlobalCursor((Component)this.resource, null);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            JVxUtil.setGlobalCursor((Component)this.resource, null);
            throw throwable;
        }
        JVxUtil.setGlobalCursor((Component)this.resource, null);
    }

    @Override
    public void setImage(IImage iImage) {
        if (this.iDefaultGap != -1) {
            ((AbstractButton)this.resource).setIconTextGap(this.iDefaultGap);
            this.iDefaultGap = -1;
        }
        super.setImage(iImage);
    }

    protected void initDummyImage() {
        if (ApplicationUtil.isMacOS()) {
            this.iDefaultGap = ((AbstractButton)this.resource).getIconTextGap();
            ((AbstractButton)this.resource).setIcon(JVxUtil.getIcon("/com/sibvisions/rad/ui/swing/ext/images/1x1.png"));
            ((AbstractButton)this.resource).setIconTextGap(0);
            ((AbstractButton)this.resource).setMargin(((AbstractButton)this.resource).getMargin());
        }
    }
}

