/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl.component;

import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;
import com.sibvisions.rad.ui.swing.ext.WrappedInsetsBorder;
import com.sibvisions.rad.ui.swing.impl.component.SwingTextComponent;
import java.awt.Insets;
import javax.rad.ui.component.ITextArea;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTextArea
extends SwingTextComponent<JVxScrollPane, JTextArea>
implements ITextArea {
    private static JTextField tfRef = new JTextField();
    private static WrappedInsetsBorder border = new WrappedInsetsBorder(tfRef.getBorder());
    private boolean bAutoScroll = false;
    private boolean bKeepHScrollPosition = false;

    public SwingTextArea() {
        super(new JVxScrollPane(new JTextArea()));
        ((JTextArea)this.component).setWrapStyleWord(true);
        ((JTextArea)this.component).setColumns(10);
        ((JTextArea)this.component).setRows(5);
        ((JTextArea)this.component).setBorder(null);
        ((JVxScrollPane)this.resource).setBorder(border);
    }

    @Override
    public int getColumns() {
        return ((JTextArea)this.component).getColumns();
    }

    @Override
    public void setColumns(int n) {
        ((JTextArea)this.component).setColumns(n);
    }

    @Override
    public int getRows() {
        return ((JTextArea)this.component).getRows();
    }

    @Override
    public void setRows(int n) {
        ((JTextArea)this.component).setRows(n);
    }

    @Override
    public boolean isWordWrap() {
        return ((JTextArea)this.component).getLineWrap();
    }

    @Override
    public void setWordWrap(boolean bl) {
        ((JTextArea)this.component).setLineWrap(bl);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.autoScroll();
    }

    public void setAutoScroll(boolean bl) {
        this.bAutoScroll = bl;
    }

    public boolean isAutoScroll() {
        return this.bAutoScroll;
    }

    public void setKeepHorizontalScrollPosition(boolean bl) {
        this.bKeepHScrollPosition = bl;
    }

    public boolean isKeepHorizontalScrollPosition() {
        return this.bKeepHScrollPosition;
    }

    private void autoScroll() {
        if (this.bAutoScroll) {
            final int n = ((JVxScrollPane)this.resource).getHorizontalScrollBar().getValue();
            ((JTextArea)this.component).getCaret().setDot(((JTextArea)this.component).getText().length());
            ((JTextArea)this.component).scrollRectToVisible(((JTextArea)this.component).getVisibleRect());
            if (this.bKeepHScrollPosition) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JScrollBar jScrollBar = ((JVxScrollPane)SwingTextArea.this.resource).getHorizontalScrollBar();
                        if (jScrollBar.getMaximum() >= n) {
                            jScrollBar.setValue(n);
                        }
                    }
                });
            }
        }
    }

    static {
        border.setPaintInsets(new Insets(0, 0, 0, 0));
    }
}

