/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl.container;

import com.sibvisions.rad.ui.swing.ext.JVxToolBarPanel;
import java.util.ArrayList;
import java.util.List;
import javax.rad.ui.IContainer;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.container.IToolBarPanel;
import javax.swing.JToolBar;

final class InternalToolBarPanel
extends JVxToolBarPanel {
    private List<IToolBar> toolbars = new ArrayList<IToolBar>();
    private IToolBarPanel toolBarOwner;

    InternalToolBarPanel() {
    }

    void addUIToolBar(IToolBar iToolBar, int n) {
        if (iToolBar.getParent() != null) {
            ((IToolBarPanel)iToolBar.getParent()).removeToolBar(iToolBar);
        }
        if (n < 0) {
            this.toolbars.add(iToolBar);
        } else {
            this.toolbars.add(n, iToolBar);
        }
        IContainer iContainer = iToolBar.getParent();
        iToolBar.setParent(this.toolBarOwner);
        try {
            this.addToolBarIntern(iToolBar, n);
        }
        catch (RuntimeException runtimeException) {
            this.toolbars.remove(iToolBar);
            iToolBar.setParent(iContainer);
            throw runtimeException;
        }
        catch (Error error) {
            this.toolbars.remove(iToolBar);
            iToolBar.setParent(iContainer);
            throw error;
        }
    }

    void removeUIToolBar(int n) {
        this.removeUIToolBar(this.toolbars.get(n));
    }

    void removeUIToolBar(IToolBar iToolBar) {
        this.removeToolBarIntern(iToolBar);
        this.toolbars.remove(iToolBar);
        iToolBar.setParent(null);
        this.repaint();
    }

    int getUIToolBarCount() {
        return this.toolbars.size();
    }

    IToolBar getUIToolBar(int n) {
        if (n < 0 || n >= this.toolbars.size()) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        return this.toolbars.get(n);
    }

    int indexOfUIToolBar(IToolBar iToolBar) {
        return this.toolbars.indexOf(iToolBar);
    }

    public void setUIArea(int n) {
        this.setArea(this.getSwingArea(n));
    }

    public int getUIArea() {
        return this.getUIArea(this.getArea());
    }

    public JVxToolBarPanel.ToolBarArea getSwingArea(int n) {
        switch (n) {
            case 0: {
                return JVxToolBarPanel.ToolBarArea.TOP;
            }
            case 1: {
                return JVxToolBarPanel.ToolBarArea.LEFT;
            }
            case 2: {
                return JVxToolBarPanel.ToolBarArea.BOTTOM;
            }
            case 3: {
                return JVxToolBarPanel.ToolBarArea.RIGHT;
            }
        }
        return JVxToolBarPanel.ToolBarArea.TOP;
    }

    public int getUIArea(JVxToolBarPanel.ToolBarArea toolBarArea) {
        switch (toolBarArea) {
            case TOP: {
                return 0;
            }
            case LEFT: {
                return 1;
            }
            case BOTTOM: {
                return 2;
            }
            case RIGHT: {
                return 3;
            }
        }
        return 0;
    }

    void setToolBarOwner(IToolBarPanel iToolBarPanel) {
        this.toolBarOwner = iToolBarPanel;
    }

    protected void addToolBarIntern(IToolBar iToolBar, int n) {
        this.getToolBar().setFloatable(iToolBar.isMovable());
        this.addToolBar((JToolBar)iToolBar.getResource(), n);
    }

    protected void removeToolBarIntern(IToolBar iToolBar) {
        this.removeToolBar((JToolBar)iToolBar.getResource());
    }
}

