/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;

public final class CodecUtil {
    private static Hashtable<String, String> htHtmlMapping = new Hashtable();

    private CodecUtil() {
    }

    public static String encodeURLPart(String string) {
        return CodecUtil.encodeURLPart(string, "ISO-8859-1");
    }

    public static String encodeURLPart(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (byte by : string.getBytes(string2)) {
                if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57 || by == 36 || by == 45 || by == 95 || by == 46 || by == 33 || by == 39 || by == 40 || by == 41 || by == 44 || by == 47) {
                    stringBuffer.append((char)by);
                    continue;
                }
                stringBuffer.append('%');
                stringBuffer.append(String.valueOf(Integer.toHexString((by & 0xFF) + 256)).substring(1));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeURLParameter(String string) {
        return CodecUtil.encodeURLParameter(string, "ISO-8859-1");
    }

    public static String encodeURLParameter(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decodeURLPart(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                ++n;
                if (c == '%') {
                    String string2 = string.substring(n, n + 2);
                    n += 2;
                    byteArrayOutputStream.write((byte)(Integer.parseInt(string2, 16) - 256 & 0xFF));
                    continue;
                }
                byteArrayOutputStream.write(c);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return new String(byteArrayOutputStream.toByteArray(), "ISO-8859-1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decodeURLParameter(String string) {
        return CodecUtil.decodeURLParameter(string, "ISO-8859-1");
    }

    public static String decodeURLParameter(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encodeHtml(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : htHtmlMapping.entrySet()) {
            string2 = string2.replace(entry.getKey(), entry.getValue());
        }
        return string2;
    }

    public static String decodeHtml(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : htHtmlMapping.entrySet()) {
            string2 = string2.replace(entry.getValue(), entry.getKey());
        }
        return string2;
    }

    public static String encodeHex(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return CodecUtil.encodeHex(string.getBytes("UTF-8"));
    }

    public static String encodeHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(String.valueOf(Integer.toHexString((byArray[i] & 0xFF) + 256)).substring(1));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeHex(InputStream inputStream) throws IOException {
        String string;
        block9: {
            BufferedInputStream bufferedInputStream;
            boolean bl;
            if (inputStream instanceof BufferedInputStream) {
                bl = false;
                bufferedInputStream = (BufferedInputStream)inputStream;
            } else {
                bl = true;
                bufferedInputStream = new BufferedInputStream(inputStream);
            }
            try {
                int n;
                byte[] byArray = new byte[8192];
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedInputStream.read(byArray)) >= 0) {
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append(String.valueOf(Integer.toHexString((byArray[i] & 0xFF) + 256)).substring(1));
                    }
                }
                string = stringBuilder.toString();
                Object var8_8 = null;
                if (!bl) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_9 = null;
                    if (!bl) break block10;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String decodeHex(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(CodecUtil.decodeHexAsBytes(string), "UTF-8");
    }

    public static byte[] decodeHexAsBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            byArray[n2] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
            ++n2;
        }
        return byArray;
    }

    static {
        htHtmlMapping.put("&", "&amp;");
        htHtmlMapping.put("\"", "&quot;");
        htHtmlMapping.put("/", "&frasl;");
        htHtmlMapping.put("'", "&#39;");
        htHtmlMapping.put(String.valueOf('\u00a7'), "&sect;");
        htHtmlMapping.put(String.valueOf('\u00a9'), "&copy;");
        htHtmlMapping.put(String.valueOf('\u00ae'), "&reg;");
        htHtmlMapping.put(String.valueOf('\u00bb'), "&raquo;");
        htHtmlMapping.put(String.valueOf('\u00ab'), "&laquo;");
        htHtmlMapping.put(String.valueOf('\u00b9'), "&sup1;");
        htHtmlMapping.put(String.valueOf('\u00b2'), "&sup2;");
        htHtmlMapping.put(String.valueOf('\u00b3'), "&sup3;");
        htHtmlMapping.put(String.valueOf('\u00bc'), "&frac14;");
        htHtmlMapping.put(String.valueOf('\u00bd'), "&frac12;");
        htHtmlMapping.put(String.valueOf('\u00bf'), "&iquest;");
        htHtmlMapping.put(String.valueOf('\u00a1'), "&iexcl;");
        htHtmlMapping.put("<", "&lt;");
        htHtmlMapping.put(">", "&gt;");
        htHtmlMapping.put("\u00f6", "&ouml;");
        htHtmlMapping.put("\u00fc", "&uuml;");
        htHtmlMapping.put("\u00e4", "&auml;");
        htHtmlMapping.put("\u00d6", "&Ouml;");
        htHtmlMapping.put("\u00dc", "&Uuml;");
        htHtmlMapping.put("\u00c4", "&Auml;");
        htHtmlMapping.put("\u00df", "&szlig;");
    }
}

