/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.io;

import com.sibvisions.util.ObjectCache;
import com.sibvisions.util.type.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import javax.rad.io.IDownloadExecutor;
import javax.rad.io.IFileHandle;
import javax.rad.io.TransferContext;

public class RemoteFileHandle
implements IFileHandle,
Serializable {
    private static final long DEFAULT_TIMEOUT = 300000L;
    private String fileName;
    private Object objectCacheKey;
    private long timeout = 300000L;
    private transient File fiTempOut = null;
    private transient File fiContent = null;
    private transient URL urlContent = null;
    private transient IDownloadExecutor download;

    public RemoteFileHandle() {
        this.fileName = null;
        this.objectCacheKey = null;
        this.download = TransferContext.getCurrentDownloadExecutor();
    }

    public RemoteFileHandle(String string) {
        this.fileName = FileUtil.getName(string);
        this.objectCacheKey = null;
    }

    public RemoteFileHandle(String string, Object object) {
        this.fileName = FileUtil.getName(string);
        this.objectCacheKey = object;
    }

    public RemoteFileHandle(String string, URL uRL) {
        this(string, null, uRL);
    }

    public RemoteFileHandle(String string, Object object, URL uRL) {
        this.fileName = FileUtil.getName(string);
        this.objectCacheKey = object;
        this.setContent(uRL);
    }

    public RemoteFileHandle(String string, InputStream inputStream) throws IOException {
        this(string, null, inputStream);
    }

    public RemoteFileHandle(String string, Object object, InputStream inputStream) throws IOException {
        this.fileName = FileUtil.getName(string);
        this.objectCacheKey = object;
        this.setContent(inputStream);
    }

    public RemoteFileHandle(File file) {
        this.fileName = file.getName();
        this.setContent(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.fiTempOut != null) {
            return new FileInputStream(this.fiTempOut);
        }
        if (this.objectCacheKey != null) {
            Object object = ObjectCache.get(this.objectCacheKey);
            if (object == null) {
                if (this.download != null) {
                    return this.download.readContent(this);
                }
            } else if (object instanceof IFileHandle) {
                if (object != this) {
                    return ((IFileHandle)object).getInputStream();
                }
                if (this.fiContent != null) {
                    return new FileInputStream(this.fiContent);
                }
                if (this.urlContent != null) {
                    return this.urlContent.openConnection().getInputStream();
                }
            }
        }
        return null;
    }

    public long getLength() throws IOException {
        if (this.fiTempOut != null) {
            return this.fiTempOut.length();
        }
        if (this.objectCacheKey != null) {
            Object object = ObjectCache.get(this.objectCacheKey);
            if (object == null) {
                if (this.download != null) {
                    return this.download.getContentLength(this);
                }
            } else if (object instanceof IFileHandle) {
                if (object != this) {
                    return ((IFileHandle)object).getLength();
                }
                if (this.fiContent != null) {
                    return this.fiContent.length();
                }
                if (this.urlContent != null) {
                    return this.urlContent.openConnection().getContentLength();
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        RemoteFileHandle remoteFileHandle = this;
        synchronized (remoteFileHandle) {
            this.notifyAll();
        }
        try {
            this.fiTempOut.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public static Object createObjectCacheKey() {
        return ObjectCache.createKey();
    }

    public void setFileName(String string) {
        this.fileName = FileUtil.getName(string);
    }

    public Object getObjectCacheKey() {
        return this.objectCacheKey;
    }

    public void setObjectCacheKey(Object object) {
        this.objectCacheKey = object;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public OutputStream getOutputStream() throws IOException {
        this.fiTempOut = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        this.fiTempOut.deleteOnExit();
        if (this.objectCacheKey == null) {
            this.objectCacheKey = ObjectCache.put((Object)this, this.timeout);
        } else {
            ObjectCache.put(this.objectCacheKey, this, this.timeout);
        }
        return new FileOutputStream(this.fiTempOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(byte[] byArray) throws IOException {
        if (byArray == null) {
            if (this.objectCacheKey != null) {
                ObjectCache.remove(this.objectCacheKey);
            }
        } else {
            OutputStream outputStream = this.getOutputStream();
            try {
                outputStream.write(byArray);
            }
            finally {
                outputStream.close();
            }
        }
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            if (this.objectCacheKey != null) {
                ObjectCache.remove(this.objectCacheKey);
            }
        } else {
            FileUtil.copy(inputStream, true, this.getOutputStream(), true);
        }
    }

    public void setContent(File file) {
        this.urlContent = null;
        this.fiContent = file;
        if (file == null) {
            if (this.objectCacheKey != null) {
                ObjectCache.remove(this.objectCacheKey);
            }
        } else if (this.objectCacheKey == null) {
            this.objectCacheKey = ObjectCache.put((Object)this, this.timeout);
        } else {
            ObjectCache.put(this.objectCacheKey, this, this.timeout);
        }
    }

    public void setContent(URL uRL) {
        this.fiContent = null;
        this.urlContent = uRL;
        if (uRL == null) {
            if (this.objectCacheKey != null) {
                ObjectCache.remove(this.objectCacheKey);
            }
        } else if (this.objectCacheKey == null) {
            this.objectCacheKey = ObjectCache.put((Object)this, this.timeout);
        } else {
            ObjectCache.put(this.objectCacheKey, this, this.timeout);
        }
    }
}

