/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.condition;

import java.io.Serializable;
import javax.rad.model.condition.And;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.Greater;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.Less;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.LikeReverse;
import javax.rad.model.condition.LikeReverseIgnoreCase;
import javax.rad.model.condition.Not;
import javax.rad.model.condition.OperatorCondition;
import javax.rad.model.condition.Or;

public abstract class BaseCondition
implements ICondition,
Serializable,
Cloneable {
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this instanceof CompareCondition) {
            CompareCondition compareCondition = (CompareCondition)this;
            Object object = compareCondition.getValue();
            if (!compareCondition.isIgnoreNull() || object != null) {
                String string = compareCondition.getColumnName();
                Object object2 = compareCondition.getValue();
                if (object2 == null) {
                    object2 = "?";
                } else if (object2 instanceof String) {
                    object2 = "'" + object2 + "'";
                }
                if ((compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) && compareCondition.getValue() != null) {
                    if (compareCondition instanceof LikeReverse) {
                        stringBuilder.append(object2);
                    } else if (compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("UPPER(");
                        stringBuilder.append(object2);
                        stringBuilder.append(")");
                    }
                } else if (compareCondition instanceof LikeIgnoreCase) {
                    stringBuilder.append("UPPER(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(' ');
                if (compareCondition.getValue() == null) {
                    stringBuilder.append("IS NULL");
                } else {
                    if (compareCondition instanceof Equals) {
                        stringBuilder.append("= ");
                    } else if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append("LIKE UPPER(");
                    } else if (compareCondition instanceof Like || compareCondition instanceof LikeReverse) {
                        stringBuilder.append("LIKE ");
                    } else if (compareCondition instanceof Greater) {
                        stringBuilder.append("> ");
                    } else if (compareCondition instanceof GreaterEquals) {
                        stringBuilder.append(">= ");
                    } else if (compareCondition instanceof Less) {
                        stringBuilder.append("< ");
                    } else if (compareCondition instanceof LessEquals) {
                        stringBuilder.append("<= ");
                    } else {
                        stringBuilder.append(' ');
                    }
                    if (compareCondition instanceof LikeReverse || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append(object2);
                    }
                    if (compareCondition instanceof LikeIgnoreCase || compareCondition instanceof LikeReverseIgnoreCase) {
                        stringBuilder.append(")");
                    }
                }
            }
        } else if (this instanceof OperatorCondition) {
            OperatorCondition operatorCondition = (OperatorCondition)this;
            ICondition[] iConditionArray = operatorCondition.getConditions();
            for (int i = 0; i < iConditionArray.length; ++i) {
                String string = iConditionArray[i].toString();
                if (string == null || string.length() <= 0) continue;
                if (i > 0 && stringBuilder.length() > 0) {
                    if (operatorCondition instanceof And) {
                        stringBuilder.append(" AND ");
                    } else if (operatorCondition instanceof Or) {
                        stringBuilder.append(" OR ");
                    }
                }
                if (iConditionArray[i] instanceof OperatorCondition) {
                    stringBuilder.append("(");
                    stringBuilder.append(string);
                    stringBuilder.append(")");
                    continue;
                }
                stringBuilder.append(string);
            }
        } else if (this instanceof Not) {
            ICondition iCondition = ((Not)this).getCondition();
            String string = iCondition.toString();
            stringBuilder.append("NOT ");
            if (iCondition instanceof OperatorCondition) {
                stringBuilder.append("(");
                stringBuilder.append(string);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public And and(ICondition iCondition) {
        if (this instanceof And) {
            ((And)this).add(iCondition);
            return (And)this;
        }
        And and = new And(this, iCondition);
        return and;
    }

    public Or or(ICondition iCondition) {
        if (this instanceof Or) {
            ((Or)this).add(iCondition);
            return (Or)this;
        }
        Or or = new Or(this, iCondition);
        return or;
    }

    public ICondition clone() {
        try {
            return (ICondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

