/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.Internalize;
import com.sibvisions.util.type.NumberUtil;
import java.math.BigDecimal;
import java.util.Date;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;

public class LongDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = -5;
    private boolean bSigned = true;
    private NumberUtil numberUtil = new NumberUtil();

    public LongDataType() {
    }

    public LongDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return -5;
    }

    public Class getTypeClass() {
        return Long.class;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.numberUtil.format((Number)object);
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Date) {
            return ((Date)object).getTime();
        }
        if (object instanceof CharSequence) {
            String string = object.toString().trim();
            if (string.length() == 0) {
                return null;
            }
            try {
                return Long.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return ((BigDecimal)this.numberUtil.parse(string)).longValue();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public Long convertAndCheckToTypeClass(Object object) throws ModelException {
        Long l = (Long)this.convertToTypeClass(object);
        if (l == null) {
            return null;
        }
        if (l < 0L && !this.isSigned()) {
            throw new ModelException("BigDecimal needs to be positive! - " + l);
        }
        return Internalize.intern(l);
    }

    public int getSize() {
        return 19;
    }

    public LongDataType clone() {
        return (LongDataType)super.clone();
    }

    public boolean isSigned() {
        return this.bSigned;
    }

    public void setSigned(boolean bl) {
        this.bSigned = bl;
    }

    public String getNumberFormat() {
        return this.numberUtil.getNumberPattern();
    }

    public void setNumberFormat(String string) {
        this.numberUtil.setNumberPattern(string);
    }
}

