/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.type;

import java.util.HashMap;
import java.util.Map;
import javax.rad.type.BinaryType;
import javax.rad.type.BooleanType;
import javax.rad.type.DateType;
import javax.rad.type.DecimalType;
import javax.rad.type.DoubleType;
import javax.rad.type.FileHandleType;
import javax.rad.type.FloatType;
import javax.rad.type.IType;
import javax.rad.type.IntegerType;
import javax.rad.type.LongType;
import javax.rad.type.StringType;
import javax.rad.type.TimestampType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType<T>
implements IType<T> {
    private static HashMap<Class<?>, IType<?>> registeredTypes = new HashMap();
    private static HashMap<Class<?>, Class<?>> primitiveTypes = new HashMap();

    @Override
    public T valueOf(Object object) {
        throw new IllegalArgumentException("The value " + object + " cannot be converted to an instance of " + this.getTypeClass().getName() + "!");
    }

    @Override
    public T validatedValueOf(Object object) {
        return this.valueOf(object);
    }

    @Override
    public int hashCode(T t) {
        if (t == null) {
            return 0;
        }
        return t.hashCode();
    }

    @Override
    public boolean equals(T t, Object object) {
        return t == object || t != null && t.equals(object);
    }

    @Override
    public String toString(T t) {
        if (t == null) {
            return null;
        }
        return t.toString();
    }

    public static void registerType(IType<?> iType) {
        registeredTypes.put(iType.getTypeClass(), iType);
        Class<?> clazz = primitiveTypes.get(iType.getTypeClass());
        if (clazz != null) {
            registeredTypes.put(clazz, iType);
        }
    }

    public static IType<?> getTypeFromObject(Object object) {
        if (object == null) {
            return UNKNOWN_TYPE;
        }
        return AbstractType.getTypeFromClass(object.getClass());
    }

    public static IType<?> getTypeFromClass(Class<?> clazz) {
        IType<?> iType = registeredTypes.get(clazz);
        if (iType == null) {
            if (clazz != null) {
                for (Map.Entry<Class<?>, IType<?>> entry : registeredTypes.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(clazz)) continue;
                    return entry.getValue();
                }
            }
            return UNKNOWN_TYPE;
        }
        return iType;
    }

    static {
        primitiveTypes.put(Void.class, Void.TYPE);
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        AbstractType.registerType(new BooleanType());
        AbstractType.registerType(new IntegerType());
        AbstractType.registerType(new LongType());
        AbstractType.registerType(new FloatType());
        AbstractType.registerType(new DoubleType());
        AbstractType.registerType(new DecimalType());
        AbstractType.registerType(new StringType());
        AbstractType.registerType(new DateType());
        AbstractType.registerType(new TimestampType());
        AbstractType.registerType(new BinaryType());
        AbstractType.registerType(new FileHandleType());
    }
}

