/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.type.bean;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.rad.type.AbstractType;
import javax.rad.type.bean.AbstractBean;
import javax.rad.type.bean.AbstractBeanType;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.IBean;
import javax.rad.type.bean.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanType
extends AbstractBeanType<Object> {
    private static ILogger logger = LoggerFactory.getInstance(BeanType.class);
    private static WeakHashMap<Class, WeakReference<BeanType>> beanTypeCache = new WeakHashMap();
    protected transient Class beanClass;
    protected transient Method[] getMethods;
    protected transient Method[] setMethods;

    public BeanType() {
        super(null, (String[])null);
    }

    public BeanType(String ... stringArray) {
        this((String)null, stringArray);
    }

    public BeanType(String string, String[] stringArray) {
        super(string, stringArray);
        try {
            this.beanClass = Class.forName(string);
            BeanType beanType = BeanType.getBeanType(this.beanClass);
            this.getMethods = new Method[this.propertyNames.length];
            this.setMethods = new Method[this.propertyNames.length];
            for (int i = 0; i < this.propertyNames.length; ++i) {
                int n = beanType.getPropertyIndex(this.propertyNames[i]);
                if (n < 0) continue;
                this.getMethods[i] = beanType.getMethods[n];
                this.setMethods[i] = beanType.setMethods[n];
            }
        }
        catch (Exception exception) {
            this.beanClass = null;
            this.getMethods = null;
            this.setMethods = null;
        }
    }

    public BeanType(PropertyDefinition ... propertyDefinitionArray) {
        this((String)null, propertyDefinitionArray);
    }

    public BeanType(String string, PropertyDefinition[] propertyDefinitionArray) {
        super(string, propertyDefinitionArray);
        this.beanClass = null;
        this.getMethods = null;
        this.setMethods = null;
    }

    protected BeanType(Class clazz) {
        Object object;
        int n;
        this.beanClass = clazz;
        this.className = this.beanClass.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, PropertyDefinition> hashMap = new HashMap<String, PropertyDefinition>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Method> hashMap3 = new HashMap<String, Method>();
        Method[] methodArray = clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            object = methodArray[n];
            if (Modifier.isStatic(((Method)object).getModifiers()) || ((Method)object).getParameterTypes().length != 0) continue;
            String string = ((Method)object).getName();
            String string2 = null;
            if (string.startsWith("get")) {
                string2 = string.substring(3);
            } else if (string.startsWith("is")) {
                string2 = string.substring(2);
            }
            if (string2 == null) continue;
            try {
                Method method = clazz.getMethod("set" + string2, ((Method)object).getReturnType());
                if (Modifier.isStatic(method.getModifiers())) continue;
                PropertyDefinition propertyDefinition = this.createPropertyDefinition(Character.toLowerCase(string2.charAt(0)) + string2.substring(1), ((Method)object).getReturnType());
                arrayList.add(propertyDefinition.getName());
                hashMap.put(propertyDefinition.getName(), propertyDefinition);
                hashMap2.put(propertyDefinition.getName(), object);
                hashMap3.put(propertyDefinition.getName(), method);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.propertyNames = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(this.propertyNames);
        this.propertyDefinitions = new PropertyDefinition[this.propertyNames.length];
        this.getMethods = new Method[this.propertyNames.length];
        this.setMethods = new Method[this.propertyNames.length];
        for (n = 0; n < this.propertyNames.length; ++n) {
            object = this.propertyNames[n];
            this.propertyDefinitions[n] = (PropertyDefinition)hashMap.get(object);
            this.getMethods[n] = (Method)hashMap2.get(object);
            this.setMethods[n] = (Method)hashMap3.get(object);
        }
    }

    @Override
    public Class getTypeClass() {
        if (this.beanClass == null) {
            return Bean.class;
        }
        return this.beanClass;
    }

    @Override
    public Object valueOf(Object object) {
        throw new IllegalArgumentException("The value " + object + " cannot be converted to an instance of " + this.getTypeClass().getName() + "!");
    }

    @Override
    public int compareTo(Object object, Object object2) {
        return 0;
    }

    public static BeanType getBeanType(Class clazz) {
        WeakReference<BeanType> weakReference = beanTypeCache.get(clazz);
        BeanType beanType = weakReference == null ? null : (BeanType)weakReference.get();
        if (beanType == null) {
            beanType = new BeanType(clazz);
            beanTypeCache.put(clazz, new WeakReference<BeanType>(beanType));
        }
        return beanType;
    }

    public static BeanType getBeanType(Object object) {
        if (object instanceof IBean) {
            return (BeanType)((IBean)object).getBeanType();
        }
        return BeanType.getBeanType(object.getClass());
    }

    protected PropertyDefinition createPropertyDefinition(String string, Class clazz) {
        return new PropertyDefinition(string, AbstractType.getTypeFromClass(clazz), clazz);
    }

    public Object newInstance() {
        try {
            return this.beanClass.newInstance();
        }
        catch (Throwable throwable) {
            logger.info("newInstance ", this.className, " failed!", throwable);
            return new Bean(this);
        }
    }

    public Object get(Object object, int n) {
        if (object instanceof AbstractBean) {
            return ((AbstractBean)object).get(n);
        }
        if (object instanceof IBean) {
            return ((IBean)object).get(this.propertyNames[n]);
        }
        try {
            Method method = this.getMethods[n];
            if (method != null) {
                return this.getMethods[n].invoke(object, new Object[0]);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            while (throwable2 instanceof InvocationTargetException || throwable2 instanceof UndeclaredThrowableException) {
                throwable2 = throwable2.getCause();
            }
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            throw new RuntimeException(throwable2);
        }
    }

    public void put(Object object, int n, Object object2) {
        if (object instanceof AbstractBean) {
            ((AbstractBean)object).put(n, object2);
        } else if (object instanceof IBean) {
            ((IBean)object).put(this.propertyNames[n], object2);
        } else {
            try {
                Method method;
                if (this.propertyDefinitions != null) {
                    object2 = this.propertyDefinitions[n].getType().validatedValueOf(object2);
                }
                if ((method = this.setMethods[n]) == null) {
                    logger.debug("put ", this.propertyNames[n], " does not exist in this VM, it is silent ignored!");
                } else {
                    method.invoke(object, object2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                while (throwable2 instanceof InvocationTargetException || throwable2 instanceof UndeclaredThrowableException) {
                    throwable2 = throwable2.getCause();
                }
                if (throwable2 instanceof RuntimeException) {
                    throw (RuntimeException)throwable2;
                }
                throw new RuntimeException(throwable2);
            }
        }
    }

    public Object get(Object object, String string) {
        int n = this.getPropertyIndex(string);
        if (n < 0) {
            return null;
        }
        return this.get(object, n);
    }

    public void put(Object object, String string, Object object2) {
        int n = this.getPropertyIndex(string);
        if (n < 0) {
            throw new IllegalArgumentException("The property [" + string + "] does not exist!");
        }
        this.put(object, n, object2);
    }

    public Method getGetMethod(String string) {
        int n;
        if (this.getMethods != null && (n = this.getPropertyIndex(string)) >= 0) {
            return this.getMethods[n];
        }
        return null;
    }

    public Method getSetMethod(String string) {
        int n;
        if (this.setMethods != null && (n = this.getPropertyIndex(string)) >= 0) {
            return this.setMethods[n];
        }
        return null;
    }

    public Object clone(Object object) {
        Object object2 = this.newInstance();
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            try {
                this.put(object2, i, this.get(object, i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object2;
    }
}

