/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InvalidObjectException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ITableControl;
import javax.rad.util.TranslationMap;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.TableOrder;

public class JVxChart
extends JPanel
implements ITableControl,
Runnable {
    public static final int STYLE_LINES = 0;
    public static final int STYLE_AREA = 1;
    public static final int STYLE_BARS = 2;
    public static final int STYLE_PIE = 3;
    private ChartPanel chartPanel = null;
    private AbstractDataset dataset = null;
    private Axis vaX = null;
    private Axis vaY = null;
    private IDataBook dataBook = null;
    private int chartStyle = 0;
    private String sTitle = null;
    private String sXTitle = null;
    private String sYTitle = null;
    private String sXColumnName = null;
    private String[] saYColumnNames = null;
    private TranslationMap tmpTranslation = null;
    private boolean bFirstNotifyRepaintCall = true;
    private boolean bTranslationEnabled = true;

    public JVxChart() {
        this.setLayout(new BorderLayout());
    }

    public void notifyRepaint() {
        if (this.bFirstNotifyRepaintCall) {
            this.bFirstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    public void startEditing() {
    }

    public void cancelEditing() {
        if (this.dataset != null) {
            try {
                this.dataset.validateObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveEditing() throws ModelException {
    }

    public void setTranslation(TranslationMap translationMap) {
        if (this.tmpTranslation != translationMap) {
            this.tmpTranslation = translationMap;
            if (this.vaX != null) {
                this.vaX.setLabel(this.translate(this.sXTitle));
            }
            if (this.vaY != null) {
                this.vaY.setLabel(this.translate(this.sYTitle));
            }
            if (this.chartPanel != null) {
                this.chartPanel.getChart().setTitle(this.translate(this.sTitle));
            }
            this.notifyRepaint();
        }
    }

    public TranslationMap getTranslation() {
        return this.tmpTranslation;
    }

    public void setTranslationEnabled(boolean bl) {
        this.bTranslationEnabled = bl;
    }

    public boolean isTranslationEnabled() {
        return this.bTranslationEnabled;
    }

    public void run() {
        this.cancelEditing();
        this.bFirstNotifyRepaintCall = true;
    }

    public IDataBook getDataBook() {
        return this.dataBook;
    }

    public void setDataBook(IDataBook iDataBook) {
        this.uninstallChart();
        this.dataBook = iDataBook;
        this.installChart();
    }

    public int getChartStyle() {
        return this.chartStyle;
    }

    public void setChartStyle(int n) {
        if (n != this.chartStyle) {
            this.uninstallChart();
            this.chartStyle = n;
            this.installChart();
        }
    }

    public String getTitle() {
        return this.sTitle;
    }

    public void setTitle(String string) {
        this.sTitle = string;
    }

    public String getXAxisTitle() {
        return this.sXTitle;
    }

    public void setXAxisTitle(String string) {
        this.sXTitle = string;
    }

    public String getYAxisTitle() {
        return this.sYTitle;
    }

    public void setYAxisTitle(String string) {
        this.sYTitle = string;
    }

    public String getXColumnName() {
        return this.sXColumnName;
    }

    public void setXColumnName(String string) {
        this.uninstallChart();
        this.sXColumnName = string;
        this.installChart();
    }

    public String[] getYColumnNames() {
        return this.saYColumnNames;
    }

    public void setYColumnNames(String[] stringArray) {
        this.uninstallChart();
        this.saYColumnNames = stringArray;
        this.installChart();
    }

    private void uninstallChart() {
        if (this.chartPanel != null) {
            this.dataBook.removeControl(this);
            this.remove((Component)this.chartPanel);
            this.chartPanel = null;
            this.dataset = null;
        }
    }

    public String translate(String string) {
        if (!this.bTranslationEnabled || this.tmpTranslation == null || string == null) {
            return string;
        }
        return this.tmpTranslation.translate(string);
    }

    private void installChart() {
        if (this.dataBook != null && this.sXColumnName != null && this.saYColumnNames != null) {
            try {
                ColumnDefinition columnDefinition;
                Object object = null;
                if (this.chartStyle == 3) {
                    this.dataset = new DataBookCategoryDataset(this.dataBook, this.sXColumnName, this.saYColumnNames, this);
                    columnDefinition = TableOrder.BY_COLUMN;
                    if (this.saYColumnNames.length > 1) {
                        columnDefinition = TableOrder.BY_ROW;
                    }
                    object = new PiePlot((PieDataset)new CategoryToPieDataset((CategoryDataset)this.dataset, (TableOrder)columnDefinition, 0));
                    object.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}: {2}", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%")));
                } else {
                    columnDefinition = this.dataBook.getRowDefinition().getColumnDefinition(this.sXColumnName);
                    boolean bl = Date.class.isAssignableFrom(columnDefinition.getDataType().getTypeClass());
                    boolean bl2 = String.class.isAssignableFrom(columnDefinition.getDataType().getTypeClass());
                    this.dataset = bl2 ? new DataBookCategoryDataset(this.dataBook, this.sXColumnName, this.saYColumnNames, this) : new DataBookXYDataset(this.dataBook, this.sXColumnName, this.saYColumnNames, this);
                    Object object2 = this.chartStyle == 1 ? (bl2 ? new AreaRenderer() : new XYAreaRenderer(4)) : (this.chartStyle == 2 ? (bl2 ? new BarRenderer() : new ClusteredXYBarRenderer(0.0, true)) : (bl2 ? new LineAndShapeRenderer(true, true) : new XYLineAndShapeRenderer(true, true)));
                    if (bl) {
                        this.vaX = new DateAxis(this.translate(this.sXTitle));
                    } else if (bl2) {
                        this.vaX = new CategoryAxis(this.translate(this.sXTitle));
                        if (this.chartStyle != 2) {
                            ((CategoryAxis)this.vaX).setCategoryMargin(0.0);
                        }
                    } else {
                        this.vaX = new NumberAxis(this.translate(this.sXTitle));
                        ((NumberAxis)this.vaX).setAutoRangeIncludesZero(false);
                    }
                    this.vaY = new NumberAxis(this.translate(this.sYTitle));
                    object = bl2 ? new CategoryPlot((CategoryDataset)this.dataset, (CategoryAxis)this.vaX, (ValueAxis)this.vaY, (CategoryItemRenderer)object2) : new XYPlot((XYDataset)this.dataset, (ValueAxis)this.vaX, (ValueAxis)this.vaY, (XYItemRenderer)object2);
                    if (this.chartStyle == 1) {
                        object.setForegroundAlpha(0.65f);
                    }
                    if (object2 instanceof XYItemRenderer) {
                        ((XYItemRenderer)object2).setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
                        ((XYItemRenderer)object2).setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
                    } else if (object2 instanceof AbstractCategoryItemRenderer) {
                        ((AbstractCategoryItemRenderer)object2).setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
                    }
                }
                columnDefinition = new JFreeChart(this.translate(this.sTitle), JFreeChart.DEFAULT_TITLE_FONT, (Plot)object, true);
                columnDefinition.getLegend().setVisible(this.chartStyle != 3);
                this.chartPanel = new ChartPanel((JFreeChart)columnDefinition);
                this.add((Component)this.chartPanel, "Center");
                this.dataBook.addControl(this);
                this.notifyRepaint();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public static class DataBookXYDataset
    extends AbstractIntervalXYDataset
    implements XYDataset,
    TableXYDataset {
        private static BigDecimal percentage = new BigDecimal("0.9");
        private JVxChart chart;
        private IDataBook dataBook = null;
        private String xColumnName = null;
        private String[] yColumnNames = null;
        private BigDecimal minXDiff = null;
        private boolean bDateAxis;

        public DataBookXYDataset(IDataBook iDataBook, String string, String[] stringArray, JVxChart jVxChart) throws ModelException {
            this.dataBook = iDataBook;
            this.xColumnName = string;
            this.yColumnNames = stringArray;
            this.chart = jVxChart;
            this.bDateAxis = Date.class.isAssignableFrom(this.dataBook.getRowDefinition().getColumnDefinition(this.xColumnName).getDataType().getTypeClass());
        }

        public void validateObject() throws InvalidObjectException {
            this.minXDiff = null;
            super.validateObject();
        }

        public Number getX(int n, int n2) {
            try {
                IChangeableDataRow iChangeableDataRow = this.dataBook.getDataRow(n2);
                if (this.bDateAxis) {
                    return ((Date)iChangeableDataRow.getValue(this.xColumnName)).getTime();
                }
                return (Number)iChangeableDataRow.getValue(this.xColumnName);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Number getY(int n, int n2) {
            try {
                IChangeableDataRow iChangeableDataRow = this.dataBook.getDataRow(n2);
                return (Number)iChangeableDataRow.getValue(this.yColumnNames[n]);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Number getStartX(int n, int n2) {
            return this.getX(n, n2);
        }

        public Number getEndX(int n, int n2) {
            Number number;
            if (this.minXDiff == null) {
                int n3 = this.getItemCount();
                Number number2 = this.getX(n, 0);
                for (int i = 1; i < n3; ++i) {
                    Number number3 = this.getX(n, i);
                    if (number3 == null) continue;
                    if (number2 != null) {
                        double d = Math.abs(number3.doubleValue() - number2.doubleValue());
                        if (this.minXDiff == null || d < this.minXDiff.doubleValue()) {
                            this.minXDiff = BigDecimal.valueOf(d);
                        }
                    }
                    number2 = number3;
                }
                if (this.minXDiff == null) {
                    this.minXDiff = number2 == null || number2.doubleValue() == 0.0 ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(number2.doubleValue());
                }
            }
            if ((number = this.getX(n, n2)) == null) {
                return null;
            }
            return BigDecimal.valueOf(number.doubleValue() + this.minXDiff.doubleValue() * percentage.doubleValue());
        }

        public Number getStartY(int n, int n2) {
            return this.getY(n, n2);
        }

        public Number getEndY(int n, int n2) {
            double d = this.getY(n, n2).doubleValue();
            double d2 = n2 < this.getItemCount() - 1 ? Math.abs(this.getY(n, n2 + 1).doubleValue() - d) : (n2 == 0 ? (d == 0.0 ? d : 1.0) : Math.abs(d - this.getY(n, n2 - 1).doubleValue()));
            return BigDecimal.valueOf(d + d2 * percentage.doubleValue());
        }

        public int getItemCount(int n) {
            return this.getItemCount();
        }

        public int getItemCount() {
            try {
                this.dataBook.fetchAll();
                return this.dataBook.getRowCount();
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public int getSeriesCount() {
            return this.yColumnNames.length;
        }

        public Comparable getSeriesKey(int n) {
            try {
                return this.chart.translate(this.dataBook.getRowDefinition().getColumnDefinition(this.yColumnNames[n]).getLabel());
            }
            catch (Exception exception) {
                return this.chart.translate(this.yColumnNames[n]);
            }
        }
    }

    public static class DataBookCategoryDataset
    extends DefaultCategoryDataset {
        private JVxChart chart;
        private IDataBook dataBook = null;
        private String xColumnName = null;
        private String[] yColumnNames = null;

        public DataBookCategoryDataset(IDataBook iDataBook, String string, String[] stringArray, JVxChart jVxChart) {
            this.dataBook = iDataBook;
            this.xColumnName = string;
            this.yColumnNames = stringArray;
            this.chart = jVxChart;
        }

        public void validateObject() throws InvalidObjectException {
            this.clear();
            try {
                if (this.chart.chartStyle == 3 && this.yColumnNames.length > 1) {
                    String string = this.chart.translate(this.dataBook.getValueAsString(this.xColumnName));
                    for (String string2 : this.yColumnNames) {
                        String string3 = this.getColumnLabel(string2);
                        BigDecimal bigDecimal = (BigDecimal)this.dataBook.getValue(string2);
                        this.addValue(bigDecimal, (Comparable)((Object)string), (Comparable)((Object)string3));
                    }
                } else {
                    this.dataBook.fetchAll();
                    for (int i = 0; i < this.dataBook.getRowCount(); ++i) {
                        IChangeableDataRow iChangeableDataRow = this.dataBook.getDataRow(i);
                        String string = this.chart.translate(iChangeableDataRow.getValueAsString(this.xColumnName));
                        for (String string4 : this.yColumnNames) {
                            String string5 = this.getColumnLabel(string4);
                            BigDecimal bigDecimal = (BigDecimal)iChangeableDataRow.getValue(string4);
                            if (this.chart.chartStyle == 3) {
                                this.addValue(bigDecimal, (Comparable)((Object)string), (Comparable)((Object)string5));
                                continue;
                            }
                            this.addValue(bigDecimal, (Comparable)((Object)string5), (Comparable)((Object)string));
                        }
                    }
                }
            }
            catch (ModelException modelException) {
                throw new InvalidObjectException(modelException.getMessage());
            }
            super.validateObject();
        }

        private String getColumnLabel(String string) throws ModelException {
            ColumnDefinition columnDefinition = this.dataBook.getRowDefinition().getColumnDefinition(string);
            String string2 = columnDefinition.getLabel();
            if (string2 == null) {
                string2 = columnDefinition.getDefaultLabel();
            }
            string2 = this.chart.translate(string2);
            return string2;
        }
    }
}

