/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.event.IExecuteListener;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Execute {
    private String sProgram = null;
    private File fiWorkDir = null;
    private ArrayList<String> alParams = null;
    private HashMap<String, String> hmpEnvParams = null;
    private Process proc;
    private ProcessStreamReader psrOutput = null;
    private ProcessStreamReader psrError = null;
    private PrintStream psOutForward = null;
    private PrintStream psErrForward = null;
    private ILogger log = null;
    private List<IExecuteListener> listener = null;
    private boolean bParamsLog = true;
    private boolean bUseSystemEnv = false;
    private boolean bSendDisabled = false;
    private int iBufferCharCount = 4000;

    public void setProgram(String string) {
        this.sProgram = string;
    }

    public String getProgram() {
        return this.sProgram;
    }

    public void addParameter(String string) {
        if (this.alParams == null) {
            this.alParams = new ArrayList();
        }
        this.alParams.add(string);
    }

    public void addEnvironmentParameter(String string, String string2) {
        if (this.hmpEnvParams == null) {
            this.hmpEnvParams = new HashMap();
        }
        this.hmpEnvParams.put(string, string2);
    }

    public void setUseSystemEnvironmentParameter(boolean bl) {
        this.bUseSystemEnv = bl;
    }

    public boolean isUseSystemEnvironmentParameter() {
        return this.bUseSystemEnv;
    }

    private String[] getEnvironmentParameters() {
        Map<String, String> map;
        Object object;
        if (this.hmpEnvParams == null) {
            return null;
        }
        if (this.bUseSystemEnv) {
            object = new ProcessBuilder("command");
            map = ((ProcessBuilder)object).environment();
            for (Map.Entry<String, String> object2 : this.hmpEnvParams.entrySet()) {
                map.put(object2.getKey(), object2.getValue());
            }
        } else {
            map = this.hmpEnvParams;
        }
        object = new String[map.size()];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            object[n++] = (String)entry.getKey() + "=" + CommonUtil.nvl(entry.getValue(), "");
        }
        return object;
    }

    private String[] getCommand() {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        String string = this.getProgram();
        arrayUtil.add(string);
        if (this.alParams != null) {
            for (String string2 : this.alParams) {
                if (string2 == null) {
                    arrayUtil.add(" ");
                    continue;
                }
                arrayUtil.add(string2);
            }
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(boolean bl) throws Exception {
        this.destroy();
        String[] stringArray = this.getCommand();
        if (this.log == null) {
            this.log = LoggerFactory.getInstance(this.getClass());
        }
        Runtime runtime = Runtime.getRuntime();
        this.proc = null;
        try {
            if (this.bParamsLog) {
                this.log.info(new Object[]{stringArray});
            } else {
                this.log.info(this.getProgram());
            }
            this.proc = this.fiWorkDir == null ? runtime.exec(stringArray, this.getEnvironmentParameters()) : runtime.exec(stringArray, this.getEnvironmentParameters(), this.fiWorkDir);
            if (this.bSendDisabled) {
                this.proc.getOutputStream().close();
            }
            this.psrOutput = new ProcessStreamReader(this.proc.getInputStream(), this.psOutForward);
            this.psrOutput.iCharCount = this.iBufferCharCount;
            this.psrError = new ProcessStreamReader(this.proc.getErrorStream(), this.psErrForward);
            this.psrError.iCharCount = this.iBufferCharCount;
            if (bl) {
                int n = this.proc.waitFor();
                if (this.bParamsLog) {
                    this.log.debug(stringArray, "\n:: OUTPUT ::\n~~~~~~~~~~~~\n", this.getOutput(), "\n:: TYPE_ERROR  ::\n~~~~~~~~~~~~\n", this.getError());
                } else {
                    this.log.debug(this.getProgram(), "\n:: OUTPUT ::\n~~~~~~~~~~~~\n", this.getOutput(), "\n:: TYPE_ERROR  ::\n~~~~~~~~~~~~\n", this.getError());
                }
                boolean bl2 = n == 0;
                return bl2;
            }
            ThreadHandler.start(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Execute.this.proc.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        Execute.this.destroy();
                    }
                }
            });
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (bl) {
                this.destroy();
            }
        }
    }

    public void destroy() {
        if (this.psrOutput != null) {
            this.psrOutput.terminate();
        }
        if (this.psrError != null) {
            this.psrError.terminate();
        }
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
        if (this.listener != null) {
            for (IExecuteListener iExecuteListener : this.listener) {
                try {
                    iExecuteListener.destroyed(this);
                }
                catch (Throwable throwable) {
                    this.log.debug(throwable);
                }
            }
        }
    }

    public String getError() {
        if (this.psrError != null) {
            return this.psrError.getResult();
        }
        return null;
    }

    public String getOutput() {
        if (this.psrOutput != null) {
            return this.psrOutput.getResult();
        }
        return null;
    }

    public String getAndClearOutput() {
        if (this.psrOutput != null) {
            return this.psrOutput.getAndClearResult();
        }
        return null;
    }

    public void clearOutput() {
        if (this.psrOutput != null) {
            this.psrOutput.clear();
        }
    }

    public void setWorkingDirectory(File file) {
        this.fiWorkDir = file;
    }

    public File getWorkingDirectory() {
        return this.fiWorkDir;
    }

    public void setOutputForwarder(PrintStream printStream) {
        this.psOutForward = printStream;
    }

    public PrintStream getOutputForwarder() {
        return this.psOutForward;
    }

    public void setErrorForwarder(PrintStream printStream) {
        this.psErrForward = printStream;
    }

    public PrintStream getErrorForwarder() {
        return this.psErrForward;
    }

    public void addListener(IExecuteListener iExecuteListener) {
        if (this.listener == null) {
            this.listener = new ArrayUtil<IExecuteListener>();
        }
        this.listener.add(iExecuteListener);
    }

    public void removeListener(IExecuteListener iExecuteListener) {
        if (this.listener != null) {
            this.listener.remove(iExecuteListener);
            if (this.listener.size() == 0) {
                this.listener = null;
            }
        }
    }

    public void send(byte[] byArray) throws IOException {
        if (this.bSendDisabled) {
            throw new IOException("Can't send data because noOutput option was set!");
        }
        if (this.proc != null) {
            OutputStream outputStream = this.proc.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
        }
    }

    public boolean isRunning() {
        try {
            if (this.proc != null) {
                this.proc.exitValue();
            }
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public void setParamsLogEnabled(boolean bl) {
        this.bParamsLog = bl;
    }

    public boolean isParamsLogEnabled() {
        return this.bParamsLog;
    }

    public void setBufferCharacterCount(int n) {
        this.iBufferCharCount = n;
    }

    public int getBufferCharacterCount() {
        return this.iBufferCharCount;
    }

    public void disableSend() {
        this.bSendDisabled = true;
        if (this.proc != null) {
            try {
                this.proc.getOutputStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class ProcessStreamReader
    implements Runnable {
        private InputStream isIn = null;
        private Thread thRead = null;
        private StringBuffer sbResult;
        private PrintStream psForwarder;
        private int iCharCount = -1;

        ProcessStreamReader(InputStream inputStream, PrintStream printStream) {
            this.isIn = inputStream;
            this.thRead = ThreadHandler.start(this);
            this.psForwarder = printStream;
            this.sbResult = new StringBuffer();
        }

        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n;
                while ((n = this.isIn.read(byArray)) >= 0) {
                    String string = new String(byArray, 0, n);
                    if (this.psForwarder != null) {
                        this.psForwarder.append(string);
                    }
                    if (this.iCharCount > 0 && this.sbResult.length() > this.iCharCount) {
                        this.sbResult = new StringBuffer();
                    }
                    this.sbResult.append(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void terminate() {
            this.thRead = ThreadHandler.stop(this.thRead);
        }

        public String getResult() {
            return this.sbResult.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAndClearResult() {
            StringBuffer stringBuffer = this.sbResult;
            synchronized (stringBuffer) {
                String string = this.sbResult.toString();
                this.sbResult.setLength(0);
                return string;
            }
        }

        public void clear() {
            this.sbResult.setLength(0);
        }
    }
}

