/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static int toIntLittleEndian(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = n; i < n + 4; ++i) {
            n2 |= (byArray[i] & 0xFF) << i * 8;
        }
        return n2;
    }

    public static int toInt(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 3;
        while (n3 < 4) {
            n2 |= (byArray[n + n3] & 0xFF) << n4 * 8;
            ++n3;
            --n4;
        }
        return n2;
    }

    public static byte[] toByteLittleEndian(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static byte[] toByte(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[0] = (byte)(n >> 24 & 0xFF);
        return byArray;
    }
}

