/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.LocaleUtil;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    private static final char TEXTSEPARATOR = '\'';
    private static Map<String, DateSymbols> dateSymbolsByLocale = new HashMap<String, DateSymbols>();
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat parseDateFormat;
    private Locale dateFormatLocale;
    private Locale creationLocale = null;
    private String creationPattern = null;
    private List<String>[] parsedPattern = null;
    private boolean[] ignorePattern = null;
    private List<String>[] parsedReference = null;
    private boolean strictFormatCheck = false;
    private int hoursIndex;
    private int amPmIndex;
    private DateSymbols dateSymbols = null;

    public DateUtil() {
        this.setDatePattern(null, null);
    }

    @Deprecated
    public DateUtil(DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public DateUtil(String string) {
        this.setDatePattern(string);
    }

    public DateUtil(String string, Locale locale) {
        this.setDatePattern(string, locale);
    }

    private static int findIndex(String string, String[] stringArray, String[] stringArray2) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            return n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string)) continue;
            return n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (string.length() > stringArray[n].length() + 2 || stringArray2[n].length() <= 0 || !string.startsWith(stringArray2[n])) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateSymbols getOrCreateDateSymbols(Locale locale, SimpleDateFormat simpleDateFormat) {
        String string = locale.toString();
        Map<String, DateSymbols> map = dateSymbolsByLocale;
        synchronized (map) {
            DateSymbols dateSymbols = dateSymbolsByLocale.get(string);
            if (dateSymbols == null) {
                dateSymbols = new DateSymbols(simpleDateFormat);
                dateSymbolsByLocale.put(string, dateSymbols);
            }
            return dateSymbols;
        }
    }

    private static String toLowerAndWithoutUmlauts(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 65535;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            switch (c) {
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e4': {
                    stringBuilder.append('a');
                    break;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': {
                    stringBuilder.append('u');
                    break;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f6': {
                    stringBuilder.append('o');
                    break;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': {
                    stringBuilder.append('o');
                    break;
                }
                case '\u00ec': 
                case '\u00ed': {
                    stringBuilder.append('i');
                    break;
                }
                case 'e': {
                    if (n == 97 || n == 117 || n == 111) break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            n = c;
        }
        return stringBuilder.toString().intern();
    }

    public Date parse(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        this.setDatePattern(this.creationPattern, this.creationLocale);
        return this.parseStringIntern(string);
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        this.setDatePattern(this.creationPattern, this.creationLocale);
        return this.dateFormat.format(date);
    }

    @Deprecated
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void createReferenceDate() {
        String string;
        int n;
        int n2;
        this.parsedPattern = null;
        this.ignorePattern = null;
        this.parsedReference = null;
        this.dateSymbols = DateUtil.getOrCreateDateSymbols(this.dateFormatLocale, this.dateFormat);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        String string2 = this.dateFormat.toPattern();
        this.parsedPattern = this.getParsed(string2, true);
        this.ignorePattern = new boolean[this.parsedPattern[0].size()];
        boolean bl = false;
        boolean bl2 = false;
        this.hoursIndex = -1;
        this.amPmIndex = -1;
        block6: for (n2 = 0; n2 < this.ignorePattern.length; ++n2) {
            char c = this.parsedPattern[0].get(n2).charAt(0);
            switch (c) {
                case 'D': 
                case 'F': 
                case 'd': 
                case 'u': {
                    bl = true;
                }
                case 'E': 
                case 'M': 
                case 'W': 
                case 'Y': 
                case 'w': 
                case 'y': {
                    bl2 = true;
                    continue block6;
                }
                case 'H': 
                case 'h': {
                    this.hoursIndex = n2;
                    continue block6;
                }
                case 'a': {
                    this.amPmIndex = n2;
                    continue block6;
                }
            }
        }
        if (!bl2) {
            gregorianCalendar.set(2, 0);
            gregorianCalendar.set(1, 1970);
            gregorianCalendar.set(5, 1);
        }
        int n3 = n2 = this.hoursIndex >= 0 && this.amPmIndex < 0 && this.parsedPattern[0].get(this.hoursIndex).charAt(0) == 'h' ? 1 : 0;
        if (n2 != 0) {
            StringBuilder stringBuilder = new StringBuilder(48);
            stringBuilder.append(this.parsedPattern[1].get(0));
            for (n = 0; n < this.ignorePattern.length; ++n) {
                string = this.parsedPattern[0].get(n);
                if (string.startsWith("h")) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
                stringBuilder.append(this.parsedPattern[1].get(n + 1));
            }
            n = this.dateFormat.isLenient() ? 1 : 0;
            this.dateFormat = new SimpleDateFormat(stringBuilder.toString(), this.dateFormatLocale);
            this.dateFormat.setLenient(n != 0);
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append(this.parsedPattern[1].get(0));
        for (n = 0; n < this.ignorePattern.length; ++n) {
            boolean bl3;
            string = this.parsedPattern[0].get(n);
            this.ignorePattern[n] = bl3 = bl && string.startsWith("E");
            if (bl3) continue;
            if (string.startsWith("E")) {
                gregorianCalendar.set(7, 2);
            }
            if (n2 != 0 && string.startsWith("h")) {
                string = string.toUpperCase();
            }
            stringBuilder.append(string);
            stringBuilder.append(this.parsedPattern[1].get(n + 1));
        }
        this.parseDateFormat = new SimpleDateFormat(stringBuilder.toString(), this.dateFormatLocale);
        this.parseDateFormat.setLenient(false);
        int n4 = this.parsedPattern[1].size();
        for (n = 0; n < n4; ++n) {
            this.parsedPattern[1].set(n, this.eliminateSingleQuote(this.parsedPattern[1].get(n)));
        }
        String string3 = this.dateFormat.format(gregorianCalendar.getTime());
        this.parsedReference = this.getParsed(string3, false);
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            this.setDatePattern(null, LocaleUtil.getDefault());
        } else if (dateFormat instanceof SimpleDateFormat) {
            this.dateFormat = (SimpleDateFormat)dateFormat;
            this.dateFormatLocale = LocaleUtil.getDefault();
            this.creationLocale = null;
            this.creationPattern = this.dateFormat.toPattern();
            this.createReferenceDate();
        } else {
            throw new IllegalArgumentException("Only SimpleDateFormat is supported!");
        }
    }

    public String getDatePattern() {
        return this.dateFormat.toPattern();
    }

    public void setDatePattern(String string) {
        this.setDatePattern(string, null);
    }

    public void setDatePattern(String string, Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = LocaleUtil.getDefault();
        }
        if (string == null) {
            if (locale != this.creationLocale || locale2 != this.dateFormatLocale || this.creationPattern != null) {
                this.dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 3, locale2);
                this.dateFormatLocale = locale2;
                this.creationLocale = locale;
                this.creationPattern = string;
                this.createReferenceDate();
            }
        } else if (locale != this.creationLocale || locale2 != this.dateFormatLocale || !string.equals(this.creationPattern)) {
            this.dateFormat = new SimpleDateFormat(string, locale2);
            this.dateFormatLocale = locale2;
            this.creationLocale = locale;
            this.creationPattern = string;
            this.createReferenceDate();
        }
    }

    public boolean isStrictFormatCheck() {
        return this.strictFormatCheck;
    }

    public void setStrictFormatCheck(boolean bl) {
        this.strictFormatCheck = bl;
    }

    private String getMonthPart(String string, String string2) {
        String[] stringArray = new String[]{string.toLowerCase(), DateUtil.toLowerAndWithoutUmlauts(string)};
        for (int i = 0; i < 2; ++i) {
            int n = DateUtil.findIndex(stringArray[i], this.dateSymbols.lowerMonths[i], this.dateSymbols.lowerShortMonths[i]) + 1;
            if (n <= 0) continue;
            if (string2.length() == 2 && n < 10) {
                return "0" + n;
            }
            if (string2.length() <= 2) {
                return String.valueOf(n);
            }
            if (string2.length() == 3) {
                return this.dateSymbols.shortMonths[n - 1];
            }
            return this.dateSymbols.months[n - 1];
        }
        return string;
    }

    private String getWeekdayPart(String string, String string2) {
        int n = DateUtil.findIndex(DateUtil.toLowerAndWithoutUmlauts(string), this.dateSymbols.lowerWeekdays, this.dateSymbols.lowerShortWeekdays);
        if (n >= 0) {
            if (string2.length() <= 3) {
                return this.dateSymbols.shortWeekdays[n];
            }
            return this.dateSymbols.weekdays[n];
        }
        return string;
    }

    private String getAmPmPart(String string, String string2) {
        int n = DateUtil.findIndex(DateUtil.toLowerAndWithoutUmlauts(string), this.dateSymbols.lowerAmPm, this.dateSymbols.lowerAmPm);
        if (n >= 0) {
            return this.dateSymbols.amPm[n];
        }
        return string;
    }

    private String getPart(String string, String string2, String string3) {
        try {
            if (string2.startsWith("MMM")) {
                int n = Integer.parseInt(string);
                if (string2.length() == 3) {
                    return this.dateSymbols.shortMonths[(n - 1) % 12];
                }
                return this.dateSymbols.months[(n - 1) % 12];
            }
            if (string2.toLowerCase().startsWith("yy") && string3.length() > string.length()) {
                int n = Integer.parseInt(string3.substring(0, string3.length() - string.length()) + string);
                int n2 = Integer.parseInt(string3);
                if (string.length() == 2 && n >= n2 + 50) {
                    n -= 100;
                }
                return String.valueOf(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (string2.charAt(0)) {
            case 'M': {
                return this.getMonthPart(string, string2);
            }
            case 'E': {
                return this.getWeekdayPart(string, string2);
            }
        }
        return string;
    }

    private String getStrictPart(String string, String string2, String string3) {
        if (string2.startsWith("MMM")) {
            return this.getMonthPart(string, string2);
        }
        if (string2.startsWith("E")) {
            return this.getWeekdayPart(string, string2);
        }
        return string;
    }

    private char getCharacterType(char c, boolean bl) {
        if (Character.isLetterOrDigit(c)) {
            if (bl) {
                return c;
            }
            return Character.isDigit(c) ? (char)'0' : 'a';
        }
        if (bl && c == '\'') {
            return c;
        }
        return ' ';
    }

    private String eliminateSingleQuote(String string) {
        int n = string.indexOf(39);
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n2 = 0;
            while (n >= 0) {
                stringBuilder.append(string.substring(n2, n));
                n2 = n + 1;
                if ((n = string.indexOf(39, n2)) != n2) continue;
                --n2;
            }
            stringBuilder.append(string.substring(n2));
            return stringBuilder.toString();
        }
        return string;
    }

    private String addSeparator(List<String> list, String string, boolean bl) {
        list.add(string);
        if (bl) {
            return null;
        }
        if (list.size() < this.parsedPattern[1].size()) {
            return this.parsedPattern[1].get(list.size());
        }
        return "";
    }

    private int getTimeZonePart(String string, StringBuilder stringBuilder) {
        String string2 = DateUtil.toLowerAndWithoutUmlauts(string);
        int n = 0;
        if (string2.startsWith("gmt")) {
            for (n = 3; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
            }
        }
        if (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '+' || c == '-') {
                ++n;
            } else if (n > 0) {
                c = '+';
            }
            if (n == 0) {
                for (int i = 0; i < this.dateSymbols.lowerZoneStrings.length; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        if (!string2.startsWith(this.dateSymbols.lowerZoneStrings[i][j])) continue;
                        stringBuilder.append(this.dateSymbols.zoneStrings[i][j]);
                        return stringBuilder.length();
                    }
                }
                if (c == 'z') {
                    stringBuilder.append("+0000");
                    return 1;
                }
            } else {
                char c2 = string2.charAt(n);
                if (Character.isDigit(c2)) {
                    stringBuilder.append(c);
                    do {
                        if (c2 == ':') {
                            if (stringBuilder.length() < 3) {
                                stringBuilder.insert(1, '0');
                            }
                        } else {
                            stringBuilder.append(c2);
                        }
                        c2 = ++n < string2.length() ? (char)string2.charAt(n) : (char)'\uffff';
                    } while (stringBuilder.length() < 5 && (Character.isDigit(c2) || c2 == 58));
                    if (stringBuilder.length() < 5) {
                        if (stringBuilder.charAt(1) != '0') {
                            stringBuilder.insert(1, '0');
                        }
                        while (stringBuilder.length() < 5) {
                            stringBuilder.append('0');
                        }
                    }
                    return n;
                }
            }
        }
        if (n > 0) {
            stringBuilder.append("+0000");
            return n;
        }
        return -1;
    }

    private List<String>[] getParsed(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.length();
        String string2 = DateUtil.toLowerAndWithoutUmlauts(string);
        int n2 = 0;
        char c = string.charAt(0);
        boolean bl2 = Character.isLetterOrDigit(c);
        int n3 = this.getCharacterType(c, bl);
        boolean bl3 = false;
        String string3 = bl ? null : this.parsedPattern[1].get(0);
        for (int i = 1; i < n; ++i) {
            int n4;
            char c2 = string.charAt(i);
            if (!bl && n3 == 97 && !Character.isLetterOrDigit(c2)) {
                String string4 = string2.substring(n2, i + 1);
                for (n4 = 0; n4 < this.dateSymbols.ignoreSpaceCheck.length; ++n4) {
                    if (!this.dateSymbols.ignoreSpaceCheck[n4].startsWith(string4)) continue;
                    c2 = 'a';
                    break;
                }
            }
            boolean bl4 = Character.isLetterOrDigit(c2);
            n4 = this.getCharacterType(c2, bl);
            if (bl && n3 == 39) {
                if (bl3) {
                    if (n4 != 39) {
                        bl3 = false;
                    }
                } else if (n4 != 39) {
                    bl3 = true;
                }
            }
            if (!bl3) {
                if (!bl && string3.trim().length() > 0 && string.substring(i - 1).startsWith(string3)) {
                    bl2 = false;
                    n3 = 32;
                    if ((i += string3.length() - 1) < string.length()) {
                        c2 = string.charAt(i);
                        bl4 = Character.isLetterOrDigit(c2);
                        n4 = this.getCharacterType(c2, bl);
                    } else {
                        c2 = '0';
                        bl4 = true;
                        n4 = 48;
                    }
                }
                String string5 = string.substring(n2, i);
                if (!bl) {
                    int n5 = 0;
                    int n6 = 65535;
                    boolean bl5 = false;
                    if (arrayList.size() < this.parsedPattern[0].size()) {
                        n6 = this.parsedPattern[0].get(arrayList.size()).charAt(0);
                        switch (n6) {
                            case 121: {
                                n5 = 4;
                                break;
                            }
                            case 83: {
                                n5 = 3;
                                break;
                            }
                            case 88: 
                            case 90: 
                            case 122: {
                                bl5 = true;
                            }
                            case 69: 
                            case 71: 
                            case 97: {
                                n5 = 0;
                                break;
                            }
                            default: {
                                n5 = 2;
                            }
                        }
                    }
                    if (!bl && bl5 && (bl4 || c2 == '+' || c2 == '-')) {
                        if (!bl2) {
                            string3 = this.addSeparator(arrayList2, string5, bl);
                            n2 = i;
                        }
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        int n7 = this.getTimeZonePart(string.substring(n2), stringBuilder);
                        if (n7 < 0) {
                            arrayList.add(this.parsedReference[0].get(arrayList.size()));
                        } else {
                            arrayList.add(stringBuilder.toString());
                            i = (n2 += n7) - 1;
                            c2 = string.charAt(i);
                            bl4 = true;
                            n4 = 122;
                            bl2 = bl4;
                            n3 = n4;
                        }
                    }
                    if (bl2 && bl4 && n3 == 48 && n4 == 48 && string5.length() == n5) {
                        n3 = 49;
                    } else if (n4 == 97 && n5 > 0 && n6 != 77) {
                        if (bl2) {
                            arrayList.add(string5);
                            bl2 = false;
                            n3 = 32;
                            n2 = i;
                        } else {
                            arrayList.add(this.parsedReference[0].get(arrayList.size()));
                        }
                        if (!bl && string3.length() > 0 && string.substring(i).startsWith(string3)) {
                            c2 = string.charAt(i);
                            bl4 = bl2;
                            n4 = n3;
                        } else {
                            string3 = this.addSeparator(arrayList2, "", bl);
                            if (!bl && string3.length() > 0 && string.substring(i).startsWith(string3)) {
                                c2 = string.charAt(i);
                                bl4 = bl2;
                                n4 = n3;
                            } else {
                                c2 = string.charAt(--i);
                                bl4 = bl2;
                                n4 = n3;
                            }
                        }
                    } else if (bl2 && arrayList.size() < this.parsedPattern[0].size() && this.parsedPattern[0].get(arrayList.size()).startsWith("E") && this.dateSymbols.lowerWeekdays != null && DateUtil.findIndex(DateUtil.toLowerAndWithoutUmlauts(string5), this.dateSymbols.lowerWeekdays, this.dateSymbols.lowerShortWeekdays) < 0) {
                        arrayList.add(this.parsedReference[0].get(arrayList.size()));
                        string3 = this.addSeparator(arrayList2, "", bl);
                    }
                }
                if (bl2 != bl4 || bl2 && n3 != n4) {
                    if (bl2) {
                        arrayList.add(string5);
                        if (arrayList2.size() == 0) {
                            string3 = this.addSeparator(arrayList2, "", bl);
                        }
                        if (bl2 == bl4 && n3 != n4 && (bl || string3.length() == 0 || !string.substring(i).startsWith(string3))) {
                            string3 = this.addSeparator(arrayList2, "", bl);
                        }
                    } else {
                        string3 = this.addSeparator(arrayList2, string5, bl);
                    }
                    n2 = i;
                }
            }
            bl2 = bl4;
            n3 = n4;
            c = c2;
        }
        String string6 = string.substring(n2);
        if (bl2) {
            arrayList.add(string6);
            if (arrayList2.size() == 0) {
                arrayList2.add("");
            }
            arrayList2.add("");
        } else {
            arrayList2.add(string6);
        }
        return new List[]{arrayList, arrayList2};
    }

    private Date parseStringIntern(String string) throws ParseException {
        try {
            int n;
            List<String>[] listArray = this.getParsed(string, false);
            int n2 = listArray[0].size();
            int n3 = this.strictFormatCheck ? listArray[1].size() : this.parsedPattern[0].size();
            String string2 = null;
            if (!this.strictFormatCheck && this.amPmIndex >= 0) {
                string2 = this.amPmIndex < listArray[0].size() ? this.getAmPmPart(listArray[0].get(this.amPmIndex), this.parsedPattern[0].get(this.amPmIndex)) : this.parsedReference[0].get(this.amPmIndex);
                if (this.hoursIndex >= 0 && this.hoursIndex < listArray[0].size()) {
                    try {
                        int n4 = Integer.parseInt(listArray[0].get(this.hoursIndex));
                        int n5 = n = this.parsedPattern[0].get(this.hoursIndex).charAt(this.hoursIndex) == 'H' ? 1 : 0;
                        if (n4 >= 12) {
                            string2 = this.dateSymbols.amPm[1];
                            if (n == 0) {
                                listArray[0].set(this.hoursIndex, String.valueOf(88 + n4).substring(1));
                            }
                        } else if (n != 0) {
                            string2 = this.dateSymbols.amPm[0];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder(48);
            if (this.strictFormatCheck) {
                stringBuilder.append(listArray[1].get(0));
            } else {
                stringBuilder.append(this.parsedPattern[1].get(0));
            }
            int n6 = this.parsedPattern[0].size();
            for (n = 0; n < n6; ++n) {
                if (this.ignorePattern[n]) continue;
                if (n == this.amPmIndex && string2 != null) {
                    stringBuilder.append(string2);
                } else if (n < n2) {
                    if (this.strictFormatCheck) {
                        stringBuilder.append(this.getStrictPart(listArray[0].get(n), this.parsedPattern[0].get(n), this.parsedReference[0].get(n)));
                    } else {
                        stringBuilder.append(this.getPart(listArray[0].get(n), this.parsedPattern[0].get(n), this.parsedReference[0].get(n)));
                    }
                } else if (!this.strictFormatCheck) {
                    stringBuilder.append(this.parsedReference[0].get(n));
                }
                if (n >= n3) continue;
                if (this.strictFormatCheck) {
                    stringBuilder.append(listArray[1].get(n + 1));
                    continue;
                }
                stringBuilder.append(this.parsedPattern[1].get(n + 1));
            }
            return this.parseDateFormat.parse(stringBuilder.toString());
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException("Wrong Dateformat", 0);
        }
    }

    public static String format(long l, String string) {
        return DateUtil.format(new Date(l), string);
    }

    public static String format(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static Date getDate(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, n);
        calendar.set(2, n2 - 1);
        calendar.set(1, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date convert(Date date, String string, String string2) {
        return DateUtil.convert(date, TimeZone.getTimeZone(string), TimeZone.getTimeZone(string2));
    }

    public static Date convert(Date date, TimeZone timeZone, TimeZone timeZone2) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance(timeZone2);
        calendar2.setTime(date);
        int n = calendar.get(15) + calendar.get(16);
        int n2 = calendar2.get(15) + calendar2.get(16);
        return new Date(calendar2.getTimeInMillis() + (long)n2 - (long)n);
    }

    private static final class DateSymbols {
        private String[] months = null;
        private String[] shortMonths = null;
        private String[][] lowerMonths = null;
        private String[][] lowerShortMonths = null;
        private String[] weekdays = null;
        private String[] shortWeekdays = null;
        private String[] lowerWeekdays = null;
        private String[] lowerShortWeekdays = null;
        private String[] amPm = null;
        private String[] lowerAmPm = null;
        private String[][] zoneStrings = null;
        private String[][] lowerZoneStrings = null;
        private String[] ignoreSpaceCheck = null;

        private DateSymbols(SimpleDateFormat simpleDateFormat) {
            int n;
            DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
            this.months = dateFormatSymbols.getMonths();
            this.shortMonths = dateFormatSymbols.getShortMonths();
            this.lowerMonths = new String[2][this.months.length];
            this.lowerShortMonths = new String[2][this.months.length];
            for (n = 0; n < this.months.length; ++n) {
                this.lowerMonths[0][n] = this.months[n].toLowerCase();
                this.lowerShortMonths[0][n] = this.shortMonths[n].toLowerCase();
                this.lowerMonths[1][n] = DateUtil.toLowerAndWithoutUmlauts(this.months[n]);
                this.lowerShortMonths[1][n] = DateUtil.toLowerAndWithoutUmlauts(this.shortMonths[n]);
            }
            this.weekdays = dateFormatSymbols.getWeekdays();
            this.shortWeekdays = dateFormatSymbols.getShortWeekdays();
            this.lowerWeekdays = new String[this.weekdays.length];
            this.lowerShortWeekdays = new String[this.weekdays.length];
            for (n = 0; n < this.weekdays.length; ++n) {
                this.lowerWeekdays[n] = DateUtil.toLowerAndWithoutUmlauts(this.weekdays[n]);
                this.lowerShortWeekdays[n] = DateUtil.toLowerAndWithoutUmlauts(this.shortWeekdays[n]);
            }
            this.amPm = dateFormatSymbols.getAmPmStrings();
            this.lowerAmPm = new String[this.amPm.length];
            for (n = 0; n < this.amPm.length; ++n) {
                this.lowerAmPm[n] = DateUtil.toLowerAndWithoutUmlauts(this.amPm[n]);
            }
            this.zoneStrings = dateFormatSymbols.getZoneStrings();
            this.lowerZoneStrings = new String[this.zoneStrings.length][];
            for (n = 0; n < this.zoneStrings.length; ++n) {
                this.lowerZoneStrings[n] = new String[5];
                for (int i = 0; i < 5; ++i) {
                    this.lowerZoneStrings[n][i] = DateUtil.toLowerAndWithoutUmlauts(this.zoneStrings[n][i]);
                }
            }
            this.ignoreSpaceCheck = ArrayUtil.addAll(this.lowerMonths[1], this.lowerShortMonths[1]);
            this.ignoreSpaceCheck = ArrayUtil.addAll(this.ignoreSpaceCheck, this.lowerWeekdays);
            this.ignoreSpaceCheck = ArrayUtil.addAll(this.ignoreSpaceCheck, this.lowerShortWeekdays);
            this.ignoreSpaceCheck = ArrayUtil.addAll(this.ignoreSpaceCheck, this.lowerAmPm);
        }
    }
}

