/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean contains(Throwable throwable, Class<? extends Throwable> clazz) {
        return ExceptionUtil.getThrowable(throwable, clazz) != null;
    }

    public static String dump(Throwable throwable, boolean bl) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (bl) {
            throwable.printStackTrace(printWriter);
        } else {
            printWriter.println(throwable);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                printWriter.println("\tat " + stackTraceElement);
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static List<String> getMessages(Throwable throwable) {
        if (throwable == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Throwable throwable2 = throwable;
        do {
            arrayList.add(throwable2.getMessage());
        } while ((throwable2 = throwable2.getCause()) != null);
        return arrayList;
    }

    public static String getMessages(Throwable throwable, String string) {
        List<String> list = ExceptionUtil.getMessages(throwable);
        if (list.isEmpty()) {
            return "";
        }
        return StringUtil.concat(string, list.toArray(new String[list.size()]));
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static <T extends Throwable> T getThrowable(Throwable throwable, Class<T> clazz) {
        if (throwable == null || clazz == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        do {
            if (!clazz.isAssignableFrom(throwable2.getClass())) continue;
            return (T)throwable2;
        } while ((throwable2 = throwable2.getCause()) != null);
        return null;
    }

    public static List<Throwable> getThrowables(Throwable throwable) {
        if (throwable == null) {
            return Collections.emptyList();
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        Throwable throwable2 = throwable;
        do {
            arrayList.add(throwable2);
        } while ((throwable2 = throwable2.getCause()) != null);
        return arrayList;
    }
}

