/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui.menu;

import java.util.ArrayList;
import java.util.List;
import javax.rad.genui.UIComponent;
import javax.rad.genui.UIContainer;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UILayout;
import javax.rad.genui.UIResource;
import javax.rad.genui.menu.AbstractUIMenuItem;
import javax.rad.genui.menu.UISeparator;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ILayout;
import javax.rad.ui.menu.IMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMenu
extends AbstractUIMenuItem<IMenu>
implements IMenu {
    private ILayout uiLayout = null;
    protected List<IComponent> components = new ArrayList<IComponent>(4);
    private boolean bAddNotify = false;

    public UIMenu() {
        super(UIFactoryManager.getFactory().createMenu());
    }

    protected UIMenu(IMenu iMenu) {
        super(iMenu);
    }

    public UIMenu(String string) {
        this();
        this.setText(string);
    }

    public UIMenu(String string, IComponent ... iComponentArray) {
        this();
        this.setText(string);
        if (iComponentArray != null && iComponentArray.length > 0) {
            for (IComponent iComponent : iComponentArray) {
                this.add(iComponent);
            }
        }
    }

    @Override
    public ILayout getLayout() {
        return this.uiLayout;
    }

    @Override
    public void setLayout(ILayout iLayout) {
        if (iLayout instanceof UILayout) {
            ((IMenu)this.uiResource).setLayout((ILayout)((UILayout)iLayout).getUIResource());
        } else {
            ((IMenu)this.uiResource).setLayout(iLayout);
        }
        this.uiLayout = iLayout;
    }

    @Override
    public void addSeparator() {
        this.addSeparator(-1);
    }

    @Override
    public void addSeparator(int n) {
        UISeparator uISeparator = new UISeparator();
        if (n < 0) {
            this.components.add(uISeparator);
        } else {
            this.components.add(n, uISeparator);
        }
        uISeparator.setParent(this);
        try {
            ((IMenu)this.uiResource).add((IComponent)uISeparator.getUIResource(), null, n);
        }
        catch (RuntimeException runtimeException) {
            this.components.remove(uISeparator);
            uISeparator.setParent(null);
            throw runtimeException;
        }
        catch (Error error) {
            this.components.remove(uISeparator);
            uISeparator.setParent(null);
            throw error;
        }
        if (this.isNotified() && !uISeparator.isNotified()) {
            uISeparator.addNotify();
        }
    }

    @Override
    public void add(IComponent iComponent) {
        this.add(iComponent, -1);
    }

    @Override
    public void add(IComponent iComponent, Object object) {
        this.add(iComponent, object, -1);
    }

    @Override
    public void add(IComponent iComponent, int n) {
        this.add(iComponent, null, n);
    }

    @Override
    public void add(IComponent iComponent, Object object, int n) {
        if (object instanceof String) {
            IContainer iContainer = AbstractUIMenuItem.getMenu(this, (String)object);
            iContainer.add(iComponent, null, n);
        } else {
            this.addIntern(iComponent, object, n);
        }
    }

    @Override
    public void remove(int n) {
        ((IMenu)this.uiResource).remove(n);
        IComponent iComponent = this.components.remove(n);
        if (iComponent instanceof UIComponent) {
            iComponent.setParent(null);
            if (((UIComponent)iComponent).isNotified()) {
                ((UIComponent)iComponent).removeNotify();
            }
        }
    }

    @Override
    public void remove(IComponent iComponent) {
        if (iComponent.getParent() == this) {
            this.remove(this.components.indexOf(iComponent));
        }
    }

    @Override
    public void removeAll() {
        while (this.components.size() > 0) {
            this.remove(this.components.size() - 1);
        }
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public IComponent getComponent(int n) {
        return this.components.get(n);
    }

    @Override
    public int indexOf(IComponent iComponent) {
        return this.components.indexOf(iComponent);
    }

    @Override
    public void updateTranslation() {
        super.updateTranslation();
        if (this.bAddNotify) {
            return;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent)) continue;
            ((UIComponent)iComponent).updateTranslation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeAddNotify(IComponent iComponent) {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.beforeAddNotify(iComponent);
        }
        finally {
            this.bAddNotify = false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent2 = this.components.get(i);
            if (!(iComponent2 instanceof UIComponent) || ((UIComponent)iComponent2).isBeforeNotified()) continue;
            ((UIComponent)iComponent2).beforeAddNotify(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        if (this.bAddNotify) {
            return;
        }
        this.bAddNotify = true;
        try {
            super.addNotify();
        }
        finally {
            this.bAddNotify = false;
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent) || ((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).addNotify();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            IComponent iComponent = this.components.get(i);
            if (!(iComponent instanceof UIComponent) || !((UIComponent)iComponent).isNotified()) continue;
            ((UIComponent)iComponent).removeNotify();
        }
    }

    public void addIntern(IComponent iComponent, Object object, int n) {
        IComponent iComponent2 = iComponent instanceof UIComponent ? (IComponent)((UIComponent)iComponent).getUIResource() : iComponent;
        if (iComponent.getParent() instanceof UIContainer) {
            ((UIContainer)iComponent.getParent()).remove(iComponent);
        } else if (iComponent.getParent() != null) {
            iComponent.getParent().remove(iComponent2);
        }
        Object object2 = object instanceof UIResource ? ((UIResource)object).getUIResource() : object;
        if (iComponent instanceof UIComponent && this.isNotified() && !((UIComponent)iComponent).isBeforeNotified()) {
            ((UIComponent)iComponent).beforeAddNotify(this);
        }
        if (n < 0) {
            this.components.add(iComponent);
        } else {
            this.components.add(n, iComponent);
        }
        IContainer iContainer = null;
        if (iComponent instanceof UIComponent) {
            iContainer = iComponent.getParent();
            iComponent.setParent(this);
        }
        try {
            ((IMenu)this.uiResource).add(iComponent2, object2, n);
        }
        catch (RuntimeException runtimeException) {
            this.components.remove(iComponent);
            if (iComponent instanceof UIComponent) {
                iComponent.setParent(iContainer);
            }
            throw runtimeException;
        }
        catch (Error error) {
            this.components.remove(iComponent);
            if (iComponent instanceof UIComponent) {
                iComponent.setParent(iContainer);
            }
            throw error;
        }
        if (iComponent instanceof UIComponent && this.isNotified() && !((UIComponent)iComponent).isNotified()) {
            ((UIComponent)iComponent).addNotify();
        }
    }
}

