/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.rad.io.IFileHandle;
import javax.rad.io.RemoteFileHandle;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;
import javax.rad.model.ui.ICellEditor;

public class BinaryDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = -2;
    private String encoding = null;

    public BinaryDataType() {
    }

    public BinaryDataType(int n) {
        this.setSize(n);
    }

    public BinaryDataType(ICellEditor iCellEditor) {
        this.setCellEditor(iCellEditor);
    }

    public BinaryDataType(int n, ICellEditor iCellEditor) {
        this.setSize(n);
        this.setCellEditor(iCellEditor);
    }

    public int getTypeIdentifier() {
        return -2;
    }

    public Class getTypeClass() {
        if (this.getCellEditor() != null || this.getCellRenderer() != null) {
            return Object.class;
        }
        return byte[].class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        int n;
        Object object2 = this.convertToTypeClass(object);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof byte[]) {
            n = ((byte[])object2).length;
        } else if (object2 instanceof IFileHandle) {
            try {
                n = (int)((IFileHandle)object2).getLength();
            }
            catch (Exception exception) {
                n = 0;
            }
        } else {
            throw new ModelException("Object type is not supported!");
        }
        if (n > this.getSize()) {
            throw new ModelException("Binary too large! - length from " + n + " to " + this.getSize());
        }
        return object2;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.encoding != null) {
                try {
                    return new String(byArray, this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return new String(byArray);
        }
        if (object instanceof IFileHandle) {
            try {
                byte[] byArray = FileUtil.getContent(((IFileHandle)object).getInputStream());
                if (this.encoding != null) {
                    try {
                        return new String(byArray, this.encoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                return new String(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return string.getBytes();
        }
        if (object instanceof IFileHandle) {
            return object;
        }
        if (object instanceof InputStream) {
            byte[] byArray = FileUtil.getContent((InputStream)object);
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        if (object instanceof InputStreamReader) {
            byte[] byArray = FileUtil.getContent((InputStreamReader)object);
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        try {
            IFileHandle iFileHandle = null;
            IFileHandle iFileHandle2 = null;
            if (object instanceof IFileHandle) {
                iFileHandle = (IFileHandle)object;
            }
            if (object2 instanceof IFileHandle) {
                iFileHandle2 = (IFileHandle)object2;
            }
            if (iFileHandle != null && iFileHandle2 != null && iFileHandle instanceof RemoteFileHandle && iFileHandle2 instanceof RemoteFileHandle && CommonUtil.equals(((RemoteFileHandle)iFileHandle).getObjectCacheKey(), ((RemoteFileHandle)iFileHandle2).getObjectCacheKey())) {
                return 0;
            }
            if (object != null && object2 != null) {
                int n;
                byte[] byArray;
                int n2;
                byte[] byArray2;
                if (iFileHandle == null) {
                    byArray2 = (byte[])object;
                    n2 = byArray2.length;
                } else {
                    byArray2 = null;
                    n2 = (int)iFileHandle.getLength();
                }
                if (iFileHandle2 == null) {
                    byArray = (byte[])this.convertToTypeClass(object2);
                    n = byArray.length;
                } else {
                    byArray = null;
                    n = (int)iFileHandle2.getLength();
                }
                if (n2 < n) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                if (iFileHandle != null) {
                    byArray2 = FileUtil.getContent(iFileHandle.getInputStream());
                }
                if (iFileHandle2 != null) {
                    byArray = FileUtil.getContent(iFileHandle2.getInputStream());
                }
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] < byArray[i]) {
                        return -1;
                    }
                    if (byArray2[i] <= byArray[i]) continue;
                    return 1;
                }
                return 0;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return super.compareTo(object, object2);
    }

    public BinaryDataType clone() {
        return (BinaryDataType)super.clone();
    }

    public Object prepareValue(Object object) throws ModelException {
        if (object instanceof IFileHandle && this.getCellEditor() != null) {
            IFileHandle iFileHandle = (IFileHandle)object;
            try {
                return FileUtil.getContent(iFileHandle.getInputStream());
            }
            catch (IOException iOException) {
                throw new ModelException(iOException);
            }
        }
        return object;
    }

    public static final byte[] getContent(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof IFileHandle) {
            return FileUtil.getContent(((IFileHandle)object).getInputStream());
        }
        if (object instanceof File) {
            return FileUtil.getContent((File)object);
        }
        if (object instanceof InputStream) {
            return FileUtil.getContent((InputStream)object);
        }
        if (object instanceof InputStreamReader) {
            return FileUtil.getContent((InputStreamReader)object);
        }
        throw new IOException(object.getClass() + " is a not supported binary object!");
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

