/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.persist;

import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.LongDataType;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.model.reference.StorageReferenceDefinition;

public class ColumnMetaData
implements Serializable,
Cloneable {
    private String sName;
    private String sLabel;
    private int iTypeIdentifier = 12;
    private boolean bNullable = true;
    private int iPrecision = Integer.MAX_VALUE;
    private int iScale = -1;
    private boolean bSigned = true;
    private boolean bWriteable = false;
    private boolean bCalculated = true;
    private boolean bAutoIncrement = false;
    private boolean bFetchLargeObjectsLazy = true;
    private Object oDefault;
    private Object[] oAllowedValues;
    private StorageReferenceDefinition srdLinkReference;
    protected IDataType cachedDataType = null;

    public ColumnMetaData() {
    }

    public ColumnMetaData(String string) {
        this.sName = string;
    }

    public ColumnMetaData(String string, int n) {
        this.sName = string;
        this.iTypeIdentifier = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnMetaData ::[");
        stringBuilder.append(this.sName);
        stringBuilder.append("],Type=");
        stringBuilder.append(this.iTypeIdentifier);
        stringBuilder.append(",Label=");
        stringBuilder.append(this.sLabel);
        stringBuilder.append(",Nullable=");
        stringBuilder.append(this.bNullable);
        stringBuilder.append(",Precision=");
        stringBuilder.append(this.iPrecision);
        stringBuilder.append(",Scale=");
        stringBuilder.append(this.iScale);
        stringBuilder.append(",Signed=");
        stringBuilder.append(this.bSigned);
        stringBuilder.append(",bWriteable=");
        stringBuilder.append(this.bWriteable);
        stringBuilder.append(",bCalculated=");
        stringBuilder.append(this.bCalculated);
        stringBuilder.append(",bFetchLargeObjectsLazy=");
        stringBuilder.append(this.bFetchLargeObjectsLazy);
        stringBuilder.append(",Default=");
        stringBuilder.append(this.oDefault);
        stringBuilder.append(",Allowed=");
        stringBuilder.append(StringUtil.toString(this.oAllowedValues));
        return stringBuilder.toString();
    }

    public ColumnMetaData clone() {
        try {
            ColumnMetaData columnMetaData = (ColumnMetaData)super.clone();
            if (this.oAllowedValues != null) {
                columnMetaData.oAllowedValues = (Object[])this.oAllowedValues.clone();
            }
            return columnMetaData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnMetaData columnMetaData = (ColumnMetaData)object;
        if (this.bAutoIncrement != columnMetaData.bAutoIncrement) {
            return false;
        }
        if (this.bNullable != columnMetaData.bNullable) {
            return false;
        }
        if (this.bSigned != columnMetaData.bSigned) {
            return false;
        }
        if (this.bWriteable != columnMetaData.bWriteable) {
            return false;
        }
        if (this.bCalculated != columnMetaData.bCalculated) {
            return false;
        }
        if (this.iTypeIdentifier != columnMetaData.iTypeIdentifier) {
            return false;
        }
        if (this.iPrecision != columnMetaData.iPrecision) {
            return false;
        }
        if (this.iScale != columnMetaData.iScale) {
            return false;
        }
        if (!Arrays.equals(this.oAllowedValues, columnMetaData.oAllowedValues)) {
            return false;
        }
        if (this.oDefault == null ? columnMetaData.oDefault != null : !this.oDefault.equals(columnMetaData.oDefault)) {
            return false;
        }
        if (this.sLabel == null ? columnMetaData.sLabel != null : !this.sLabel.equals(columnMetaData.sLabel)) {
            return false;
        }
        if (this.sName == null ? columnMetaData.sName != null : !this.sName.equals(columnMetaData.sName)) {
            return false;
        }
        return !(this.srdLinkReference == null ? columnMetaData.srdLinkReference != null : !this.srdLinkReference.equals(columnMetaData.srdLinkReference));
    }

    public int hashCode() {
        int n = 7 + (this.bAutoIncrement ? 1231 : 1237);
        n = 7 * n + (this.bNullable ? 1231 : 1237);
        n = 7 * n + (this.bSigned ? 1231 : 1237);
        n = 7 * n + (this.bWriteable ? 1231 : 1237);
        n = 7 * n + (this.bCalculated ? 1231 : 1237);
        n = 7 * n + (this.bFetchLargeObjectsLazy ? 1231 : 1237);
        n = 7 * n + this.iTypeIdentifier;
        n = 7 * n + this.iPrecision;
        n = 7 * n + this.iScale;
        n = 7 * n + Arrays.hashCode(this.oAllowedValues);
        n = 7 * n + (this.oDefault == null ? 0 : this.oDefault.hashCode());
        n = 7 * n + (this.sLabel == null ? 0 : this.sLabel.hashCode());
        n = 7 * n + (this.sName == null ? 0 : this.sName.hashCode());
        n = 7 * n + (this.srdLinkReference == null ? 0 : this.srdLinkReference.hashCode());
        return n;
    }

    public void setName(String string) {
        this.sName = string;
    }

    public String getName() {
        return this.sName;
    }

    public String getLabel() {
        if (this.sLabel == null) {
            return ColumnMetaData.getDefaultLabel(this.sName);
        }
        return this.sLabel;
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public boolean isFetchLargeObjectsLazy() {
        return this.bFetchLargeObjectsLazy;
    }

    public void setFetchLargeObjectsLazy(boolean bl) {
        this.bFetchLargeObjectsLazy = bl;
    }

    public void setTypeIdentifier(int n) {
        this.iTypeIdentifier = n;
        this.cachedDataType = null;
    }

    public int getTypeIdentifier() {
        return this.iTypeIdentifier;
    }

    public void setNullable(boolean bl) {
        this.bNullable = bl;
    }

    public boolean isNullable() {
        return this.bNullable;
    }

    public int getPrecision() {
        return this.iPrecision;
    }

    public void setPrecision(int n) {
        this.iPrecision = n;
        this.cachedDataType = null;
    }

    public int getScale() {
        return this.iScale;
    }

    public void setScale(int n) {
        this.iScale = n;
        this.cachedDataType = null;
    }

    public void setWritable(boolean bl) {
        this.bWriteable = bl;
    }

    public boolean isWritable() {
        return this.bWriteable;
    }

    public void setCalculated(boolean bl) {
        this.bCalculated = bl;
    }

    public boolean isCalculated() {
        return this.bCalculated;
    }

    public boolean isSigned() {
        return this.bSigned;
    }

    public void setSigned(boolean bl) {
        this.bSigned = bl;
        this.cachedDataType = null;
    }

    public boolean isAutoIncrement() {
        return this.bAutoIncrement;
    }

    public void setAutoIncrement(boolean bl) {
        this.bAutoIncrement = bl;
    }

    public StorageReferenceDefinition getLinkReference() {
        return this.srdLinkReference;
    }

    public void setLinkReference(StorageReferenceDefinition storageReferenceDefinition) {
        this.srdLinkReference = storageReferenceDefinition;
    }

    public ColumnDefinition createColumnDefinition() throws ModelException {
        return this.initializeColumnDefinition(new ColumnDefinition());
    }

    protected ColumnDefinition initializeColumnDefinition(ColumnDefinition columnDefinition) throws ModelException {
        columnDefinition.setName(this.getName());
        columnDefinition.setWritable(this.isWritable());
        columnDefinition.setNullable(this.isNullable());
        columnDefinition.setLabel(this.getLabel());
        columnDefinition.setDefaultValue(this.getDefaultValue());
        columnDefinition.setAllowedValues(this.getAllowedValues());
        columnDefinition.setDataType(this.createDataType());
        return columnDefinition;
    }

    public IDataType getDataType() {
        if (this.cachedDataType == null) {
            this.cachedDataType = this.createDataType();
        }
        return this.cachedDataType;
    }

    public IDataType createDataType() {
        switch (this.getTypeIdentifier()) {
            case 12: {
                StringDataType stringDataType = new StringDataType();
                stringDataType.setSize(this.getPrecision());
                stringDataType.setAutoTrimEnd(stringDataType.getSize() > 2);
                return stringDataType;
            }
            case 16: {
                return new BooleanDataType();
            }
            case 3: {
                BigDecimalDataType bigDecimalDataType = new BigDecimalDataType();
                bigDecimalDataType.setPrecision(this.getPrecision());
                bigDecimalDataType.setScale(this.getScale());
                bigDecimalDataType.setSigned(this.isSigned());
                return bigDecimalDataType;
            }
            case -5: {
                LongDataType longDataType = new LongDataType();
                longDataType.setSigned(this.isSigned());
                return longDataType;
            }
            case 93: {
                return new TimestampDataType();
            }
            case -2: {
                BinaryDataType binaryDataType = new BinaryDataType();
                binaryDataType.setSize(this.getPrecision());
                return binaryDataType;
            }
            case 2000: {
                return new ObjectDataType();
            }
        }
        throw new IllegalArgumentException("Type identifier " + this.getTypeIdentifier() + " is not supported!");
    }

    public static String getDefaultLabel(String string) {
        return StringUtil.formatInitCap(string);
    }

    public void setDefaultValue(Object object) {
        this.oDefault = object;
    }

    public Object getDefaultValue() {
        return this.oDefault;
    }

    public void setAllowedValues(Object[] objectArray) {
        this.oAllowedValues = objectArray;
    }

    public Object[] getAllowedValues() {
        return this.oAllowedValues;
    }
}

