/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.persist;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.persist.ColumnMetaData;

public class MetaData
implements Serializable {
    private ArrayUtil<ColumnMetaData> auColumnMetaData = new ArrayUtil();
    private Map<String, Integer> hmColumnMetaDataMap = null;
    private String[] saPrimaryKeyColumnNames;
    private String[] saRepresentationColumnNames;
    private String[] saAutoIncrementColumnNames;
    private Feature[] faFeatures = new Feature[]{Feature.Sort, Feature.Filter, Feature.WriteBack};
    private transient String[] saColumnNames;
    private String[] saVisibleColumnNames;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnMetaData :: ");
        stringBuilder.append(this.auColumnMetaData.toString());
        if (this.saPrimaryKeyColumnNames != null) {
            stringBuilder.append("PrimaryKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saPrimaryKeyColumnNames));
        }
        if (this.saRepresentationColumnNames != null) {
            stringBuilder.append("UniqueKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saRepresentationColumnNames));
        }
        if (this.saAutoIncrementColumnNames != null) {
            stringBuilder.append("AutoIncrementKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saAutoIncrementColumnNames));
        }
        if (this.saVisibleColumnNames != null) {
            stringBuilder.append("VisibleColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saVisibleColumnNames));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 31 + (this.auColumnMetaData == null ? 0 : this.auColumnMetaData.hashCode());
        n = 31 * n + Arrays.hashCode((Object[])this.faFeatures);
        n = 31 * n + Arrays.hashCode(this.saAutoIncrementColumnNames);
        n = 31 * n + Arrays.hashCode(this.saPrimaryKeyColumnNames);
        n = 31 * n + Arrays.hashCode(this.saRepresentationColumnNames);
        n = 31 * n + Arrays.hashCode(this.saVisibleColumnNames);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)object;
        if (this.auColumnMetaData == null ? metaData.auColumnMetaData != null : !this.auColumnMetaData.equals(metaData.auColumnMetaData)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.faFeatures, (Object[])metaData.faFeatures)) {
            return false;
        }
        if (!Arrays.equals(this.saAutoIncrementColumnNames, metaData.saAutoIncrementColumnNames)) {
            return false;
        }
        if (!Arrays.equals(this.saPrimaryKeyColumnNames, metaData.saPrimaryKeyColumnNames)) {
            return false;
        }
        if (!Arrays.equals(this.saRepresentationColumnNames, metaData.saRepresentationColumnNames)) {
            return false;
        }
        return Arrays.equals(this.saVisibleColumnNames, metaData.saVisibleColumnNames);
    }

    public void addColumnMetaData(ColumnMetaData columnMetaData) {
        this.auColumnMetaData.add(columnMetaData);
        this.saColumnNames = null;
        this.hmColumnMetaDataMap = null;
    }

    public ColumnMetaData[] getColumnMetaData() {
        return this.auColumnMetaData.toArray(new ColumnMetaData[this.auColumnMetaData.size()]);
    }

    public void setColumnMetaData(ColumnMetaData[] columnMetaDataArray) {
        if (columnMetaDataArray != null && columnMetaDataArray.length > 0) {
            for (int i = 0; i < columnMetaDataArray.length; ++i) {
                ColumnMetaData columnMetaData = columnMetaDataArray[i];
                int n = this.getColumnMetaDataIndex(columnMetaData.getName());
                if (n < 0) {
                    this.auColumnMetaData.add(columnMetaData);
                    continue;
                }
                this.auColumnMetaData.set(n, columnMetaData);
            }
            this.saColumnNames = null;
            this.hmColumnMetaDataMap = null;
        }
    }

    public ColumnMetaData getColumnMetaData(String string) throws ModelException {
        int n = this.getColumnMetaDataIndex(string);
        if (n >= 0) {
            return this.auColumnMetaData.get(n);
        }
        throw new ModelException("Column '" + string + "' doesn't exists in MetaData!");
    }

    public ColumnMetaData getColumnMetaData(int n) {
        return this.auColumnMetaData.get(n);
    }

    public int getColumnMetaDataCount() {
        return this.auColumnMetaData.size();
    }

    public int getColumnMetaDataIndex(String string) {
        Integer n;
        if (this.hmColumnMetaDataMap == null) {
            this.hmColumnMetaDataMap = new HashMap<String, Integer>();
            int n2 = this.auColumnMetaData.size();
            for (int i = 0; i < n2; ++i) {
                this.hmColumnMetaDataMap.put(this.auColumnMetaData.get(i).getName(), i);
            }
        }
        if ((n = this.hmColumnMetaDataMap.get(string)) == null) {
            return -1;
        }
        return n;
    }

    public String[] getPrimaryKeyColumnNames() {
        return this.saPrimaryKeyColumnNames;
    }

    public void setPrimaryKeyColumnNames(String[] stringArray) {
        this.saPrimaryKeyColumnNames = stringArray;
    }

    public String[] getRepresentationColumnNames() {
        return this.saRepresentationColumnNames;
    }

    public void setRepresentationColumnNames(String[] stringArray) {
        this.saRepresentationColumnNames = stringArray;
    }

    public String[] getVisibleColumnNames() {
        return this.saVisibleColumnNames;
    }

    public void setVisibleColumnNames(String[] stringArray) {
        this.saVisibleColumnNames = stringArray;
    }

    public String[] getAutoIncrementColumnNames() {
        return this.saAutoIncrementColumnNames;
    }

    public void setAutoIncrementColumnNames(String[] stringArray) {
        this.saAutoIncrementColumnNames = stringArray;
    }

    public void setFeatures(Feature ... featureArray) {
        this.faFeatures = featureArray == null ? new Feature[0] : featureArray;
    }

    public void addFeature(Feature feature) {
        if (!ArrayUtil.contains(this.faFeatures, feature)) {
            this.faFeatures = ArrayUtil.add(this.faFeatures, feature);
        }
    }

    public void removeFeature(Feature feature) {
        this.faFeatures = ArrayUtil.remove(this.faFeatures, feature);
    }

    public Feature[] getFeatures() {
        return this.faFeatures;
    }

    public boolean isSupported(Feature feature) {
        return ArrayUtil.contains(this.faFeatures, feature);
    }

    public String[] getColumnNames() {
        if (this.saColumnNames == null) {
            this.saColumnNames = new String[this.auColumnMetaData.size()];
            for (int i = 0; i < this.saColumnNames.length; ++i) {
                this.saColumnNames[i] = this.auColumnMetaData.get(i).getName();
            }
        }
        return this.saColumnNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        Sort,
        Filter,
        WriteBack;

    }
}

