/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javax.rad.genui.UIFactoryManager;
import javax.rad.ui.IFactory;
import javax.rad.util.SilentAbortException;
import javax.rad.util.event.IExceptionListener;

public final class ExceptionHandler {
    private static WeakHashMap<IFactory, List<WeakReference<IExceptionListener>>> factoryListeners = new WeakHashMap();

    private ExceptionHandler() {
    }

    public static void raise(Throwable throwable) {
        if (throwable instanceof SilentAbortException) {
            throw (SilentAbortException)throwable;
        }
        ExceptionHandler.fireHandleException(throwable);
        throw new SilentAbortException(throwable);
    }

    public static void show(Throwable throwable) {
        if (!(throwable instanceof SilentAbortException)) {
            ExceptionHandler.fireHandleException(throwable);
        }
    }

    public static void addExceptionListener(IExceptionListener iExceptionListener) {
        ExceptionHandler.addExceptionListener(iExceptionListener, -1);
    }

    public static void addExceptionListener(IExceptionListener iExceptionListener, int n) {
        IFactory iFactory = UIFactoryManager.getFactory();
        List<WeakReference<IExceptionListener>> list = factoryListeners.get(iFactory);
        if (list == null) {
            list = new ArrayUtil<WeakReference<IExceptionListener>>();
            factoryListeners.put(iFactory, list);
        }
        if (!list.contains(iExceptionListener)) {
            if (n < 0) {
                list.add(new WeakReference<IExceptionListener>(iExceptionListener));
            } else {
                list.add(n, new WeakReference<IExceptionListener>(iExceptionListener));
            }
        }
    }

    public static void removeExceptionListener(IExceptionListener iExceptionListener) {
        IFactory iFactory = UIFactoryManager.getFactory();
        List<WeakReference<IExceptionListener>> list = factoryListeners.get(iFactory);
        if (list != null) {
            list.remove(iExceptionListener);
            if (list.isEmpty()) {
                factoryListeners.remove(iFactory);
            }
        }
    }

    public static IExceptionListener[] getListeners() {
        IFactory iFactory = UIFactoryManager.getFactory();
        List<WeakReference<IExceptionListener>> list = factoryListeners.get(iFactory);
        if (list != null) {
            ArrayUtil<IExceptionListener> arrayUtil = new ArrayUtil<IExceptionListener>();
            for (int i = 0; i < list.size(); ++i) {
                IExceptionListener iExceptionListener = (IExceptionListener)list.get(i).get();
                if (iExceptionListener == null) continue;
                arrayUtil.add(iExceptionListener);
            }
            return arrayUtil.toArray(new IExceptionListener[arrayUtil.size()]);
        }
        return new IExceptionListener[0];
    }

    private static void fireHandleException(Throwable throwable) {
        IFactory iFactory = UIFactoryManager.getFactory();
        List<WeakReference<IExceptionListener>> list = factoryListeners.get(iFactory);
        if (list != null && !list.isEmpty()) {
            list = new ArrayUtil<WeakReference<IExceptionListener>>((Collection<WeakReference<IExceptionListener>>)list);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                IExceptionListener iExceptionListener = (IExceptionListener)list.get(i).get();
                if (iExceptionListener == null) continue;
                iExceptionListener.handleException(throwable);
            }
        } else {
            LoggerFactory.getInstance(ExceptionHandler.class).error(throwable);
        }
    }
}

