unit JyDiskInfoDll;

interface
uses Windows, SysUtils, Classes;
{$IFDEF CPUX64}
const dllname = 'JyDisk64.dll';
{$else}
const dllname = 'JyDisk.dll';
{$endif}
type
  {$Z4+} //ö4ֽڶ vcһ//hsj 2017-09-21
  HOST_READS_WRITES_UNIT =
    (
    HOST_READS_WRITES_UNKNOWN = 0,
    HOST_READS_WRITES_512B,
    HOST_READS_WRITES_32MB,
    HOST_READS_WRITES_GB);
  INTERFACE_TYPE = (
    INTERFACE_TYPE_UNKNOWN = 0,
    INTERFACE_TYPE_PATA,
    INTERFACE_TYPE_SATA,
    INTERFACE_TYPE_USB,
    INTERFACE_TYPE_IEEE1394,
    INTERFACE_TYPE_UASP,
    INTERFACE_TYPE_SCSI,
    INTERFACE_TYPE_NVME);
  VENDOR_ID =
    (
    HDD_GENERAL = 0,
    SSD_GENERAL = 1,
    SSD_VENDOR_MTRON = 2,
    SSD_VENDOR_INDILINX = 3,
    SSD_VENDOR_JMICRON = 4,
    SSD_VENDOR_INTEL = 5,
    SSD_VENDOR_SAMSUNG = 6,
    SSD_VENDOR_SANDFORCE = 7,
    SSD_VENDOR_MICRON = 8,
    SSD_VENDOR_OCZ = 9,
    HDD_SSD_VENDOR_SEAGATE = 10,
    HDD_VENDOR_WESTERN_DIGITAL = 11,
    SSD_VENDOR_PLEXTOR = 12,
    SSD_VENDOR_SANDISK = 13,
    SSD_VENDOR_OCZ_VECTOR = 14,
    HDD_SSD_VENDOR_TOSHIBA = 15,
    SSD_VENDOR_CORSAIR = 16,
    SSD_VENDOR_KINGSTON = 17,
    SSD_VENDOR_MICRON_MU02 = 18,
    SSD_VENDOR_NVME = 19,
    SSD_VENDOR_MAX = 99,

    VENDOR_UNKNOWN = $0000,
    USB_VENDOR_BUFFALO = $0411,
    USB_VENDOR_IO_DATA = $04BB,
    USB_VENDOR_LOGITEC = $0789,
    USB_VENDOR_INITIO = $13FD,
    USB_VENDOR_SUNPLUS = $04FC,
    USB_VENDOR_JMICRON = $152D,
    USB_VENDOR_CYPRESS = $04B4,
    USB_VENDOR_OXFORD = $0928,
    USB_VENDOR_PROLIFIC = $067B,
    USB_VENDOR_ALL = $FFFF);
   
  byteArr6 = array[0..5] of Byte;
  JyHDiskInfo = record
    IsSmartSupported: Boolean; //ȡsmartǷɹ
    IsApmSupported: Boolean;
    IsApmEnabled: Boolean;
    IsAamSupported: Boolean;
    IsAamEnabled: Boolean;
    IsLba48Supported: Boolean;
    IsNcqSupported: Boolean;
    IsNvCacheSupported: Boolean;
    IsTrimSupported: Boolean;
    IsSsd: Boolean;
    IsDeviceSleepSupported: Boolean;
    IsMaxtorMinute: Boolean;
    IsRawValues8: Boolean;
    IsRawValues7: Boolean;
    DetectedTimeUnitType: Cardinal;

    ModelNumber: array[0..39] of ansichar; //Ӳ
    FirmwareRev: array[0..7] of ansichar; //̼汾
    SerialNumber: array[0..19] of ansichar; //к

    //bVersion: Byte; // Binary driver version.
    //bRevision: Byte; // Binary driver revision.
    //fCapabilities: DWORD;
    Cylinders: int64;
    Heads: DWORD;
    BytesPerSector: DWORD;
    SectorsPerTrack: dWORD;
    TracksPerCylinder: DWORD;
    disksize: int64;
    Temperature: Integer; //¶
    PowerOnTime: Integer; //ͨʱ
    PowerOnCount: Integer; //ͨ
    RotationRate: Word; //ת
    BufferSize: dWord; //С
    HostWrites: Int64; //дܼ-
    HostReads: Int64; //ȡܼ-
    CurrentTransferMode: array[0..255] of ansichar; // ShortString;
    MaxTransferMode: array[0..255] of ansichar; // ShortString;
    Interface_: array[0..255] of ansichar; // ShortString;

    TransferModeType: DWORD;
    Major: Cardinal;
    Life: Int64;
    MajorVersion: array[0..255] of ansichar; // ShortString;
    MinorVersion: array[0..255] of ansichar; // ShortString;
    SmartKeyName: array[0..255] of ansichar; // ShortString;
    SsdVendorString: array[0..255] of ansichar; // ShortString;
    SmartCount: integer;
    ItemId: array[0..29] of Byte;
    CurrentValue: array[0..29] of Byte;
    WorstValue: array[0..29] of Byte;
    ThresholdValue: array[0..29] of Byte;
    DataValue: array[0..29] of int64;
    DataValueArr: array[0..29] of byteArr6;
    State: array[0..29] of byte;
    StatusFlags: array[0..29] of byte;
    InterfaceType: INTERFACE_TYPE;
    HostReadsWritesUnit: HOST_READS_WRITES_UNIT;

    DiskVendorId: VENDOR_ID;
    //IdOutCmd: array[1..sizeof(SENDCMDOUTPARAMS) + IDENTIFY_BUFFER_SIZE - 1] of Byte;
    //AttrOutCmd: array[1..sizeof(SENDCMDOUTPARAMS) + READ_ATTRIBUTE_BUFFER_SIZE - 1] of Byte;
    //ThreshOutCmd: array[1..sizeof(SENDCMDOUTPARAMS) + READ_THRESHOLD_BUFFER_SIZE - 1] of Byte;
  end;
procedure FreeJyDiskDll; //ͷŶ̬
procedure InitJyDiskDll(); //̬ʼ
procedure DoReg(User, regid: ansistring); //עؼ
function IsRegisted(): Boolean; //жϿؼǷɹע
//adminû
function RunAsAdmin: boolean;
//ô
function GetDiskIndex(drive: ansiChar): Integer;
function GetDiskSerialNumber(drive: ansiChar;PNPDeviceID:Bool=false): ansistring; overload;
function GetDiskSerialNumber(index: integer;PNPDeviceID:Bool=false): ansistring; overload;
//0--Ӳ̣1--ƶӲ̣2--u
function GetDiskTypeStr(itype: integer): widestring;
function GetDiskType(drive: ansiChar): Integer; overload;
function GetDiskType(i: integer): Integer; overload;
//豸

function GetPhysicalDriveCount(st: tstrings): Integer;
//̶Ӧķ̷

function GetDiskDrive(PhysicalDriveId: integer): string;
//õǰõ̷

function GetDriverList: string;
//豸,豸Ŵ0ʼ0Ϊ1

function GetPhysicalDrivePartitionCount(PhysicalDriveId: Integer): integer;
//Ӳ̷,0ʼ,-1ΪӲ
function GetHardDiskPartitionInfo(const DriveLetter: ansiChar;
  var VolumeName, VolumeSerialNumber, PartitionType: ansistring;
  var TotalSpace, TotalFreeSpace: int64): boolean;
//Ӳ̷,1ʼ,0ΪӲ
function GetDiskPartitionIndex(drive: ansiChar): Integer;
//smartϢ
function GetDiskInfo(index: integer; var ainfo: JyHDiskInfo): boolean;
//smartϢĿӦ

function GetSmartItemAttribName(const anId: Integer): string;
//0δ֪,1,2쳣,3

function getStateStr(i: Integer): string;

function JyStringLink(s1, s2: string; fgf: string = ' '): string;

function GetMd5String(ins: ansistring): ansistring;
function GetCpuID(): string;
function GetBiosID(): string;
function GetDisplayDeviceID():string;
function GetIP():string;
function GetMacAddr():string;
function IsWin64: boolean;
//ʼ
procedure Init;

function getUsbPNPDeviceID(drive: ansichar): ansistring;overload;
function getUsbPNPDeviceID(index: integer): ansistring;overload;
//ô
function GetDiskSize(index: Integer = 0): Int64; overload;
function GetDiskSize(drv: AnsiChar): Int64; overload;

function GetDiskName(index:integer):Ansistring;overload;
function GetDiskName(drive:AnsiChar):Ansistring;overload;
implementation
//{$DEFINE for_vb}
var hdll: NativeUInt = 0;
var getDiskSerialNumber_1: procedure(drive: ansiChar;  pout: PAnsiChar; var poutsize: integer;PNPDeviceID:bool=false); stdcall; //{$IFDEF for_vb}var{$ENDIF}pout: PAnsiChar;
  getDiskSerialNumber_2: procedure(index: integer;  pout: PAnsiChar; var poutsize: integer;PNPDeviceID:bool=false); stdcall; //{$IFDEF for_vb}var{$ENDIF}pout
  getDiskType_1: function(drive: ansiChar): Integer; stdcall;
  getDiskType_2: function(i: Integer): Integer; stdcall;
  getDiskIndex_: function(drive: ansiChar): Integer; stdcall;
  doReg_: procedure(fuser: PansiChar; usersize: integer; fregid: PansiChar; regidsize: integer); stdcall;
  isRegisted_: function(): bool; stdcall;
  getDiskTypeStr_: procedure(i: integer;  pout: PwideChar; var poutsize: integer); stdcall; //{$IFDEF for_vb}var{$ENDIF}pout
  getPhysicalDriveCount_: function(pout: PAnsiChar; var poutsize: integer): Integer; stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  runAsAdmin_: function(): bool; stdcall;
  getDiskDrive_: procedure(PhysicalDriveId: integer;  pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getDriverList_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall; //{$IFDEF for_vb}var{$ENDIF}pout
  getPhysicalDrivePartitionCount_: function(PhysicalDriveId: Integer): integer; stdcall;
  getDiskPartitionIndex_: function(drive: ansiChar): Integer; stdcall;
  getHardDiskPartitionInfo_: function(const DriveLetter: ansiChar;
    VolumeName: PAnsiChar; var VolumeNameSize: Integer;//{$IFDEF for_vb}var{$ENDIF}VolumeName
    VolumeSerialNumber: PAnsiChar; var VolumeSerialNumberSize: Integer;//{$IFDEF for_vb}var{$ENDIF}VolumeSerialNumber
    PartitionType: PAnsiChar;//{$IFDEF for_vb}var{$ENDIF}PartitionType
    var PartitionTypeSize: Integer; var TotalSpace, TotalFreeSpace: int64): bool; stdcall;
  getDiskInfo_: function(index: integer; var ainfo: JyHDiskInfo): bool; stdcall;
  getMd5String_: procedure(pin: pansichar; pinsize: integer; pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getCpuID_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getBiosID_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getDisplayDeviceID_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getIP_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  getMacAddr_: procedure(pout: PAnsiChar; var poutsize: integer); stdcall;//{$IFDEF for_vb}var{$ENDIF}pout
  isWin64_: function(): bool; stdcall;
  init_: procedure(); stdcall;
  getUsbPNPDeviceID_1:procedure(d: ansichar;pout: PAnsiChar; var poutsize: integer);stdcall;
  getUsbPNPDeviceID_2:procedure(index: integer;pout: PAnsiChar; var poutsize: integer);stdcall;
  getDiskSize_1:function(d: ansichar):int64;stdcall;
  getDiskSize_2:function(index: integer):int64;stdcall;
  getDiskName_1:procedure(d: ansichar;pout: PAnsiChar; var poutsize: integer);stdcall;
  getDiskName_2:procedure(index: integer;pout: PAnsiChar; var poutsize: integer);stdcall;
procedure Init();
begin
  Init_();
end;
//עؼ

procedure DoReg(User, regid: ansistring);
begin
  DoReg_(@User[1], Length(User), @regid[1], Length(regid));
end;
//жϿؼǷɹע

function IsRegisted(): Boolean;
begin
  result := IsRegisted_();
end;
//0δ֪,1,2쳣,3

function getStateStr(i: Integer): string;
begin
  case i of
    1: result := '';
    2: result := '쳣';
    3: result := '';
  else
    result := '';
  end;
end;
//smartϢĿӦ

function GetSmartItemAttribName(const anId: Integer): string;
{begin
  case anId of     //ò׼ȷҲ
      0: Result := 'No Attribute Here       ';
      1: Result := 'ݶȡ';
      2: Result := '';
      3: Result := 'ʱ';
      4: Result := '/ֹͣ';
      5: Result := 'ضλ';
      6: Result := 'Read Channel Margin';
      7: Result := 'Ѱ';
      8: Result := 'Ѱʱ';
      9: Result := 'ϵʱ';
     10: Result := 'Դ';
     11: Result := 'УԴ ';
     12: Result := 'Դش';
     13, 201: Result := 'ȡ';
    192,225: Result := 'Դرմ';
    193: Result := 'ͷλ';
    194, 231: Result := '¶';
    195: Result := 'ӲECCָ';
    196: Result := 'ضλ¼';
    197: Result := 'ǰȴ';
    198: Result := '޷';
    199: Result := 'UDMA CRC ';
    200: Result := 'дݴ';
    202: Result := 'DAM';
    206: Result := 'ͷ߶';
    240: Result := 'ͷʱ';
    else
      Result := 'δ֪';
 end;
{
0 00h Invalid Invalid attribute identifier
1 01h ݶȡ   Ӵ̶ȡԭʼݵĳƵ
2 02h  ƽдЧ
3 03h ʱ תʱ
4 04h Start/Stop count Number of spindle start/stop cycles
5 05h Reallocated sector count Quantity of remapped sectors
6 06h Read channel margin Reserve of channel while reading
7 07h Seek error rate Frequency of errors while positioning
8 08h Seek timer performance Average efficiency of operations while  positioning
9 09h Power-on hours count Number of hours elapsed in the power-on state
10 0Ah Spinup retry count Number of retry attempts to spin up
11 0Bh Calibration retry count Number of attempts to calibrate the device
12 0Ch Power cycle count Number of power-on events
13 0Dh Soft read error rate Frequency of program errors while reading
from a disk
187 BBh vendor-specific vendor-specific
189 BDh vendor-specific vendor-specific
190 BEh vendor-specific vendor-specific
191 BFh G-sense error rate Fequency of mistakes as a result of impact
loads
192 C0h Power-off retract count         Number of power-off or emergency retract cycles
193 C1h Load/Unload cycle count         Number of cycles into landing zone position
194 C2h HDA temperature                 Temperature of a hard disk assembly
195 C3h Hardware ECC recovered Number of ECC on-the-fly errors
196 C4h Reallocation count Number of remapping operations
197 C5h Current pending sector count   Number of unstable sectors (waiting for
remapping)
198 C6h Offline scan uncorrectable count   Number of uncorrected errors
199 C7h UDMA CRC error rate Number of CRC errors during UDMA mode
200 C8h Write error rate Number of errors while writing to disk (or)
multi-zone error rate (or)
flying height
201 C9h Soft read error rate Number of off-track errors
202 Cah Data Address Mark errors Number of Data Address Mark (DAM) errors
(or) vendor-specific
203 CBh Run out cancel Number of ECC errors
204 CCh Soft ECC correction Number of errors corrected by software ECC
205 CDh Thermal asperity rate
(TAR)
Number of thermal asperity errors
206 CEh Flying height Height of heads above the disk surface
207 CFh Spin high current Amount of high current used to spin up the
drive
208 D0h Spin buzz Number of buzz routines to spin up the drive
209 D1h Offline seek performance Drives seek performance during offline
operations
220 DCh Disk shift            Shift of disk is possible as a result of strong
shock loading in the store, as a result of falling
(or) temperature
221 DDh G-sense error rate Number of errors as a result of impact loads
as detected by a shock sensor
222 DEh Loaded hours Number of hours in general operational state
223 DFh Load/unload retry count Loading on drive caused by numerous
recurrences of operations, like reading,
recording, positioning of heads, etc.
224 E0h Load friction Load on drive caused by friction in mechanical
parts of the store
225 E1h Load/Unload cycle count Total number of load cycles
226 E2h Load-in time General time for loading in a drive
227 E3h Torque amplification count Quantity efforts of the rotating moment of a
drive
228 E4h Power-off retract count Number of power-off retract events.
230 E6h GMR head amplitude Amplitude of heads trembling (GMR-head) in
running mode
231 E7h Temperature Temperature of a drive
240 F0h Head flying hours Time while head is positioning
250 FAh Read error retry rate Number of errors while reading from a disk

}
//function GetSmartCodeName(): string;
var code: string;
begin
  result := 'δ֪'; //ؿվǲĵĲ,ɲ
  code := IntToHex(anId, 2);
  if code = '01' then result := '(ײ)ݶȡ';
  if code = '02' then result := '(дͨ)'; //ֵԽԽ
  if code = '03' then result := 'ת׼תʱ';
  if code = '04' then result := '/ֹͣת';
  if code = '05' then result := 'ӳ';
  if code = '06' then result := 'ȡ߽ͨ'; //һܲڵӲҲʾһ
  if code = '07' then result := 'Ѱ';
  if code = '08' then result := 'Ѱʱ';
  if code = '09' then result := 'ۼͨʱ';
  if code = '0A' then result := 'Լ';
  if code = '0B' then result := 'У׼Լ';
  if code = '0C' then result := 'ͨڼ';
  if code = '0D' then result := '';
  if code = 'AA' then result := 'дʧܵĿ';
  if code = 'AB' then result := 'Flashʧܿ';
  if code = 'AC' then result := 'дʧܿ';
  if code = 'AD' then result := 'кÿƽд';
  if code = 'AE' then result := 'Ӳúϵ¼Ĵ';
  if code = 'B1' then result := 'ĥصĿĥĿĥٷֱ֮';
  if code = 'B3' then result := 'ʹõı(ܼ)';
  if code = 'B4' then result := 'δʹõԤĴ洢Ԫ';
  if code = 'B5' then result := 'ѱʧܵĴ루AB';
  if code = 'B5' then result := '4KB';
  if code = 'B6' then result := 'ӲúдʧܵĴ루AC';
  if code = 'B7' then result := 'SATA';
  if code = 'B8' then result := '˵˴';
  if code = 'B9' then result := 'ͷȶ'; //岻
  if code = 'BA' then result := 'Ӧ񶯼';
  if code = 'BB' then result := '޷УĴ';
  if code = 'BC' then result := 'ָʱ';
  if code = 'BD' then result := 'ͳдʱͷи߶ȳƫĴ/';
  //if code = 'BD' then result := '';
  if code = 'BE' then result := 'ӲڲƬ¶';
  if code = 'BF' then result := 'Ӳܵе³Ƶ';
  if code = 'C0' then result := 'ϵͷؼ';
  if code = 'C1' then result := 'ͷִм/жزۼƴ';
  if code = 'C2' then result := 'Ӳڲĵǰ¶';
  if code = 'C3' then result := 'ͷƬ϶дʱͨECCУĴ';
  if code = 'C4' then result := '·¼';
  if code = 'C5' then result := 'Ŀǰӳ';
  if code = 'C6' then result := '޷У';
  if code = 'C7' then result := 'Ultra DMA CRC ';
  if code = 'C8' then result := '';
  if code = 'C9' then result := '';
  if code = 'CA' then result := 'ݵַǴ';
  if code = 'CB' then result := ';ECCƵ';
  if code = 'CC' then result := 'ͨECCļ';
  if code = 'CD' then result := 'ɳµµĴ';
  if code = 'CE' then result := 'ͷƬĴֱ';
  if code = 'CF' then result := 'ʱӿĴ';
  if code = 'D0' then result := 'Լ';
  if code = 'D1' then result := 'Ѱ';
  if code = 'D2' then result := 'ֵͨΪ0岻';
  if code = 'D3' then result := 'дʱܵܵⲿ񶯵ļ¼';
  if code = 'D4' then result := 'дʱܵܵⲿеļ¼';
  if code = 'DC' then result := 'ӲеƬƫ';
  if code = 'DD' then result := '';
  if code = 'DE' then result := 'ҵʱ';
  if code = 'DF' then result := 'ͷԴ';
  if code = 'E0' then result := 'Ħ';
  if code = 'E1' then result := 'ͷڼ';
  if code = 'E2' then result := 'ʱ';
  if code = 'E3' then result := 'ŤطŴ';
  if code = 'E4' then result := 'ϵͷ';
  if code = 'E6' then result := '޴ŵͷ';
  if code = 'E7' then result := '¶';
  if code = 'E8' then result := 'ӲѲдɲдİٷֱ';
  if code = 'E9' then result := 'ӵʱ/ʺָ'; //ͨӲ˵һ루09ͬ
  if code = 'EB' then result := 'ȫرռ';
  if code = 'F0' then result := 'ͷλڹλõʱ';
  if code = 'F1' then result := 'LBAдۼ';
  if code = 'F2' then result := 'LBAȡۼ';
  if code = 'FA' then result := 'Ӵ϶ȡʱĴ';

  if code = 'FE' then result := '׹䱣װöĴ';

end;
//adminû

function RunAsAdmin: boolean;
begin
  Result := RunAsAdmin_();
end;
function IsWin64: boolean;
begin
  Result := IsWin64_();
end;
//0--Ӳ̣1--ƶӲ̣2--u

function GetDiskTypeStr(itype: integer): widestring;
var i, sz: Integer;
  p: pwideChar;
begin
  result := '';
  getmem(p, 255);
  try
    GetDiskTypeStr_(itype, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;

function GetDiskType(drive: ansiChar): Integer;
begin
  result := GetDiskType_1(drive);
end;

function GetDiskType(i: integer): Integer;
begin
  result := GetDiskType_2(i);
end;
//Ӳ̷,1ʼ,0ΪӲ

function GetDiskPartitionIndex(drive: ansiChar): Integer;
begin
  result := GetDiskPartitionIndex_(drive);
end;
//豸

function GetPhysicalDriveCount(st: tstrings): Integer;
var sz, i: Integer;
  p: pansiChar;
  s: string;
begin
  getmem(p, 512);
  try
    result := GetPhysicalDriveCount_(p, sz);
    s := '';
    for i := 1 to sz do
    begin
      s := s + p[i - 1];
    end;
    st.Delimiter := ',';
    st.DelimitedText := s;
  finally
    freemem(p);
  end;
end;
//ô

function GetDiskIndex(drive: ansiChar): Integer;
begin
  result := GetDiskIndex_(drive);
end;

function GetDiskSerialNumber(drive: ansiChar;PNPDeviceID:bool): ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    GetDiskSerialNumber_1(drive, p, sz,PNPDeviceID);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;

function GetDiskSerialNumber(index: integer;PNPDeviceID:bool): ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    GetDiskSerialNumber_2(index, p, sz,PNPDeviceID);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
//Ӳ̷,0ʼ,-1ΪӲ

function GetHardDiskPartitionInfo(const DriveLetter: ansiChar;
  var VolumeName, VolumeSerialNumber, PartitionType: ansistring;
  var TotalSpace, TotalFreeSpace: int64): boolean;
var pVolumeName, pVolumeSerialNumber, pPartitionType: pAnsiChar;
  pVolumeNameSize, pVolumeSerialNumberSize, pPartitionTypeSize: Integer;
  i: Integer;
begin
  VolumeName := '';
  VolumeSerialNumber := '';
  PartitionType := '';
  TotalSpace := 0;
  TotalFreeSpace := 0;
  getmem(pVolumeName, 255);
  try
    getmem(pVolumeSerialNumber, 255);
    try
      getmem(pPartitionType, 255);
      try
        result := GetHardDiskPartitionInfo_(DriveLetter, pVolumeName, pVolumeNameSize, pVolumeSerialNumber, pVolumeSerialNumberSize, pPartitionType, pPartitionTypeSize, TotalSpace, TotalFreeSpace);
        for i := 1 to pVolumeNameSize do
        begin
          VolumeName := VolumeName + pVolumeName[i - 1];
        end;
        for i := 1 to pVolumeSerialNumberSize do
        begin
          VolumeSerialNumber := VolumeSerialNumber + pVolumeSerialNumber[i - 1];
        end;
        for i := 1 to pPartitionTypeSize do
        begin
          PartitionType := PartitionType + pPartitionType[i - 1];
        end;
      finally
        freemem(pPartitionType);
      end;
    finally
      freemem(pVolumeSerialNumber);
    end;
  finally
    freemem(pVolumeName);
  end;
end;
//̶Ӧķ̷

function GetDiskDrive(PhysicalDriveId: integer): string;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 11);
  try
    GetDiskDrive_(PhysicalDriveId, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
//õǰõ̷

function GetDriverList: string;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 26);
  try
    GetDriverList_(p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
//豸,豸Ŵ0ʼ0Ϊ1

function GetPhysicalDrivePartitionCount(PhysicalDriveId: Integer): integer;
begin
  Result := GetPhysicalDrivePartitionCount_(PhysicalDriveId);
end;
//smartϢ

function GetDiskInfo(index: integer; var ainfo: JyHDiskInfo): boolean;
begin
  Result := GetDiskInfo_(index, ainfo);
end;

function GetMd5String(ins: ansistring): ansistring;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 100);
  try
    GetMd5String_(@ins[1], length(ins), pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;

function GetCpuID(): string;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 1000);
  try
    GetCpuID_(pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;
function GetBiosID(): string;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 1000);
  try
    GetBiosID_(pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;
function GetDisplayDeviceID(): string;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 1000);
  try
    GetDisplayDeviceID_(pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;
function GetIP(): string;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 1000);
  try
    GetIP_(pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;
function GetMacAddr(): string;
var pout: pansiChar;
  i, poutsize: integer;
begin
  result := '';
  getmem(pout, 1000);
  try
    GetMacAddr_(pout, poutsize);
    for i := 1 to poutsize do
    begin
      result := result + pout[i - 1];
    end;
  finally
    freemem(pout);
  end;
end;
function JyStringLink(s1, s2: string; fgf: string = ' '): string;
begin
  result := '';
  if (s1 = '') and (s2 = '') then Exit;
  if s1 = '' then
  begin
    result := s2;
    Exit;
  end;
  if s2 = '' then
  begin
    result := s1;
    Exit;
  end;
  result := s1 + fgf + s2;
end;

function GetCurrentPath: string;
var
  current_path: string;
begin
  current_path := ExtractFilePath(paramstr(0));
  if current_path[Length(current_path)] <> '\' then
    current_path := current_path + '\';
  Result := current_path;
end;

function getUsbPNPDeviceID(drive: ansiChar): ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    getUsbPNPDeviceID_1(drive, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;

function getUsbPNPDeviceID(index: integer): ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    getUsbPNPDeviceID_2(index, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
function GetDiskSize(index: Integer = 0): Int64;
begin
   result:=GetDiskSize_2(index);
end;
function GetDiskSize(drv: AnsiChar): Int64;
begin
   result:=GetDiskSize_1(drv);
end;
function GetDiskName(index:integer):Ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    GetDiskName_2(index, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
function GetDiskName(drive:AnsiChar):Ansistring;
var sz, i: Integer;
  p: pansiChar;
begin
  result := '';
  getmem(p, 255);
  try
    GetDiskName_1(drive, p, sz);
    for i := 1 to sz do
    begin
      result := result + p[i - 1];
    end;
  finally
    freemem(p);
  end;
end;
//̬ʼ

procedure InitJyDiskDll();
var diskdll, dllpath: string;
begin
  if hDll > 0 then Exit;

  dllpath := GetCurrentPath;
  diskdll := dllpath + dllname;

  hDll := safeLoadLibrary(diskdll);
  if hDll <= 0 then
  begin
    raise exception.create('diskʼʧ!' + #13#10 + diskdll);
    Exit;
  end;
  init_ := GetProcAddress(hDll, 'init');
  getDiskSerialNumber_1 := GetProcAddress(hDll, 'getDiskSerialNumber1');
  getDiskSerialNumber_2 := GetProcAddress(hDll, 'getDiskSerialNumber2');
  getDiskTypeStr_ := GetProcAddress(hDll, 'getDiskTypeStr');
  getDiskType_1 := GetProcAddress(hDll, 'getDiskType1');
  getDiskType_2 := GetProcAddress(hDll, 'getDiskType2');
  getDiskIndex_ := GetProcAddress(hDll, 'getDiskIndex');
  doReg_ := GetProcAddress(hDll, 'doReg');
  isRegisted_ := GetProcAddress(hDll, 'isRegisted');
  getPhysicalDriveCount_ := GetProcAddress(hDll, 'getPhysicalDriveCount');
  runAsAdmin_ := GetProcAddress(hDll, 'runAsAdmin');
  getDiskDrive_ := GetProcAddress(hDll, 'getDiskDrive');
  getDriverList_ := GetProcAddress(hDll, 'getDriverList');
  getPhysicalDrivePartitionCount_ := GetProcAddress(hDll, 'getPhysicalDrivePartitionCount');
  getDiskPartitionIndex_ := GetProcAddress(hDll, 'getDiskPartitionIndex');
  getHardDiskPartitionInfo_ := GetProcAddress(hDll, 'getHardDiskPartitionInfo');
  getDiskInfo_ := GetProcAddress(hDll, 'getDiskInfo');
  getMd5String_ := GetProcAddress(hDll, 'getMd5String');
  getCpuID_:= GetProcAddress(hDll, 'getCpuID');
  getBiosID_:= GetProcAddress(hDll, 'getBiosID');
  getDisplayDeviceID_:= GetProcAddress(hDll, 'getDisplayDeviceID');
  getIP_:= GetProcAddress(hDll, 'getIP');
  getMacAddr_:= GetProcAddress(hDll, 'getMacAddr');
  isWin64_ := GetProcAddress(hDll, 'isWin64');
  getUsbPNPDeviceID_1 := GetProcAddress(hDll, 'getUsbPNPDeviceID1');
  getUsbPNPDeviceID_2 := GetProcAddress(hDll, 'getUsbPNPDeviceID2');
  getDiskSize_1 := GetProcAddress(hDll, 'getDiskSize1');
  getDiskSize_2 := GetProcAddress(hDll, 'getDiskSize2');
  getDiskName_1:= GetProcAddress(hDll, 'getDiskName1');
  getDiskName_2:= GetProcAddress(hDll, 'getDiskName2');
end;
//ͷŶ̬

procedure FreeJyDiskDll;
begin
  if (hDll <= 0) then Exit;
  FreeLibrary(hDll);
  hDll := 0;
  init_:=nil;
  getDiskSerialNumber_1 := nil;
  getDiskSerialNumber_2 := nil;
  getDiskTypeStr_ := nil;
  getDiskType_1 := nil;
  getDiskType_2 := nil;
  getDiskIndex_ := nil;
  doReg_ := nil;
  isRegisted_ := nil;
  getPhysicalDriveCount_ := nil;
  runAsAdmin_ := nil;
  getDiskDrive_ := nil;
  getDriverList_ := nil;
  getPhysicalDrivePartitionCount_ := nil;
  getDiskPartitionIndex_ := nil;
  getHardDiskPartitionInfo_ := nil;
  getDiskInfo_ := nil;
  getMd5String_ := nil;
  getCpuID_:=nil;
  getBiosID_:=nil;
  getDisplayDeviceID_:=nil;
  getIP_:=nil;
  getMacAddr_:=nil;
  isWin64_:=nil;
  getUsbPNPDeviceID_1:=nil;
  getUsbPNPDeviceID_2:=nil;
  getDiskSize_1:=nil;
  getDiskSize_2:=nil;
  getDiskName_1:= nil;
  getDiskName_2:= nil;
end;
initialization
  hDll := 0;
finalization
  FreeJyDiskDll;
end.

