﻿// CShowDlg.cpp: 实现文件
//

#include "pch.h"
#include "Server.h"
#include "afxdialogex.h"
#include "CShowDlg.h"
#include "CListenSocket.h"
#include "CClientSocket.h"


// CShowDlg 对话框

IMPLEMENT_DYNAMIC(CShowDlg, CDialogEx)

CShowDlg::CShowDlg(CClientSocket* pClientSocket, CWnd* pParent /*=nullptr*/)	: CDialogEx(IDD_SHOW_DLG, pParent)
{
	m_pClientSocket = pClientSocket;

	m_nTimes = 260;    //定时器频率初始化
	m_nBmpSize = 0;
	m_lpszBmpData = NULL;
}


CShowDlg::~CShowDlg()
{
}

void CShowDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CShowDlg, CDialogEx)
	ON_WM_TIMER()
	ON_WM_PAINT()
END_MESSAGE_MAP()


// CShowDlg 消息处理程序


void CShowDlg::PostNcDestroy()
{
	// TODO: 在此添加专用代码和/或调用基类
	delete this;
	CDialogEx::PostNcDestroy();
}


BOOL CShowDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  在此添加额外的初始化
	// 
	CString strIPAddress;
	UINT uPort;
	m_pClientSocket->GetPeerName(strIPAddress, uPort);
	// \\192.168.1.2:2022
	CString strTitle;
	strTitle.Format(_T("\\\\%s:%d"),strIPAddress, uPort);
	SetWindowText(strTitle);

	//设置定时器
	SetTimer(GET_CLIENT_SCREEN_TIMER, m_nTimes, NULL);// m_nTimes 毫秒单位
	return TRUE;  // return TRUE unless you set the focus to a control
				  // 异常: OCX 属性页应返回 FALSE
}

//定时器处理函数
void CShowDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: 在此添加消息处理程序代码和/或调用默认值
	switch (nIDEvent)
	{
	case GET_CLIENT_SCREEN_TIMER:
			OnGetClientScreen();
			break;
	}

	CDialogEx::OnTimer(nIDEvent);
}


//获取客户端屏幕的函数
void CShowDlg::OnGetClientScreen()
{
	//自定义协议
	int nMsgType = BITMAP_STRUCT;
	//发给客户端
	if (SOCKET_ERROR == m_pClientSocket->Send(&nMsgType, sizeof(nMsgType), 0))
	{
		m_ccout = false;
		MessageBox("连接失败-客户端可能已经下线了");
		EndDialog(WM_CLOSE);
		return;
	}

	//接收客户端给我发的位图结构

	int nRet = m_pClientSocket->Receive(&m_logBmp, sizeof(BITMAP));
	if (nRet != sizeof(BITMAP))
	{
		MessageBox("接收位图结构错误");
		EndDialog(IDOK);
		return;
	}

	//再次给客户端发送位图数据请求
	nMsgType = BITMAP_DATA;
	if (SOCKET_ERROR == m_pClientSocket->Send(&nMsgType, sizeof(nMsgType), 0))
	return;

	//位图大小
	m_nBmpSize = m_logBmp.bmWidthBytes * m_logBmp.bmHeight;

	if (m_lpszBmpData != NULL)
	{
		delete[] m_lpszBmpData;
		m_lpszBmpData = NULL;
	}
	m_lpszBmpData = new char[m_nBmpSize];

	//接收
	int nRecvByteTotal = 0;//已经发送的数据的总数
	int nCurrentRecvByte = 0; //当前发送的数据大小
	char* p = m_lpszBmpData;//位图数据


	do
	{
		nCurrentRecvByte = m_pClientSocket->Receive(p, m_nBmpSize - nRecvByteTotal);
		nRecvByteTotal = nRecvByteTotal + nCurrentRecvByte;
		p += nCurrentRecvByte;
	} while (nRecvByteTotal < m_nBmpSize);

	if (nRecvByteTotal != m_nBmpSize)
	{
		MessageBox("接收位图数据失败", "提示", MB_OK);
		return;
	}
	//刷新界面

	Invalidate(FALSE);
}

// 显示图像
void CShowDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
					   // TODO: 在此处添加消息处理程序代码
					   // 不为绘图消息调用 CDialogEx::OnPaint()

	if (m_lpszBmpData == NULL)
		return;

	//位图的头
	BITMAPINFOHEADER bih;
	bih.biBitCount = m_logBmp.bmBitsPixel;//每个像素的位数
	bih.biClrImportant = 0;				//显示位图所需要的颜色索引数
	bih.biClrUsed = 0;					//位图使用的颜色
	bih.biCompression = 0;				//位图的压缩类型
	bih.biHeight = m_logBmp.bmHeight;		//位图的高
	bih.biPlanes = 1;					//目标设备的平面数量，必须为1
	bih.biSize = sizeof(BITMAPINFOHEADER);//结构的大小
	bih.biSizeImage = m_logBmp.bmWidth * m_logBmp.bmHeight;			//位图的大小
	bih.biWidth = m_logBmp.bmWidth;		//位图的宽度
	bih.biXPelsPerMeter = 0;			//水平分辨率
	bih.biYPelsPerMeter = 0;			//垂直分辨率


	CBitmap bmp;
	if (FALSE == bmp.CreateBitmapIndirect(&m_logBmp))
		return;
	if (bmp.m_hObject == NULL)
		return;
	//创建一个内存DC
	CDC memDC;
	memDC.CreateCompatibleDC(&dc);
	SetDIBits(memDC.m_hDC, bmp, 0, m_logBmp.bmHeight, m_lpszBmpData, (BITMAPINFO*)&bih, DIB_RGB_COLORS);

	//获取客户区大小
	CRect rect;
	GetClientRect(&rect);

	memDC.SelectObject(&bmp);

	//拉伸贴图
	dc.SetStretchBltMode(HALFTONE);
	dc.StretchBlt(0, 0, rect.Width(), rect.Height(), &memDC, 0, 0, m_logBmp.bmWidth, m_logBmp.bmHeight, SRCCOPY);

	delete[] m_lpszBmpData;
	m_lpszBmpData = NULL;


}
