﻿
// ServerDlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "Server.h"
#include "ServerDlg.h"
#include "afxdialogex.h"
#include "CListenSocket.h"
#include "CClientSocket.h"
#include "CShowDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 用于应用程序“关于”菜单项的 CAboutDlg 对话框

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// 对话框数据
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV 支持

// 实现
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CServerDlg 对话框



CServerDlg::CServerDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_SERVER_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pListenSocket = NULL; //初始化指针
}

CServerDlg::~CServerDlg()
{
	if(m_pListenSocket)
	delete m_pListenSocket;

}

void CServerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE1, m_tree);
}

BEGIN_MESSAGE_MAP(CServerDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE1, &CServerDlg::OnTvnSelchangedTree1)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE1, &CServerDlg::OnDblclkTree1)
END_MESSAGE_MAP()


// CServerDlg 消息处理程序

BOOL CServerDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 将“关于...”菜单项添加到系统菜单中。

	// IDM_ABOUTBOX 必须在系统命令范围内。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	SetWindowText("局域网监控系统");
	m_tree.InsertItem("所有用户");

	CString strMsg;
	m_pListenSocket = new CListenSocket(this);
	if (m_pListenSocket == NULL)
	{
		strMsg.Format("初始化失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK|MB_ICONERROR);

		EndDialog(IDOK);//关闭对话框
		return TRUE;
	}

	//创建套接字
	//TCP协议：SOCK_STREAM
	//UDP协议：SOCK_DGRAM
	if (FALSE == m_pListenSocket->Create(PORT, SOCK_STREAM))
	{
		strMsg.Format("初始化失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);

		EndDialog(IDOK);//关闭对话框
		return TRUE;
	}

	//将套接字设置为监听模式
	if (FALSE == m_pListenSocket->Listen())
	{
		strMsg.Format("初始化失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);

		EndDialog(IDOK);//关闭对话框
		return TRUE;
	}


	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

void CServerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CServerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CServerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CServerDlg::OnAccept()
{
	//返回一个建立连接的套接字
	CClientSocket* pSocket = new CClientSocket;
	if (FALSE == m_pListenSocket->Accept(*pSocket))
	{
		delete pSocket;
		pSocket = NULL;
	}
	else
	{
		//将客户端IP地址显示到界面上来
		CString strIPAddress;
		UINT uPort;
		pSocket->GetPeerName(strIPAddress, uPort);


		//添加到树控件
		HTREEITEM hRootItem = m_tree.GetRootItem();
		HTREEITEM hItem = m_tree.InsertItem(strIPAddress, hRootItem);
		m_tree.SetItemData(hItem, (DWORD)pSocket);
	}
}


void CServerDlg::OnTvnSelchangedTree1(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: 在此添加控件通知处理程序代码
	*pResult = 0;
}


void CServerDlg::OnDblclkTree1(NMHDR* pNMHDR, LRESULT* pResult)
{
	// TODO: 在此添加控件通知处理程序代码
	//MessageBox("双击了节点");
	//获得跟节点
	HTREEITEM hRootItem = m_tree.GetRootItem();
	//获取当前选中的节点
	HTREEITEM hItem = m_tree.GetSelectedItem();

	if (hRootItem == hItem)
		return;

	//弹一个对话框
	//模态对话框 -- 打开后不能对主程序做其他操作
	//非模态对话框 -- 打开后可以任意操作主程序，可以同时多个对话框操作

	CClientSocket* pClientSocket = (CClientSocket*)m_tree.GetItemData(hItem);

	CShowDlg* pDlg = new CShowDlg(pClientSocket);
	if (FALSE == pDlg->Create(IDD_SHOW_DLG))
	{
		CString strMsg;
		strMsg.Format("创建对话框失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);
		delete pDlg;
	}
	pDlg->ShowWindow(SW_SHOW);

	*pResult = 0;
}
