﻿
// ClientDlg.cpp: 实现文件
//

#include "pch.h"
#include "framework.h"
#include "Client.h"
#include "ClientDlg.h"
#include "afxdialogex.h"
#include "CClientSocket.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CClientDlg 对话框



CClientDlg::CClientDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_CLIENT_DIALOG, pParent)
	, m_uPort(2022)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pClientSocket = NULL;
	m_lpszBmpData = NULL;

	m_nScreenWidth = GetSystemMetrics(SM_CXSCREEN);
	m_nScreenHeight = GetSystemMetrics(SM_CYSCREEN);
}

void CClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IPADDRESS, m_IPAddressCtrl);
	DDX_Text(pDX, IDC_EDIT_PORT, m_uPort);
}

BEGIN_MESSAGE_MAP(CClientDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BNT_CONNECT, &CClientDlg::OnBnClickedBntConnect)
END_MESSAGE_MAP()


// CClientDlg 消息处理程序

BOOL CClientDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// 设置此对话框的图标。  当应用程序主窗口不是对话框时，框架将自动
	//  执行此操作
	SetIcon(m_hIcon, TRUE);			// 设置大图标
	SetIcon(m_hIcon, FALSE);		// 设置小图标

	// TODO: 在此添加额外的初始化代码
	m_IPAddressCtrl.SetWindowText(TEXT("192.168.1.101"));

	return TRUE;  // 除非将焦点设置到控件，否则返回 TRUE
}

// 如果向对话框添加最小化按钮，则需要下面的代码
//  来绘制该图标。  对于使用文档/视图模型的 MFC 应用程序，
//  这将由框架自动完成。

void CClientDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 用于绘制的设备上下文

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// 使图标在工作区矩形中居中
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 绘制图标
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

//当用户拖动最小化窗口时系统调用此函数取得光标
//显示。
HCURSOR CClientDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


//连接服务器按钮
void CClientDlg::OnBnClickedBntConnect()
{
	//ip地址端口号都不能为空
	UpdateData(TRUE);
	CString strIPAdress;
	m_IPAddressCtrl.GetWindowText(strIPAdress);
	if (strIPAdress.IsEmpty() || strIPAdress == TEXT("0.0.0.0"))
	{
		MessageBox("请输入IP地址", "温馨提示", MB_OK);
		return;
	}

	CString strMsg;
	m_pClientSocket = new CClientSocket(this);
	if (m_pClientSocket == NULL)
	{
		strMsg.Format("初始化失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);

		//EndDialog(IDOK);//关闭对话框
		//return TRUE;
		return;
	}

	//创建套接字
	//TCP协议：SOCK_STREAM
	//UDP协议：SOCK_DGRAM
	if (FALSE == m_pClientSocket->Create())
	{
		strMsg.Format("初始化失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);

		//EndDialog(IDOK);//关闭对话框
		//return TRUE;
		return;
	}

	//连接服务器
	if (FALSE == m_pClientSocket->Connect(strIPAdress, m_uPort))
	{
		strMsg.Format("连接服务器失败.错误码:%d", GetLastError());
		MessageBox(strMsg, "温馨提示", MB_OK | MB_ICONERROR);

		//EndDialog(IDOK);//关闭对话框
		//return TRUE;
		return;
	}
}



//发送位图结构的函数
void CClientDlg::SendBitmapStruct()
{
	//开始采集
	CatchScreen();
	//发送
	m_pClientSocket->Send(&m_logBmp, sizeof(BITMAP));
}


//发送位图数据的函数
void CClientDlg::SendBitmapData()
{
	if (m_lpszBmpData == NULL)
		return;

	//int nSendByteTotal = 0;//已经发送的数据的总数
	//int nCurrentSendByte = 0; //当前发送的数据大小
	char* p = m_lpszBmpData;//位图数据

	m_pClientSocket->Send(p, m_nBmpSize);
	//do
	//{
	//	nCurrentSendByte = m_pClientSocket->Send(p, m_nBmpSize - nSendByteTotal);
	//	nSendByteTotal = nSendByteTotal + nCurrentSendByte;
	//	p += nCurrentSendByte;

	//} while (nSendByteTotal < m_nBmpSize);
	//释放内存
	delete[] m_lpszBmpData;
	m_lpszBmpData = NULL;
	m_nBmpSize = 0;


}

//捕获屏幕
void CClientDlg::CatchScreen()
{
	CDC dc;
	dc.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);

	//创建一张兼容位图
	CBitmap bmp;
	bmp.CreateCompatibleBitmap(&dc, m_nScreenWidth, m_nScreenHeight);
	//创建内存DC
	CDC tempMemDC;
	tempMemDC.CreateCompatibleDC(&dc);
	tempMemDC.SelectObject(&bmp);
	tempMemDC.BitBlt(0, 0, m_nScreenWidth, m_nScreenHeight, &dc, 0, 0, SRCCOPY);

	//获取位图的结构信息
	bmp.GetBitmap(&m_logBmp);

	//获取位图的大小
	m_nBmpSize = m_logBmp.bmWidthBytes * m_logBmp.bmHeight;

	//申请内存
	if (m_lpszBmpData != NULL)
	{
		delete[] m_lpszBmpData;
		m_lpszBmpData = NULL;
	}

	m_lpszBmpData = new char[m_nBmpSize];

	//位图的头
	BITMAPINFOHEADER bih;
	bih.biBitCount = m_logBmp.bmBitsPixel;//每个像素的位数
	bih.biClrImportant = 0;				//显示位图所需要的颜色索引数
	bih.biClrUsed = 0;					//位图使用的颜色
	bih.biCompression = 0;				//位图的压缩类型
	bih.biHeight = m_logBmp.bmHeight;		//位图的高
	bih.biPlanes = 1;					//目标设备的平面数量，必须为1
	bih.biSize = sizeof(BITMAPINFOHEADER);//结构的大小
	bih.biSizeImage = m_nBmpSize;			//位图的大小
	bih.biWidth = m_logBmp.bmWidth;		//位图的宽度
	bih.biXPelsPerMeter = 0;			//水平分辨率
	bih.biYPelsPerMeter = 0;			//垂直分辨率

	GetDIBits(dc, bmp, 0, bih.biHeight, m_lpszBmpData, (BITMAPINFO*)&bih, DIB_RGB_COLORS);

	//
	tempMemDC.DeleteDC();
	bmp.DeleteObject();
	dc.DeleteDC();
}