<?php
// +----------------------------------------------------------------------
// | Quotes [未来可期]
// +----------------------------------------------------------------------
// +----------------------------------------------------------------------
// | Author: 微站网 Jn去广告 作者QQ：Jn去联系
// +----------------------------------------------------------------------
// | Date: 2020年2月5日
// +----------------------------------------------------------------------
include('header.php');

//项目列表
$numrows = $DB->query("SELECT * from `wcms_program` WHERE 1")->rowCount();
$list = $DB->query("SELECT * FROM `wcms_program` WHERE 1 order by `pid` asc")->fetchAll();
//添加、修改项目
$pid = intval(daddslashes($_GET['pid']));
$type = daddslashes($_GET['type']);

if ($type == 'edit' && $pid) {
    $row = $DB->query("SELECT * from `wcms_program` WHERE `pid`={$pid} limit 1")->fetch();
    $title = '修改项目';
    $result = 1; //修改项目
} else if ($type == 'add') {
    $title = '添加项目';
    $result = 2; //添加项目
} else {
    $result = 3; //项目列表
}
?>

<?php if ($result == 3){ ?>
<!-- Page Content-->
<div class="page-content">

    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="float-right">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                            <li class="breadcrumb-item active">项目列表</li>
                        </ol>
                    </div>
                    <h4 class="page-title">管理模块</h4>
                </div><!--end page-title-box-->
            </div><!--end col-->
        </div>
        <!-- end page title end breadcrumb -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mt-0 header-title">项目列表</h4>
                        <div class="float-right dropdown-left">
                            <button class="btn btn-success"  data-toggle="dropdown" >
                                <i class="dripicons-arrow-down"></i>  项目操作
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a href="program.php?type=add" class="dropdown-item btn m-b-xs btn-sm btn-addon">
                                        <i class="typcn typcn-th-large-outline "></i> 添加项目
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" data-toggle="modal" data-target="#replaceProPath">
                                        <i class="fas fa-home "></i> 替换所有项目源地址
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" data-toggle="modal" data-target="#replaceSalePrice">
                                        <i class="fas fa-compass "></i> 设置所有项目销售价格
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" data-toggle="modal" data-target="#replaceRePrice">
                                        <i class="far fa-compass "></i> 设置所有项目续费价格
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" data-toggle="modal" data-target="#replaceUseTime">
                                        <i class="fas fa-hockey-puck "></i> 设置所有项目使用时间
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" data-toggle="modal" data-target="#replaceDemo">
                                        <i class="fas fa-book "></i> 设置所有项目演示地址
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" id="onSaleAll">
                                        <i class="fas fa-check-circle "></i> 上架所有项目
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" id="downSaleAll">
                                        <i class=" fas fa-minus-circle "></i> 下架所有项目
                                    </a>
                                </li>
                                <li><a href="javascript:void(0)" role="button"  class="dropdown-item btn m-b-xs btn-sm btn-addon" id="delProAll">
                                        <i class="fas fa-shopping-basket "></i> 删除所有项目
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <span flex></span>
                        <p class="text-muted mb-4 font-13">
                            系统共有 <code><?php echo $numrows?></code> 个项目
                        </p>
                        <table id="datatable" class="table table-bordered dt-responsive nowrap"
                               style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>项目编号</th>
                                <th>项目名称</th>
                                <th>项目状态</th>
                                <th>程序价格</th>
                                <th>使用时间</th>
                                <th>续费价格</th>
                                <th>演示网址</th>
                                <th>操作</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($list as $res) {
                                if($res['status'] == 1){
                                    $res['status'] = '<span class="badge badge-soft-success">上架中</span>';
                                }else{
                                    $res['status'] = '<span class="badge badge-soft-danger">下架中</span>';
                                }
                                echo '
                                    <tr id="' . $res['pid'] . '">
                                        <td>' . $res['pid'] . '</td>
                                        <td>' . $res['name'] . '</td>
                                        <td>' . $res['status'] . '</td>
                                        <td>￥ ' . $res['price'] . '</td>
                                        <td>' . $res['usetime'] . '个月</td>
                                        <td>￥ ' . $res['reprice'] . '</td>
                                        <td>' . $res['demo'] . '</td>
                                        <td>
                                          <a href="program.php?type=edit&pid=' . $res['pid'] . '" class="btn m-b-xs btn-sm btn-primary btn-addon" >修改</a>
                                          <a href="javascript:void(0);" onclick="delProgram(' . $res['pid'] . ')" class="btn m-b-xs btn-sm btn-danger btn-addon" >删除</a>
                                        </td>
                                    </tr>   
                                 ';
                            }
                            ?>
                            </tbody>
                        </table>
                        <span id="originalPro"></span>

                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->

    </div><!-- container -->


    <!--替换项目源地址-->
    <div class="modal fade" id="replaceProPath" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h4>一键替换项目源地址</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <!---业务代码 -->
                    <div class="form-group">
                        <div class="input-group mb-3">
                            <br/>

                            <input type="text" class="form-control" id="proPath" name="proPath" placeholder="请输入您的项目源地址(带http)">
                            <button type="button" class="btn btn-primary" id="changeProPath" style="text-align:center" >保存数据
                            </button>

                        </div>
                        <code style="color: green"><span id="getLastPathTip"></span></code><br/>
                        <code style="color: green"><span id="getLastPath"></span></code>
                    </div><!--end form-group-->
                    <br/>
                    <table class="table table-striped table-bordered table-hover dataTables-example" id="tab">
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>

    <!--设置销售价格-->
    <div class="modal fade" id="replaceSalePrice" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h4>设置所有项目销售价格</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <!---业务代码 -->
                    <div class="form-group">
                        <div class="input-group mb-3">
                            <br/>

                            <input type="text" class="form-control" id="salePrice" name="salePrice" placeholder="输入项目销售价格">
                            <button type="button" class="btn btn-primary" id="changeSalePrice" style="text-align:center" >保存数据
                            </button>

                        </div>
                        <code><span id="getLastPath"></span></code><br/>
                        <code><span id="getLastPathTip"></span></code>
                    </div><!--end form-group-->
                    <br/>
                    <table class="table table-striped table-bordered table-hover dataTables-example" id="tab">
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>

    <!--设置续费价格-->
    <div class="modal fade" id="replaceRePrice" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h4>设置所有项目续费价格</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <!---业务代码 -->
                    <div class="form-group">
                        <div class="input-group mb-3">
                            <br/>

                            <input type="text" class="form-control" id="rePrice" name="rePrice" placeholder="输入项目续费价格">
                            <button type="button" class="btn btn-primary" id="changeRePrice" style="text-align:center" >保存数据
                            </button>

                        </div>
                        <code><span id="getLastPath"></span></code><br/>
                        <code><span id="getLastPathTip"></span></code>
                    </div><!--end form-group-->
                    <br/>
                    <table class="table table-striped table-bordered table-hover dataTables-example" id="tab">
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>

    <!--设置使用时间-->
    <div class="modal fade" id="replaceUseTime" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h4>设置所有项目使用时间</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <!---业务代码 -->
                    <div class="form-group">
                        <div class="input-group mb-3">
                            <br/>

                            <input type="text" class="form-control" id="useTime" name="useTime" placeholder="输入项目使用时间(月)">
                            <button type="button" class="btn btn-primary" id="changeUseTime" style="text-align:center" >保存数据
                            </button>

                        </div>
                        <code><span id="getLastPath"></span></code><br/>
                        <code><span id="getLastPathTip"></span></code>
                    </div><!--end form-group-->
                    <br/>
                    <table class="table table-striped table-bordered table-hover dataTables-example" id="tab">
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>

    <!--设置演示地址-->
    <div class="modal fade" id="replaceDemo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h4>设置所有项目演示地址</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <!---业务代码 -->
                    <div class="form-group">
                        <div class="input-group mb-3">
                            <br/>

                            <input type="text" class="form-control" id="demo" name="demo" placeholder="输入项目演示地址(不需要带http://)">
                            <button type="button" class="btn btn-primary" id="changeDemo" style="text-align:center" >保存数据
                            </button>

                        </div>
                        <code><span id="getLastPath"></span></code><br/>
                        <code><span id="getLastPathTip"></span></code>
                    </div><!--end form-group-->
                    <br/>
                    <table class="table table-striped table-bordered table-hover dataTables-example" id="tab">
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" data-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>



    <?php } else if ($result == 2){ ?>
        <!-- Page Content-->
        <div class="page-content">
        <div class="container-fluid">
            <!-- Page-Title -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box">
                        <div class="float-right">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                                <li class="breadcrumb-item active"><?php echo $title ?></li>
                            </ol>
                        </div>
                        <h4 class="page-title">管理模块</h4>
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div>
            <!-- end page title end breadcrumb -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title"><?php echo $title ?></h4>
                            <p class="text-muted mb-3">addProgram.
                            </p>
                            <form action="#" method="post">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label text-left">项目分类</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="tid">
                                                    <?php
                                                    $typeList = $DB->query("SELECT * FROM `wcms_protype` ")->fetchAll();
                                                    foreach ($typeList as $type){
                                                        echo '<option value="'.$type['id'].'">'.$type['name'].'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row" >
                                            <label class="col-sm-2 col-form-label text-left">是否指定服务器</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="specifys_server" id="change_555" >指定
                                                    <option value="0">不指定</option>
                                                    <option value="1">指定</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row"  id="open_555" style="display:none;">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">选择服务器</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="sid">
                                                    <?php
                                                    $rowServers = $DB->query("SELECT * from `wcms_server` WHERE  `active`= 1 ")->fetchAll();
                                                    foreach ($rowServers as $rowServer) { ?>
                                                        <option value="<?php echo $rowServer['sid'] ?>"><?php echo $rowServer['sname'] ?>  </option>
                                                    <?php } ?>
                                                </select>
                                                <code>若指定服务器,该项目只能搭建在指定服务器上</code>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">项目名称</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="name">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目描述</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="5" name="decription"></textarea>
                                                <code>支持html代码,可使用 <a href="http://ueditor.baidu.com/website/onlinedemo.html" target="_blank">百度在线编辑器</a></code>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目提示信息</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="5" name="tip"></textarea>
                                                <code>可用于提示默认账号密码等,可以不填写</code>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">项目图片地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="img">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目源地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="path" placeholder="需要带http">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目PHP版本</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="phpversion" >
                                                    <?php
                                                    foreach($sitePHPConfig as $key => $value){
                                                        echo '<option value="'.$key.'">'.$value.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                                <small class="text-navy">选择项目需要的PHP版本,并确保服务器已经安装了对应PHP版本</small>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目安装标识</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="install" placeholder="不需要带.zip">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目价格</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="price">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">续费价格</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="reprice">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">使用时间</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="number" name="usetime" placeholder="输入可以使用的月数,例如12">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"  class="col-sm-2 col-form-label text-left">演示地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="demo">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目运行目录</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="site_path" placeholder="可留空">
                                                <small class="text-navy">部分项目需要指定运行目录,不指定请填写/,如指定请填写/目录,例如/public</small>
                                            </div>
                                        </div>
                                        <div class="form-group row" >
                                            <label class="col-sm-2 col-form-label text-left">是否开启伪静态</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="isrewrite" id="change_666" >
                                                    <option value="0">关闭</option>
                                                    <option value="1">开启</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row"  id="open_666" style="display:none;">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">伪静态规则</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="rewrite" >
                                                    <?php
                                                    foreach($reWiteConfig as $key => $value){
                                                        echo '<option value="'.$key.'">'.$key.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                                <code>部分程序提供了伪静态规则，如果列表中没有您需要的伪静态,可到app目录下siteConfig.php文件添加</code>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label text-left">是否参与打折</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="discount">
                                                    <option value="1">打折</option>
                                                    <option value="0">不打折</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label text-left">是否上架</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="status">
                                                    <option value="1">上架</option>
                                                    <option value="0">下架</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end card-body-->
                                <div class="row">
                                    <div class="col-sm-10 ml-auto">
                                        <button type="button" class="btn btn-primary" id="addProgram">保存数据</button>
                                    </div>
                                </div>
                            </form>
                        </div><!--end card-->
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end row-->
        </div><!-- container -->
    <?php } else if ($result == 1){ ?>
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="float-right">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">管理模块</a></li>
                                    <li class="breadcrumb-item active"><?php echo $title ?></li>
                                </ol>
                            </div>
                            <h4 class="page-title">修改项目</h4>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div>
                <!-- end page title end breadcrumb -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="mt-0 header-title"><?php echo $title ?></h4>
                                <p class="text-muted mb-3">editProgram.
                                </p>
                                <form action="#" method="post">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group row">
                                                <label for="example-text-input"
                                                       class="col-sm-2 col-form-label text-left">项目分类</label>
                                                <div class="col-sm-10">
                                                    <select class="custom-select" name="tid">
                                                        <?php
                                                        $typeList = $DB->query("SELECT * FROM `wcms_protype` ")->fetchAll();
                                                        foreach ($typeList as $type){ ?>
                                                            <option value="<?php echo $type['id'];?>" <?php if($row['tid']==$type['id']){ ?> selected = "selected" <?php }?> > <?php echo $type['name'];?></option>';
                                                        <?php   }?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group row" >
                                                <label class="col-sm-2 col-form-label text-left">是否指定服务器</label>
                                                <div class="col-sm-10">
                                                    <select class="custom-select" name="specifys_server" id="change_555" >指定
                                                        <?php if ($row['specifys_server'] == 0) { ?>
                                                            <option value="0">不指定</option>
                                                            <option value="1">指定</option>
                                                        <?php } else { ?>
                                                            <option value="1">指定</option>
                                                            <option value="0">不指定</option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <?php if($row['specifys_server'] == 0){
                                                echo '<div class="form-group row"  id="open_555" style="display:none;">';
                                            }else{
                                                echo '<div class="form-group row"  id="open_555" >';
                                            }?>
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">选择服务器</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="sid">
                                                    <?php
                                                    $rowServers = $DB->query("SELECT * FROM `wcms_server` ")->fetchAll();
                                                    foreach ($rowServers as $rowServer){ ?>
                                                        <option value="<?php echo $rowServer['sid'];?>" <?php if($row['sid']==$rowServer['sid']){ ?> selected = "selected" <?php }?> > <?php echo $rowServer['sname'];?></option>';
                                                    <?php   }?>
                                                </select>
                                                <code>若指定服务器,该项目只能搭建在指定服务器上</code>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <input class="form-control" type="hidden" name="pid" value="<?php echo $row['pid'] ?>">
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">项目名称</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="name" value="<?php echo $row['name'] ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input" class="col-sm-2 col-form-label text-left">项目描述</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="5" name="decription"><?php echo $row['decription'] ?></textarea>
                                                <code>支持html代码,可使用 <a href="http://ueditor.baidu.com/website/onlinedemo.html" target="_blank">百度在线编辑器</a></code>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目提示信息</label>
                                            <div class="col-sm-10">
                                                <textarea class="form-control" rows="5" name="tip"><?php echo $row['tip'] ?></textarea>
                                                <code>可用于提示默认账号密码等,可以不填写</code>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目图片地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="img" value="<?php echo $row['img'] ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目源地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="path" value="<?php echo $row['path'] ?>" placeholder="需要带http">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目PHP版本</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="phpversion" >
                                                    <option value="<?php echo $row['phpversion'] ?>"><?php echo $row['phpversion'] ?></option>
                                                    <?php
                                                    foreach($sitePHPConfig as $key => $value){
                                                        echo '<option value="'.$key.'">'.$value.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                                <small class="text-navy">选择项目需要的PHP版本,并确保服务器已经安装了对应PHP版本</small>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目安装标识</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="install" value="<?php echo $row['install'] ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目价格</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="price" value="<?php echo $row['price'] ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">续费价格</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="reprice" value="<?php echo $row['reprice'] ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">使用时间</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="number" name="usetime" value="<?php echo $row['usetime'] ?>" placeholder="输入可以使用的月数,例如12">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">演示地址</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="demo" value="<?php echo $row['demo'] ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="example-text-input"
                                                   class="col-sm-2 col-form-label text-left">项目运行目录</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" name="site_path" placeholder="可留空" value="<?php echo $row['site_path'] ?>">
                                                <small class="text-navy">部分项目需要指定运行目录,不指定请填写/,如指定请填写/目录,例如/public</small>
                                            </div>
                                        </div>
                                        <div class="form-group row" >
                                            <label class="col-sm-2 col-form-label text-left">是否开启伪静态</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="isrewrite" id="change_666" >
                                                    <?php if ($row['isrewrite'] == 0) { ?>
                                                        <option value="0">关闭</option>
                                                        <option value="1">开启</option>
                                                    <?php } else { ?>
                                                        <option value="1">开启</option>
                                                        <option value="0">关闭</option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <?php if($row['isrewrite'] == 0){
                                            echo '<div class="form-group row"  id="open_666" style="display:none;">';
                                        }else{
                                            echo '<div class="form-group row"  id="open_666" >';
                                        }?>
                                        <label for="example-text-input"
                                               class="col-sm-2 col-form-label text-left">伪静态规则</label>
                                        <div class="col-sm-10">
                                            <select class="custom-select" name="rewrite" >
                                                <option value="<?php echo $row['rewrite']?>"><?php echo $row['rewrite']?></option>
                                                <?php
                                                foreach($reWiteConfig as $key => $value){
                                                    echo '<option value="'.$key.'">'.$key.'</option>';
                                                }
                                                ?>
                                            </select>
                                            <code>部分程序提供了伪静态规则，如果列表中没有您需要的Nginx伪静态,可到app目录下siteConfig.php文件添加</code>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-left">是否参与打折</label>
                                        <div class="col-sm-10">
                                            <select class="custom-select" name="discount">
                                                <?php if ($row['discount'] == 0) { ?>
                                                    <option value="0">不打折</option>
                                                    <option value="1">打折</option>
                                                <?php } else { ?>
                                                    <option value="1">打折</option>
                                                    <option value="0">不打折</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label text-left">是否上架</label>
                                        <div class="col-sm-10">
                                            <select class="custom-select" name="status">
                                                <?php if ($row['status'] == 0) { ?>
                                                    <option value="0">下架</option>
                                                    <option value="1">上架</option>
                                                <?php } else { ?>
                                                    <option value="1">上架</option>
                                                    <option value="0">下架</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                            </div>
                        </div><!--end card-body-->
                        <div class="row">
                            <div class="col-sm-10 ml-auto">
                                <button type="button" class="btn btn-primary" id="editProgram">保存数据</button>
                            </div>
                        </div>
                        </form>
                    </div><!--end card-->
                </div><!--end col-->
            </div><!--end row-->
        </div><!--end row-->




        </div><!-- container -->
    <?php } ?>

    <?php
    include('footer.php');
    ?>
    <script>

        $.ajax
        ({
            cache: false,
            async: false,
            dataType: 'json', type: 'post',
            url: "ajax.php?act=getOriginalPro",
            success: function (data){
                $("#originalPro").html(data.data);
            }
        });

        $.ajax
        ({
            cache: false,
            async: false,
            dataType: 'json', type: 'post',
            url: "ajax.php?act=getLastPath",
            success: function (data){
                $("#getLastPath").html(data.getLastPath);
                $("#getLastPathTip").html(data.getLastPathTip);
            }
        });

        $("select[id^='change_']").change(function(){
            var id = $(this).attr('id').split('_')[1];
            var c  = $(this).val();
            if( parseInt(c) == 1 ){
                $('#open_'+id).show();
            }else{
                $('#open_'+id).hide();
            }
        });
        function delProgram(pid) {
            layer.confirm('确认删除 ' + pid + ' 吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=delProgram',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            pid: pid
                        },
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    var del="#"+pid;
                                    $(del).remove();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });
        }

        $("#editProgram").click(function () {
            var ii = layer.load(0, {shade: false,time: 35000}); //0代表加载的风格，支持0-2
            $.ajax({
                url: 'ajax.php?act=editProgram',
                type: 'POST',
                dataType: 'json',
                data: {
                    pid: $("input[name='pid']").val(),
                    tid: $("select[name='tid']").val(),
                    name: $("input[name='name']").val(),
                    price: $("input[name='price']").val(),
                    img: $("input[name='img']").val(),
                    reprice: $("input[name='reprice']").val(),
                    path: $("input[name='path']").val(),
                    install: $("input[name='install']").val(),
                    status: $("select[name='status']").val(),
                    usetime: $("input[name='usetime']").val(),
                    site_path: $("input[name='site_path']").val(),
                    decription: $("textarea[name='decription']").val(),
                    tip: $("textarea[name='tip']").val(),
                    discount: $("select[name='discount']").val(),
                    phpversion: $("select[name='phpversion']").val(),
                    isrewrite: $("select[name='isrewrite']").val(), //是否开启伪静态
                    rewrite: $("select[name='rewrite']").val(), //伪静态规则
                    specifys_server: $("select[name='specifys_server']").val(),
                    sid: $("select[name='sid']").val(),
                    demo: $("input[name='demo']").val()
                },
                success: function (data) {
                    layer.close(ii);
                    if (data.code == 1) {
                        layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                            location.href = 'program.php';
                        });
                    } else {
                        layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                    }
                },
                error: function () {
                    layer.close(ii);
                    layer.alert("网络连接错误");
                }
            })
        })


        $("#addProgram").click(function () {
            var ii = layer.load(0, {shade: false,time: 35000}); //0代表加载的风格，支持0-2
            $.ajax({
                url: 'ajax.php?act=addProgram',
                type: 'POST',
                dataType: 'json',
                data: {
                    tid: $("select[name='tid']").val(),
                    name: $("input[name='name']").val(),
                    price: $("input[name='price']").val(),
                    img: $("input[name='img']").val(),
                    reprice: $("input[name='reprice']").val(),
                    path: $("input[name='path']").val(),
                    install: $("input[name='install']").val(),
                    site_path: $("input[name='site_path']").val(),
                    usetime: $("input[name='usetime']").val(),
                    status: $("select[name='status']").val(),
                    decription: $("textarea[name='decription']").val(),
                    tip: $("textarea[name='tip']").val(),
                    phpversion: $("select[name='phpversion']").val(),
                    discount: $("select[name='discount']").val(),
                    isrewrite: $("select[name='isrewrite']").val(), //是否开启伪静态
                    rewrite: $("select[name='rewrite']").val(), //伪静态规则
                    specifys_server: $("select[name='specifys_server']").val(),
                    sid: $("select[name='sid']").val(),
                    demo: $("input[name='demo']").val()
                },
                success: function (data) {
                    layer.close(ii);
                    if (data.code == '1') {
                        layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                            location.href = 'program.php';
                        });
                    } else {
                        layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                        return false;
                    }
                },
                error: function () {
                    layer.close(ii);
                    layer.alert("网络连接错误");
                }
            })
        })

        $("#changeProPath").click(function () {
            layer.confirm('确认替换所有项目的安装源地址吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=changeProPath',
                        type: 'POST',
                        dataType: 'json',
                        data:{proPath:$("#proPath").val()},
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })


        $("#changeSalePrice").click(function () {
            layer.confirm('确认修改所有项目的销售价格吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=changeSalePrice',
                        type: 'POST',
                        dataType: 'json',
                        data:{salePrice:$("#salePrice").val()},
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })


        $("#changeRePrice").click(function () {
            layer.confirm('确认修改所有项目的续费价格吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=changeRePrice',
                        type: 'POST',
                        dataType: 'json',
                        data:{rePrice:$("#rePrice").val()},
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })



        $("#changeDemo").click(function () {
            layer.confirm('确认修改所有项目的演示地址吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=changeDemo',
                        type: 'POST',
                        dataType: 'json',
                        data:{demo:$("#demo").val()},
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });
        })



        $("#changeUseTime").click(function () {
            layer.confirm('确认修改所有项目的使用时间吗?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=changeUseTime',
                        type: 'POST',
                        dataType: 'json',
                        data:{useTime:$("#useTime").val()},
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });
        })

        $("#onSaleAll").click(function () {
            layer.confirm('确认上架所有项目?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=onSaleAll',
                        type: 'POST',
                        dataType: 'json',
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })



        $("#downSaleAll").click(function () {
            layer.confirm('确认下架所有项目?', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=downSaleAll',
                        type: 'POST',
                        dataType: 'json',
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })




        $("#delProAll").click(function () {
            layer.confirm('确认删除所有项目?删除后不可恢复。', {
                btn: ['是', '否'], btn1: function () {
                    $.ajax({
                        url: 'ajax.php?act=delProAll',
                        type: 'POST',
                        dataType: 'json',
                        success: function (data) {
                            if (data.code == 1) {
                                layer.msg(data.msg, {icon: 1, time: 2000, shade: 0.4}, function () {
                                    location.reload();
                                });
                            } else {
                                layer.msg(data.msg, {icon: 2, time: 2000, shade: 0.4});
                            }
                        }
                    });
                }
            });

        })
    </script>
