<?php
// +----------------------------------------------------------------------
// | Quotes [未来可期]
// +----------------------------------------------------------------------
// +----------------------------------------------------------------------
// | Author: 微站网 Jn去广告 作者QQ：Jn去联系
// +----------------------------------------------------------------------
// | Date: 2020年2月5日
// +----------------------------------------------------------------------
include '../app/common.php';
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="AS">
    <title><?php echo $conf['web_name'] ?>|<?php echo $conf['web_subtitle'] ?></title>
    <meta name="description" content="<?php echo $conf['web_description'] ?>"/>
    <meta name="keywords" content="<?php echo $conf['keywords'] ?>"/>
    <link rel="shortcut icon" href="./assets/img/favicon.ico?r=<?php echo rand(10000,99999)?>">
    <link rel="stylesheet" href="./assets/etem/css/nucleo.css" type="text/css">
    <link rel="stylesheet" href="./assets/etem/css/fortawesome.css" type="text/css">
    <link rel="stylesheet" href="./assets/etem/css/aswl.min.css" type="text/css">
    <style type="text/css">.row { margin: 0 }</style>
</head>
<body>
<nav id="navbar-main" class="navbar navbar-horizontal navbar-transparent navbar-main navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="/"><?php echo $conf['web_name'] ?></a>

        <div class="navbar-collapse navbar-custom-collapse collapse" id="navbar-collapse">
            <div class="navbar-collapse-header">
                <div class="row">
                    <div class="col-6 collapse-brand">
                        <a href="/"><?php echo $conf['web_name']; ?></a>
                    </div>
                    <div class="col-6 collapse-close">
                        <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbar-collapse" aria-controls="navbar-collapse" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="nav-link-inner--text">用户注册</span>
                            <span class="nav-link-inner--text">用户登录</span>
                        </button>
                    </div>
                </div>
            </div>
            <ul class="navbar-nav mr-auto">

                <li class="nav-item">
                    <a href="./consumer/register.php" class="nav-link">
                        <span class="nav-link-inner--text">用户注册</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="./consumer/login.php" class="nav-link">
                        <span class="nav-link-inner--text">用户登录</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<!-- Main content -->
<div class="main-content">
    <!-- Header -->
    <div class="header bg-primary pt-5 pb-7">
        <div class="container">
            <div class="header-body">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="pr-5">
                            <h1 class="display-2 text-white font-weight-bold mb-0"><?php echo $conf['web_name'] ?></h1>
                            <h2 class="display-4 text-white font-weight-light">
                                我们专注的每一面，都是为了给你更好的体验
                            </h2>
                            <p class="text-white mt-4"><?php echo $conf['web_name'] ?>
                                平台,以信誉求市场,以稳定求发展，行业内最安全，简单易用，专业的技术团队，最放心的自助建站系统。</p>
                            <div class="mt-5">
                                <a href="./consumer/register.php" class="btn btn-neutral my-2">用户注册</a>
                                <a href="./consumer/login.php" class="btn btn-default my-2">用户登录</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="row pt-5">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="icon icon-shape bg-gradient-red text-white rounded-circle shadow mb-4">
                                            <i class="ni ni-active-40"></i>
                                        </div>
                                        <h5 class="h3">数据统计</h5>
                                        <p>后台数据详尽直观，轻松管理查看数据占比。</p>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <div class="icon icon-shape bg-gradient-info text-white rounded-circle shadow mb-4">
                                            <i class="ni ni-active-40"></i>
                                        </div>
                                        <h5 class="h3">快捷支付</h5>
                                        <p>节省支付模块系统开发及维护成本。</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="icon icon-shape bg-gradient-success text-white rounded-circle shadow mb-4">
                                            <i class="ni ni-active-40"></i>
                                        </div>
                                        <h5 class="h3">系统安全</h5>
                                        <p>安全稳定的系统保障和专业的技术团队支持。</p>
                                    </div>
                                </div>
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="icon icon-shape bg-gradient-warning text-white rounded-circle shadow mb-4">
                                            <i class="ni ni-active-40"></i>
                                        </div>
                                        <h5 class="h3">方便快捷</h5>
                                        <p>一个操作平台，聚合多种交易渠道。</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="separator separator-bottom separator-skew zindex-100">
            <svg x="0" y="0" viewBox="0 0 2560 100" preserveAspectRatio="none" version="1.1"
                 xmlns="http://www.w3.org/2000/svg">
                <polygon class="fill-default" points="2560 0 2560 100 0 100"></polygon>
            </svg>
        </div>
    </div>
    <section class="py-6 pb-9 bg-default">
        <div class="row justify-content-center text-center">
            <div class="col-md-6">
                <h2 class="display-3 text-white">你凭什么选择我们？</h2>
                    <p class="lead text-white">
                        服务器群集中管理,快速建站,多合一终端使用 。</br>独立服务器,服务全国个人组织企业用户均可使用 。</br>全套教程文档，各类教程视频在线解决问题 。
                    </p>
            </div>
        </div>
    </section>
    <section class="section section-lg pt-lg-0 mt--7">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card card-lift--hover shadow border-0">
                                <div class="card-body py-5">
                                    <div class="icon icon-shape bg-gradient-primary text-white rounded-circle mb-4">
                                        <i class="ni ni-check-bold"></i>
                                    </div>
                                    <h4 class="h3 text-primary text-uppercase">云建站</h4>
                                    <p class="description mt-3">支持支付宝、微信、QQ钱包等主流支付渠道，让您拥有PC网页、移动网页、小程序。</p>
                                    <div>
                                        <span class="badge badge-pill badge-primary">PC网页</span>
                                        <span class="badge badge-pill badge-primary">移动网页</span>
                                        <span class="badge badge-pill badge-primary">小程序</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card card-lift--hover shadow border-0">
                                <div class="card-body py-5">
                                    <div class="icon icon-shape bg-gradient-success text-white rounded-circle mb-4">
                                        <i class="ni ni-istanbul"></i>
                                    </div>
                                    <h4 class="h3 text-success text-uppercase">云管理</h4>
                                    <p class="description mt-3">您的企业网站可以通过建站系统提供统一虚拟账户，为拓展增值服务提供基础。</p>
                                    <div>
                                        <span class="badge badge-pill badge-success">资金统计</span>
                                        <span class="badge badge-pill badge-success">订单明细</span>
                                        <span class="badge badge-pill badge-success">用户分析</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card card-lift--hover shadow border-0">
                                <div class="card-body py-5">
                                    <div class="icon icon-shape bg-gradient-warning text-white rounded-circle mb-4">
                                        <i class="ni ni-planet"></i>
                                    </div>
                                    <h4 class="h3 text-warning text-uppercase">云提醒</h4>
                                    <p class="description mt-3">异地登陆，重要操作，网站到期，系统自动判定提醒。</p>
                                    <div>
                                        <span class="badge badge-pill badge-warning">邮箱</span>
                                        <span class="badge badge-pill badge-warning">短信</span>
                                        <span class="badge badge-pill badge-warning">电话</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="py-6">
        <div class="container">
            <div class="row row-grid align-items-center">

                <div class="col-md-6 order-md-1">
                    <div class="pr-md-5">
                        <h1>海量模板，极速建站</h1>
                        <p>不同行业模板，随意挑选，随时更改，只需一键就可拥有专属网站。</p>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="pr-md-5">
                        <h1>高效技术服务</h1>
                        <p>我们提供7X24小时在线服务，对日交易高额用户提供贵宾服务！用最具影响力品牌协助，并全力协助新兴品牌，我们以设计助力众多品牌走向行业领先地位，鼎力相助每一个梦想。</p>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <section class="py-6">
        <div class="container">
            <div class="row row-grid align-items-center">


            </div>
        </div>
    </section>

    <section class="py-7 section-nucleo-icons bg-white overflow-hidden">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2 class="display-3">展望未来</h2>
                    <p class="lead">
                        “我们趋行在人生这个亘古的旅途，在坎坷中奔跑，在挫折里涅槃，忧愁缠满全身，痛苦飘洒一地。我们累，却无从止歇；我们苦，却无法回避。”
                    </p>
                </div>
            </div>
            <div class="blur--hover">
                <a href="./consumer/index.php">
                    <div class="icons-container blur-item mt-5">
                        <!-- Center -->
                        <i class="icon ni ni-diamond"></i>
                        <!-- Right 1 -->
                        <i class="icon icon-sm ni ni-album-2"></i>
                        <i class="icon icon-sm ni ni-app"></i>
                        <i class="icon icon-sm ni ni-atom"></i>
                        <!-- Right 2 -->
                        <i class="icon ni ni-bag-17"></i>
                        <i class="icon ni ni-bell-55"></i>
                        <i class="icon ni ni-credit-card"></i>
                        <!-- Left 1 -->
                        <i class="icon icon-sm ni ni-briefcase-24"></i>
                        <i class="icon icon-sm ni ni-building"></i>
                        <i class="icon icon-sm ni ni-button-play"></i>
                        <!-- Left 2 -->
                        <i class="icon ni ni-calendar-grid-58"></i>
                        <i class="icon ni ni-camera-compact"></i>
                        <i class="icon ni ni-chart-bar-32"></i>
                    </div>
                    <span class="blur-hidden h5 text-success">每一个网站都承载着故事，感谢您选择我们</span>
                </a>
            </div>
        </div>
    </section>
</div>
<!-- Footer -->
<footer class="py-5" id="footer-main">
    <div class="container">
        <div class="row align-items-center justify-content-xl-between">
            <div class="col-xl-6">
                <div class="copyright text-center text-xl-left text-muted">
                    &copy; <?= date('Y') ?> <a href="/" class="font-weight-bold ml-1"
                                               target="_blank"><?php echo $conf['web_name']; ?></a>
                </div>
            </div>

            <div class="col-xl-6">
                <ul class="nav nav-footer justify-content-center justify-content-xl-end">
                    <li class="nav-item">
                        <?php if($conf['web_icp']){echo " <br/> 网站备案号: <a href='http://beian.miit.gov.cn/' target='_blank'>".$conf['web_icp']."</a>";?> <?php } ?>
                        <?php echo $conf['access_tongji'] ?>
                    </li>
                </ul>

            </div>
        </div>
    </div>
</footer>
<script href="./assets/etem/js/jquery.min.js"></script>
<script href="./assets/etem/js/bootstrap.bundle.min.js"></script>
<script href="./assets/etem/js/js.cookie.js"></script>
<script href="./assets/etem/js/jquery.scrollbar.min.js"></script>
<script href="./assets/etem/js/jquery-scrollLock.min.js"></script>
<script href="./assets/etem/js/jquery.lavalamp.min.js"></script>
<script href="./assets/etem/js/on-screen.umd.min.js"></script>
<script href="./assets/etem/js/aswl.min.js"></script>
<script href="./assets/etem/js/demo.min.js"></script>
</body>
</html>