/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone;

import com.xiaojukeji.kafka.manager.account.LoginService;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.account.Account;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.LoginDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.AccountVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SSO-Login\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/sso/"})
public class LoginController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private LoginService loginService;

    @ApiOperation(value="\u767b\u9646", notes="")
    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<AccountVO> login(HttpServletRequest request, HttpServletResponse response, @RequestBody LoginDTO dto) {
        Account account = this.loginService.login(request, response, dto);
        if (ValidateUtils.isNull((Object)account)) {
            return Result.buildFrom((ResultStatus)ResultStatus.LOGIN_FAILED);
        }
        AccountVO vo = new AccountVO();
        vo.setUsername(account.getUsername());
        vo.setChineseName(account.getChineseName());
        vo.setDepartment(account.getDepartment());
        vo.setRole(account.getAccountRoleEnum().getRole());
        return new Result((Object)vo);
    }

    @ApiOperation(value="\u767b\u51fa", notes="")
    @RequestMapping(value={"logout"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result logoff(HttpServletRequest request, HttpServletResponse response) {
        this.loginService.logout(request, response, Boolean.valueOf(true));
        return new Result();
    }

    @Deprecated
    @ApiOperation(value="\u767b\u5f55\u68c0\u67e5", notes="\u68c0\u67e5SSO\u8fd4\u56de\u7684Code")
    @RequestMapping(value={"xiaojukeji/login-check"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<AccountVO> checkCodeAndGetStaffInfo(HttpServletRequest request, HttpServletResponse response, @RequestBody LoginDTO dto) {
        Result ra = this.login(request, response, dto);
        if (!Constant.SUCCESS.equals(ra.getCode())) {
            LOGGER.info("user login failed, req:{} result:{}.", (Object)dto, (Object)ra);
        } else {
            LOGGER.info("user login success, req:{} result:{}.", (Object)dto, (Object)ra);
        }
        return ra;
    }

    @Deprecated
    @ApiOperation(value="\u767b\u51fa", notes="")
    @RequestMapping(value={"xiaojukeji/logout"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result logout(HttpServletRequest request, HttpServletResponse response) {
        return this.logoff(request, response);
    }
}

