/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.gateway;

import com.alibaba.fastjson.JSONObject;
import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.TopicConnectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"GATEWAY-WEB\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/gateway/api/v1/"})
public class GatewayHeartbeatController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayHeartbeatController.class);
    @Autowired
    private TopicConnectionService topicConnectionService;

    @ApiLevel(level=3)
    @ApiOperation(value="\u8fde\u63a5\u4fe1\u606f\u4e0a\u62a5\u5165\u53e3", notes="Broker\u4e3b\u52a8\u4e0a\u62a5\u4fe1\u606f")
    @RequestMapping(value={"heartbeat/survive-user"}, method={RequestMethod.POST})
    @ResponseBody
    public Result receiveTopicConnections(@RequestParam(value="clusterId") Long clusterId, @RequestParam(value="brokerId") Integer brokerId, @RequestBody JSONObject jsonObject) {
        if (ValidateUtils.isNull((Object)jsonObject) || jsonObject.isEmpty()) {
            LOGGER.info("class=GatewayHeartbeatController||method=receiveTopicConnections||clusterId={}||brokerId={}||msg=connections empty!", (Object)clusterId, (Object)brokerId);
            return Result.buildSuc();
        }
        LOGGER.info("class=GatewayHeartbeatController||method=receiveTopicConnections||clusterId={}||brokerId={}||size={}||msg=receive connections", new Object[]{clusterId, brokerId, jsonObject.size()});
        List doList = null;
        try {
            doList = JsonUtils.parseTopicConnections((Long)clusterId, (JSONObject)jsonObject, (long)System.currentTimeMillis());
        }
        catch (Exception e) {
            LOGGER.error("class=GatewayHeartbeatController||method=receiveTopicConnections||clusterId={}||brokerId={}||msg=parse data failed||exception={}", new Object[]{clusterId, brokerId, e.getMessage()});
            return Result.buildFailure((String)"fail");
        }
        this.topicConnectionService.batchAdd(doList);
        return Result.buildSuc();
    }
}

