/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.gateway;

import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.TopicReportDO;
import com.xiaojukeji.kafka.manager.common.utils.ListUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.TopicReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"GATEWAY-\u5f00\u542fJMX\u4e0a\u62a5\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/gateway/api/v1/"})
public class GatewayReportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayReportController.class);
    @Autowired
    private TopicReportService topicReportService;

    @ApiLevel(level=2)
    @ApiOperation(value="\u67e5\u8be2\u5f00\u542fJMX\u91c7\u96c6\u7684Topic", notes="")
    @RequestMapping(value={"report/jmx/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getJmxReportTopics(@RequestParam(value="clusterId") Long clusterId) {
        ArrayList doList = this.topicReportService.getNeedReportTopic(clusterId);
        if (ValidateUtils.isNull((Object)doList)) {
            doList = new ArrayList();
        }
        ArrayList<String> topicNameList = new ArrayList<String>();
        for (TopicReportDO elem : doList) {
            topicNameList.add(elem.getTopicName());
        }
        return Result.buildSuc((Object)ListUtils.strList2String(topicNameList));
    }
}

