/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.gateway;

import com.alibaba.fastjson.JSON;
import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.gateway.KafkaAclSearchDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.gateway.KafkaUserSearchDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.gateway.KafkaSecurityVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.SecurityService;
import com.xiaojukeji.kafka.manager.web.converters.GatewayModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"GATEWAY-WEB-\u6743\u9650\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/gateway/api/v1/"})
public class GatewaySecurityController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewaySecurityController.class);
    @Autowired
    private SecurityService securityService;

    @ApiLevel(level=1)
    @ApiOperation(value="Kafka\u7528\u6237\u67e5\u8be2", notes="")
    @RequestMapping(value={"security/users"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<String> getKafkaUsers(@RequestBody KafkaUserSearchDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.GATEWAY_INVALID_REQUEST);
        }
        try {
            ArrayList doList = this.securityService.getKafkaUsers(dto.getStart(), Long.valueOf(dto.getEnd().equals(0L) ? System.currentTimeMillis() : dto.getEnd()));
            if (ValidateUtils.isNull((Object)doList)) {
                doList = new ArrayList();
            }
            KafkaSecurityVO vo = new KafkaSecurityVO();
            vo.setRows(new ArrayList(GatewayModelConverter.convert2KafkaUserVOList(doList)));
            return Result.buildSuc((Object)JSON.toJSONString((Object)vo));
        }
        catch (Exception e) {
            LOGGER.error("get kafka users failed, req:{}.", (Object)dto, (Object)e);
            return Result.buildFrom((ResultStatus)ResultStatus.MYSQL_ERROR);
        }
    }

    @ApiLevel(level=2)
    @ApiOperation(value="Kafka\u7528\u6237\u6743\u9650\u67e5\u8be2", notes="")
    @RequestMapping(value={"security/acls"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<String> getKafkaAcls(@RequestBody KafkaAclSearchDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.GATEWAY_INVALID_REQUEST);
        }
        try {
            ArrayList doList = this.securityService.getKafkaAcls(dto.getClusterId(), dto.getStart(), Long.valueOf(dto.getEnd().equals(0L) ? System.currentTimeMillis() : dto.getEnd()));
            if (ValidateUtils.isNull((Object)doList)) {
                doList = new ArrayList();
            }
            KafkaSecurityVO vo = new KafkaSecurityVO();
            vo.setRows(new ArrayList(GatewayModelConverter.convert2KafkaAclVOList(doList)));
            return Result.buildSuc((Object)JSON.toJSONString((Object)vo));
        }
        catch (Exception e) {
            LOGGER.error("get kafka acls failed, req:{}.", (Object)dto, (Object)e);
            return Result.buildFrom((ResultStatus)ResultStatus.MYSQL_ERROR);
        }
    }
}

