/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.gateway;

import com.alibaba.fastjson.JSON;
import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.bizenum.gateway.GatewayConfigKeyEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.AppRateConfig;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.IpRateConfig;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.KafkaBootstrapServerConfig;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.RequestQueueConfig;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.SpRateConfig;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.GatewayConfigDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.gateway.GatewayConfigVO;
import com.xiaojukeji.kafka.manager.common.utils.ListUtils;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.gateway.GatewayConfigService;
import com.xiaojukeji.kafka.manager.web.api.versionone.gateway.GatewayHeartbeatController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"GATEWAY-\u670d\u52a1\u53d1\u73b0\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/gateway/api/v1/"})
public class GatewayServiceDiscoveryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayHeartbeatController.class);
    @Autowired
    private GatewayConfigService gatewayConfigService;

    @ApiLevel(level=1)
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u96c6\u7fa4\u670d\u52a1\u5730\u5740", notes="")
    @RequestMapping(value={"discovery/address"}, method={RequestMethod.GET})
    @ResponseBody
    public String getKafkaBootstrapServer(@RequestParam(value="clusterId") Long clusterId) {
        if (ValidateUtils.isNull((Object)clusterId)) {
            LOGGER.warn("class=GatewayServiceDiscoveryController||method=getKafkaBootstrapServer||msg=param clusterId is null!");
            return "";
        }
        GatewayConfigDO configDO = this.gatewayConfigService.getByTypeAndName(GatewayConfigKeyEnum.SD_CLUSTER_ID.getConfigType(), String.valueOf(clusterId));
        if (ValidateUtils.isNull((Object)configDO)) {
            LOGGER.info("class=GatewayServiceDiscoveryController||method=getKafkaBootstrapServer||msg=configDO is null!");
            return "";
        }
        return configDO.getValue();
    }

    @ApiLevel(level=1)
    @ApiOperation(value="\u83b7\u53d6\u96c6\u7fa4\u670d\u52a1\u5730\u5740", notes="")
    @RequestMapping(value={"discovery/init"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getAllKafkaBootstrapServers() {
        KafkaBootstrapServerConfig config = this.gatewayConfigService.getKafkaBootstrapServersConfig(Long.valueOf(Long.MIN_VALUE));
        if (ValidateUtils.isNull((Object)config) || ValidateUtils.isNull((Object)config.getClusterIdBootstrapServersMap())) {
            return Result.buildFailure((String)"call init kafka bootstrap servers failed");
        }
        if (ValidateUtils.isEmptyMap((Map)config.getClusterIdBootstrapServersMap())) {
            return Result.buildSuc();
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)config.getClusterIdBootstrapServersMap()));
    }

    @ApiLevel(level=2)
    @ApiOperation(value="\u83b7\u53d6\u96c6\u7fa4\u670d\u52a1\u5730\u5740", notes="")
    @RequestMapping(value={"discovery/update"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getBootstrapServersIfNeeded(@RequestParam(value="versionNumber") long versionNumber) {
        KafkaBootstrapServerConfig config = this.gatewayConfigService.getKafkaBootstrapServersConfig(Long.valueOf(versionNumber));
        if (ValidateUtils.isNull((Object)config) || ValidateUtils.isNull((Object)config.getClusterIdBootstrapServersMap())) {
            return Result.buildFailure((String)"call update kafka bootstrap servers failed");
        }
        if (ValidateUtils.isEmptyMap((Map)config.getClusterIdBootstrapServersMap())) {
            return Result.buildSuc();
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)new GatewayConfigVO(String.valueOf(config.getVersion()), JSON.toJSONString((Object)config.getClusterIdBootstrapServersMap()))));
    }

    @ApiLevel(level=2)
    @ApiOperation(value="\u6700\u5927\u5e76\u53d1\u8bf7\u6c42\u6570", notes="")
    @RequestMapping(value={"discovery/max-request-num"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getMaxRequestNum(@RequestParam(value="versionNumber") long versionNumber) {
        RequestQueueConfig config = this.gatewayConfigService.getRequestQueueConfig(Long.valueOf(versionNumber));
        if (ValidateUtils.isNull((Object)config)) {
            return Result.buildFailure((String)"call get request queue size config failed");
        }
        if (ValidateUtils.isNull((Object)config.getMaxRequestQueueSize())) {
            return Result.buildSuc();
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)new GatewayConfigVO(String.valueOf(config.getVersion()), String.valueOf(config.getMaxRequestQueueSize()))));
    }

    @ApiLevel(level=2)
    @ApiOperation(value="\u6700\u5927APP\u8bf7\u6c42\u901f\u7387", notes="")
    @RequestMapping(value={"discovery/appId-rate"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getAppIdRate(@RequestParam(value="versionNumber") long versionNumber) {
        AppRateConfig config = this.gatewayConfigService.getAppRateConfig(Long.valueOf(versionNumber));
        if (ValidateUtils.isNull((Object)config)) {
            return Result.buildFailure((String)"call get app rate config failed");
        }
        if (ValidateUtils.isNull((Object)config.getAppRateLimit())) {
            return Result.buildSuc();
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)new GatewayConfigVO(String.valueOf(config.getVersion()), String.valueOf(config.getAppRateLimit()))));
    }

    @ApiLevel(level=2)
    @ApiOperation(value="\u6700\u5927IP\u8bf7\u6c42\u901f\u7387", notes="")
    @RequestMapping(value={"discovery/ip-rate"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getIpRate(@RequestParam(value="versionNumber") long versionNumber) {
        IpRateConfig config = this.gatewayConfigService.getIpRateConfig(Long.valueOf(versionNumber));
        if (ValidateUtils.isNull((Object)config)) {
            return Result.buildFailure((String)"call get ip rate config failed");
        }
        if (ValidateUtils.isNull((Object)config.getIpRateLimit())) {
            return Result.buildSuc();
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)new GatewayConfigVO(String.valueOf(config.getVersion()), String.valueOf(config.getIpRateLimit()))));
    }

    @ApiLevel(level=2)
    @ApiOperation(value="\u6700\u5927SP\u8bf7\u6c42\u901f\u7387", notes="")
    @RequestMapping(value={"discovery/sp-limit"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<String> getSpLimit(@RequestParam(value="versionNumber") long versionNumber) {
        SpRateConfig config = this.gatewayConfigService.getSpRateConfig(Long.valueOf(versionNumber));
        if (ValidateUtils.isNull((Object)config) || ValidateUtils.isNull((Object)config.getSpRateMap())) {
            return Result.buildFailure((String)"call update kafka bootstrap servers failed");
        }
        if (ValidateUtils.isEmptyMap((Map)config.getSpRateMap())) {
            return Result.buildSuc();
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (Map.Entry entry : config.getSpRateMap().entrySet()) {
            strList.add((String)entry.getKey() + "#" + String.valueOf(entry.getValue()));
        }
        return Result.buildSuc((Object)JSON.toJSONString((Object)new GatewayConfigVO(String.valueOf(config.getVersion()), ListUtils.strList2String(strList))));
    }
}

