/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.account.AccountService;
import com.xiaojukeji.kafka.manager.account.common.EnterpriseStaff;
import com.xiaojukeji.kafka.manager.common.bizenum.AccountRoleEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.AccountRoleVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.AccountSummaryVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Account\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalAccountController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalAccountController.class);
    @Autowired
    private AccountService accountService;

    @ApiOperation(value="\u8d26\u53f7\u641c\u7d22", notes="\u4ec5\u652f\u6301\u641c\u7d22, \u4e0d\u652f\u6301\u5168\u90e8\u5c55\u793a")
    @RequestMapping(value={"accounts"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AccountSummaryVO>> searchOnJobStaffByKeyWord(@RequestParam(value="keyWord") String keyWord) {
        List staffList = this.accountService.searchAccountByPrefix(keyWord);
        if (ValidateUtils.isEmptyList((List)staffList)) {
            LOGGER.info("class=NormalAccountController||method=searchOnJobStaffByKeyWord||keyWord={}||msg=staffList is empty!", (Object)keyWord);
            return new Result();
        }
        ArrayList<AccountSummaryVO> voList = new ArrayList<AccountSummaryVO>();
        for (EnterpriseStaff staff : staffList) {
            AccountSummaryVO vo = new AccountSummaryVO();
            vo.setUsername(staff.getUsername());
            vo.setChineseName(staff.getChineseName());
            vo.setDepartment(staff.getDepartment());
            voList.add(vo);
        }
        return new Result(voList);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272", notes="")
    @RequestMapping(value={"accounts/account"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<AccountRoleVO> searchAccount() {
        String username = SpringTool.getUserName();
        AccountRoleEnum accountRoleEnum = this.accountService.getAccountRoleFromCache(username);
        return new Result((Object)new AccountRoleVO(username, accountRoleEnum.getRole()));
    }
}

