/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.account.AccountService;
import com.xiaojukeji.kafka.manager.common.annotations.ApiLevel;
import com.xiaojukeji.kafka.manager.common.bizenum.TopicAuthorityEnum;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.AppTopicDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.gateway.TopicQuota;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.AppDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.AppDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.AuthorityDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.QuotaVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.app.AppTopicAuthorityVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.app.AppTopicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.app.AppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicConnectionVO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.gateway.AppService;
import com.xiaojukeji.kafka.manager.service.service.gateway.AuthorityService;
import com.xiaojukeji.kafka.manager.service.service.gateway.QuotaService;
import com.xiaojukeji.kafka.manager.service.service.gateway.TopicConnectionService;
import com.xiaojukeji.kafka.manager.web.converters.AppConverter;
import com.xiaojukeji.kafka.manager.web.converters.TopicModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-APP\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalAppController {
    @Autowired
    private AppService appService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private QuotaService quotaService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;
    @Autowired
    private TopicConnectionService connectionService;
    @Autowired
    private AuthorityService authorityService;

    @ApiLevel(level=3, rateLimit=1)
    @ApiOperation(value="App\u5217\u8868", notes="")
    @RequestMapping(value={"apps"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AppVO>> getApps() {
        return new Result((Object)AppConverter.convert2AppVOList((List)this.appService.getByPrincipal(SpringTool.getUserName())));
    }

    @ApiOperation(value="App\u57fa\u672c\u4fe1\u606f", notes="")
    @RequestMapping(value={"apps/{appId}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<AppVO> getAppBasicInfo(@PathVariable String appId) {
        if (this.accountService.isOpOrRd(SpringTool.getUserName())) {
            return new Result((Object)AppConverter.convert2AppVO((AppDO)this.appService.getByAppId(appId)));
        }
        AppDO appDO = this.appService.getAppByUserAndId(appId, SpringTool.getUserName());
        if (appDO == null) {
            return Result.buildFrom((ResultStatus)ResultStatus.USER_WITHOUT_AUTHORITY);
        }
        return new Result((Object)AppConverter.convert2AppVO((AppDO)appDO));
    }

    @ApiOperation(value="App\u4fee\u6539", notes="")
    @RequestMapping(value={"apps"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyApp(@RequestBody AppDTO dto) {
        return Result.buildFrom((ResultStatus)this.appService.updateByAppId(dto, SpringTool.getUserName(), Boolean.valueOf(false)));
    }

    @ApiOperation(value="\u6709\u6743\u9650\u7684Topic\u4fe1\u606f", notes="null: \u5168\u90e8, true:\u6211\u7684Topic, false:\u975e\u6211\u7684\u6709\u6743\u9650\u7684Topic")
    @RequestMapping(value={"apps/{appId}/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<AppTopicVO>> getAppTopics(@PathVariable String appId, @RequestParam(value="mine", required=false) Boolean mine) {
        List dtoList = this.appService.getAppTopicDTOList(appId, mine);
        ArrayList<AppTopicVO> voList = new ArrayList<AppTopicVO>();
        for (AppTopicDTO dto : dtoList) {
            if (TopicAuthorityEnum.DENY.getCode().equals(dto.getAccess())) continue;
            AppTopicVO vo = new AppTopicVO();
            CopyUtils.copyProperties((Object)vo, (Object)dto);
            vo.setClusterId(dto.getLogicalClusterId());
            vo.setClusterName(dto.getLogicalClusterName());
            voList.add(vo);
        }
        return new Result(voList);
    }

    @ApiOperation(value="Quota\u67e5\u8be2", notes="")
    @RequestMapping(value={"apps/{appId}/quotas"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<QuotaVO>> getAppIdQuota(@PathVariable String appId, @RequestParam(value="clusterId") Long clusterId, @RequestParam(value="topicName") String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        if (!PhysicalClusterMetadataManager.isTopicExist((Long)physicalClusterId, (String)topicName)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        return new Result((Object)AppConverter.convert2QuotaVOList((Long)clusterId, (TopicQuota)this.quotaService.getQuotaFromZk(physicalClusterId, topicName, appId)));
    }

    @ApiOperation(value="\u5e94\u7528\u8fde\u63a5\u4fe1\u606f", notes="")
    @RequestMapping(value={"apps/{appId}/connections"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicConnectionVO>> getAppIdQuota(@PathVariable String appId) {
        return new Result((Object)TopicModelConverter.convert2TopicConnectionVOList((List)this.connectionService.getByAppId(appId, new Date(System.currentTimeMillis() - Constant.TOPIC_CONNECTION_LATEST_TIME_MS), new Date())));
    }

    @ApiOperation(value="app\u5bf9Topic\u6743\u9650\u4fe1\u606f", notes="")
    @RequestMapping(value={"apps/{appId}/authorities"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<AppTopicAuthorityVO> getAppIdQuota(@PathVariable String appId, @RequestParam(value="clusterId") Long clusterId, @RequestParam(value="topicName") String topicName) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        if (!PhysicalClusterMetadataManager.isTopicExist((Long)physicalClusterId, (String)topicName)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        return new Result((Object)AppConverter.convert2AppTopicAuthorityVO((String)appId, (String)topicName, (AuthorityDO)this.authorityService.getAuthority(physicalClusterId, topicName, appId)));
    }
}

