/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.bizenum.KafkaClientEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.cluster.LogicalCluster;
import com.xiaojukeji.kafka.manager.common.entity.pojo.LogicalClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.BrokerOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicOverviewVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.TopicThrottleVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.cluster.LogicClusterVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.cluster.NormalClusterMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.cluster.TopicMetadataVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.rd.broker.BrokerMetadataVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.brokers.BrokerMetadata;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.BrokerService;
import com.xiaojukeji.kafka.manager.service.service.LogicalClusterService;
import com.xiaojukeji.kafka.manager.service.service.ThrottleService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.ClusterModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.CommonModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Cluster\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalClusterController {
    @Autowired
    private ThrottleService throttleService;
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private TopicService topicService;
    @Autowired
    private LogicalClusterService logicalClusterService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;

    @ApiOperation(value="\u96c6\u7fa4\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<LogicClusterVO>> getLogicClusterVOList(@RequestParam(value="all", required=false) Boolean all) {
        if (!ValidateUtils.isNull((Object)all) && all.booleanValue()) {
            return new Result((Object)ClusterModelConverter.convert2LogicClusterVOList((List)this.logicalClusterService.getAllLogicalCluster()));
        }
        return new Result((Object)ClusterModelConverter.convert2LogicClusterVOList((List)this.logicalClusterService.getLogicalClusterListByPrincipal(SpringTool.getUserName())));
    }

    @ApiOperation(value="\u96c6\u7fa4\u57fa\u672c\u4fe1\u606f", notes="")
    @RequestMapping(value={"clusters/{logicalClusterId}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<LogicClusterVO> getLogicClusterVO(@PathVariable Long logicalClusterId) {
        LogicalCluster logicalCluster = this.logicalClusterService.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalCluster)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ClusterModelConverter.convert2LogicClusterVO((LogicalCluster)logicalCluster));
    }

    @ApiOperation(value="\u96c6\u7fa4\u5b9e\u65f6\u6d41\u91cf")
    @RequestMapping(value={"clusters/{logicalClusterId}/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RealTimeMetricsVO> getClusterRealTimeMetrics(@PathVariable Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)CommonModelConverter.convert2RealTimeMetricsVO((List)this.brokerService.getBrokerMetricsFromJmx(logicalClusterDO.getClusterId(), this.logicalClusterMetadataManager.getBrokerIdSet(logicalClusterId), Integer.valueOf(0))));
    }

    @ApiOperation(value="\u96c6\u7fa4\u5386\u53f2\u6d41\u91cf")
    @RequestMapping(value={"clusters/{logicalClusterId}/metrics-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<NormalClusterMetricsVO>> getClusterMetricsHistory(@PathVariable Long logicalClusterId, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ClusterModelConverter.convert2NormalClusterMetricsVOList((List)this.logicalClusterService.getLogicalClusterMetricsFromDB(logicalClusterDO, new Date(startTime), new Date(endTime))));
    }

    @ApiOperation(value="\u96c6\u7fa4Broker\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{logicalClusterId}/brokers"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerOverviewVO>> getBrokerOverview(@PathVariable Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        List brokerOverviewDTOList = this.brokerService.getBrokerOverviewList(logicalClusterDO.getClusterId(), this.logicalClusterMetadataManager.getBrokerIdSet(logicalClusterId));
        return new Result((Object)ClusterModelConverter.convert2BrokerOverviewList((List)brokerOverviewDTOList, null));
    }

    @ApiOperation(value="\u96c6\u7fa4Topic\u5217\u8868")
    @RequestMapping(value={"clusters/{logicalClusterId}/topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicOverviewVO>> getTopicOverview(@PathVariable Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)CommonModelConverter.convert2TopicOverviewVOList((Long)logicalClusterId, (List)this.topicService.getTopicOverviewList(logicalClusterDO.getClusterId(), new ArrayList(this.logicalClusterMetadataManager.getTopicNameSet(logicalClusterId)))));
    }

    @ApiOperation(value="\u96c6\u7fa4\u9650\u6d41\u4fe1\u606f")
    @RequestMapping(value={"clusters/{logicalClusterId}/throttles"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicThrottleVO>> getThrottles(@PathVariable Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ClusterModelConverter.convert2TopicThrottleVOList((List)this.throttleService.getThrottledTopicsFromJmx(logicalClusterDO.getClusterId(), this.logicalClusterMetadataManager.getBrokerIdSet(logicalClusterId), Arrays.asList(KafkaClientEnum.values()))));
    }

    @ApiOperation(value="\u96c6\u7fa4Topic\u5143\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{logicalClusterId}/topic-metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicMetadataVO>> getTopicMetadatas(@PathVariable(value="logicalClusterId") Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ClusterModelConverter.convert2TopicMetadataVOList((List)this.logicalClusterService.getTopicMetadatas(logicalClusterDO)));
    }

    @ApiOperation(value="\u96c6\u7fa4Broker\u5143\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"clusters/{logicalClusterId}/broker-metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<BrokerMetadataVO>> getBrokerMetadatas(@PathVariable(value="logicalClusterId") Long logicalClusterId) {
        LogicalClusterDO logicalClusterDO = this.logicalClusterMetadataManager.getLogicalCluster(logicalClusterId);
        if (ValidateUtils.isNull((Object)logicalClusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        List metadataList = this.logicalClusterService.getBrokerMetadatas(logicalClusterDO);
        ArrayList<BrokerMetadataVO> voList = new ArrayList<BrokerMetadataVO>();
        for (BrokerMetadata brokerMetadata : metadataList) {
            voList.add(new BrokerMetadataVO(brokerMetadata.getBrokerId(), brokerMetadata.getHost()));
        }
        return new Result(voList);
    }
}

