/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.bizenum.OffsetLocationEnum;
import com.xiaojukeji.kafka.manager.common.bizenum.OffsetPosEnum;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.PartitionOffsetDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.consumer.ConsumerGroup;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.TopicOffsetResetDTO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.consumer.ConsumerGroupSummaryVO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.ConsumerService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.web.converters.ConsumerModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Consumer\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalConsumerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalConsumerController.class);
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private TopicService topicService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;

    @ApiOperation(value="\u67e5\u8be2\u6d88\u8d39Topic\u7684\u6d88\u8d39\u7ec4", notes="")
    @RequestMapping(value={"{clusterId}/consumers/{topicName}/consumer-groups"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConsumerGroupSummaryVO>> getConsumeGroups(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)ConsumerModelConverter.convert2ConsumerGroupSummaryVOList((List)this.consumerService.getConsumerGroupSummaries(physicalClusterId, topicName)));
    }

    @ApiOperation(value="\u67e5\u8be2\u6d88\u8d39\u7ec4\u7684\u6d88\u8d39\u8be6\u60c5", notes="")
    @RequestMapping(value={"{clusterId}/consumers/{consumerGroup}/topics/{topicName}/consume-details"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<ConsumerGroupDetailVO>> getConsumeDetail(@PathVariable Long clusterId, @PathVariable String consumerGroup, @PathVariable String topicName, @RequestParam(value="location") String location, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        if (ValidateUtils.isNull((Object)location)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        OffsetLocationEnum offsetStoreLocation = OffsetLocationEnum.getOffsetStoreLocation((String)(location = location.toLowerCase()));
        if (ValidateUtils.isNull((Object)offsetStoreLocation)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CG_LOCATION_ILLEGAL);
        }
        ConsumerGroup consumeGroup = new ConsumerGroup(clusterDO.getId(), consumerGroup, offsetStoreLocation);
        try {
            List consumeDetailDTOList = this.consumerService.getConsumeDetail(clusterDO, topicName, consumeGroup);
            return new Result((Object)ConsumerModelConverter.convert2ConsumerGroupDetailVO((String)topicName, (String)consumerGroup, (String)location, (List)consumeDetailDTOList));
        }
        catch (Exception e) {
            LOGGER.error("get consume detail failed, consumerGroup:{}.", (Object)consumeGroup, (Object)e);
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
    }

    @ApiOperation(value="\u91cd\u7f6eTopic\u6d88\u8d39\u504f\u79fb", notes="")
    @RequestMapping(value={"consumers/offsets"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result<List<Result>> resetConsumeOffsets(@RequestBody TopicOffsetResetDTO dto) {
        if (!dto.legal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(dto.getClusterId(), dto.getIsPhysicalClusterId());
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (ValidateUtils.isNull((Object)clusterDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        List offsetDTOList = this.getPartitionOffset(clusterDO, dto);
        if (ValidateUtils.isEmptyList((List)offsetDTOList)) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ConsumerGroup consumerGroup = new ConsumerGroup(physicalClusterId, dto.getConsumerGroup(), OffsetLocationEnum.getOffsetStoreLocation((String)dto.getLocation()));
        List resultList = this.consumerService.resetConsumerOffset(clusterDO, dto.getTopicName(), consumerGroup, offsetDTOList);
        for (Result result : resultList) {
            if (ResultStatus.SUCCESS.getCode() == result.getCode()) continue;
            return new Result(Integer.valueOf(ResultStatus.OPERATION_FAILED.getCode()), (Object)resultList, "operator failed");
        }
        return new Result((Object)resultList);
    }

    private List<PartitionOffsetDTO> getPartitionOffset(ClusterDO clusterDO, TopicOffsetResetDTO dto) {
        OffsetPosEnum offsetPosEnum = OffsetPosEnum.getOffsetPosEnum((Integer)dto.getOffsetPos());
        if (!ValidateUtils.isNull((Object)dto.getOffsetPos()) && !OffsetPosEnum.NONE.equals((Object)offsetPosEnum)) {
            ArrayList<PartitionOffsetDTO> offsetDTOList = new ArrayList<PartitionOffsetDTO>();
            Map offsetMap = this.topicService.getPartitionOffset(clusterDO, dto.getTopicName(), offsetPosEnum);
            for (Map.Entry entry : offsetMap.entrySet()) {
                offsetDTOList.add(new PartitionOffsetDTO(Integer.valueOf(((TopicPartition)entry.getKey()).partition()), (Long)entry.getValue()));
            }
            return offsetDTOList;
        }
        if (!ValidateUtils.isEmptyList((List)dto.getOffsetList())) {
            return dto.getOffsetList();
        }
        if (!ValidateUtils.isNullOrLessThanZero((Long)dto.getTimestamp())) {
            return this.topicService.getPartitionOffsetList(clusterDO, dto.getTopicName(), dto.getTimestamp());
        }
        return new ArrayList<PartitionOffsetDTO>();
    }
}

