/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.JmxSwitchDTO;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.zookeeper.znode.didi.TopicJmxSwitch;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.ZookeeperService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"RD-Jmx\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalJmxController {
    @Autowired
    private ZookeeperService zookeeperService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;

    @ApiOperation(value="\u5f00\u542fTopicJMX", notes="")
    @RequestMapping(value={"jmx-switch"}, method={RequestMethod.POST})
    @ResponseBody
    public Result openTopicJmxSwitch(@RequestBody JmxSwitchDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(dto.getClusterId(), dto.getPhysicalClusterId());
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return this.zookeeperService.openTopicJmx(physicalClusterId, dto.getTopicName(), new TopicJmxSwitch(dto.getOpenTopicRequestMetrics(), dto.getOpenAppIdTopicMetrics(), dto.getOpenClientRequestMetrics()));
    }
}

