/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.pojo.MonitorRuleDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.gateway.AppDO;
import com.xiaojukeji.kafka.manager.common.utils.CopyUtils;
import com.xiaojukeji.kafka.manager.common.utils.JsonUtils;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.monitor.MonitorService;
import com.xiaojukeji.kafka.manager.monitor.common.entry.Silence;
import com.xiaojukeji.kafka.manager.monitor.common.entry.bizenum.MonitorMetricNameEnum;
import com.xiaojukeji.kafka.manager.monitor.common.entry.dto.MonitorRuleDTO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.dto.MonitorSilenceDTO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorAlertDetailVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorAlertVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorNotifyGroupVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorRuleDetailVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorRuleSummaryVO;
import com.xiaojukeji.kafka.manager.monitor.common.entry.vo.MonitorSilenceVO;
import com.xiaojukeji.kafka.manager.monitor.common.monitor.MonitorAlertDetail;
import com.xiaojukeji.kafka.manager.monitor.common.monitor.MonitorRuleSummary;
import com.xiaojukeji.kafka.manager.service.service.gateway.AppService;
import com.xiaojukeji.kafka.manager.web.converters.MonitorRuleConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Monitor\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalMonitorController {
    @Autowired
    private AppService appService;
    @Autowired
    private MonitorService monitorService;

    @ApiOperation(value="\u76d1\u63a7\u679a\u4e3e\u7c7b", notes="")
    @RequestMapping(value={"monitor-enums"}, method={RequestMethod.GET})
    @ResponseBody
    public Result getMonitorEnums() {
        HashMap<String, Object> data = new HashMap<String, Object>(1);
        data.put("metricNames", JsonUtils.toJson(MonitorMetricNameEnum.class));
        return new Result(data);
    }

    @ApiOperation(value="\u6dfb\u52a0\u76d1\u63a7\u7b56\u7565", notes="")
    @RequestMapping(value={"monitor-strategies"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createMonitor(@RequestBody MonitorRuleDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.monitorService.createMonitorRule(dto, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u5220\u9664\u76d1\u63a7\u7b56\u7565", notes="")
    @RequestMapping(value={"monitor-strategies"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result deleteMonitor(@RequestParam(value="monitorId") Long monitorId) {
        return Result.buildFrom((ResultStatus)this.monitorService.deleteMonitorRule(monitorId, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u4fee\u6539\u76d1\u63a7\u7b56\u7565", notes="")
    @RequestMapping(value={"monitor-strategies"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyMonitors(@RequestBody MonitorRuleDTO dto) {
        if (!dto.paramLegal() || ValidateUtils.isNull((Object)dto.getId())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.monitorService.modifyMonitorRule(dto, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u76d1\u63a7\u7b56\u7565\u5217\u8868", notes="")
    @RequestMapping(value={"monitor-strategies"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<MonitorRuleSummaryVO>> getMonitorRules() {
        List monitorRuleSummaryList = this.monitorService.getMonitorRules(SpringTool.getUserName());
        if (ValidateUtils.isEmptyList((List)monitorRuleSummaryList)) {
            return new Result(new ArrayList());
        }
        ArrayList<MonitorRuleSummaryVO> voList = new ArrayList<MonitorRuleSummaryVO>();
        for (MonitorRuleSummary summary : monitorRuleSummaryList) {
            MonitorRuleSummaryVO vo = new MonitorRuleSummaryVO();
            CopyUtils.copyProperties((Object)vo, (Object)summary);
            voList.add(vo);
        }
        return new Result(voList);
    }

    @ApiOperation(value="\u76d1\u63a7\u7b56\u7565\u8be6\u60c5", notes="")
    @RequestMapping(value={"monitor-strategies/{monitorId}/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<MonitorRuleDetailVO> getMonitorDetail(@PathVariable(value="monitorId") Long monitorId) {
        MonitorRuleDO monitorRuleDO = this.monitorService.getById(monitorId);
        if (ValidateUtils.isNull((Object)monitorRuleDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.MONITOR_NOT_EXIST);
        }
        Result monitorRuleDTOResult = this.monitorService.getMonitorRuleDetail(monitorRuleDO);
        if (!Constant.SUCCESS.equals(monitorRuleDTOResult.getCode())) {
            return new Result(Integer.valueOf(monitorRuleDTOResult.getCode()), monitorRuleDTOResult.getMessage());
        }
        MonitorRuleDTO monitorRuleDTO = (MonitorRuleDTO)monitorRuleDTOResult.getData();
        AppDO appDO = this.appService.getByAppId(monitorRuleDTO.getAppId());
        return new Result((Object)MonitorRuleConverter.convert2MonitorRuleDetailVO((MonitorRuleDO)monitorRuleDO, (MonitorRuleDTO)monitorRuleDTO, (AppDO)appDO));
    }

    @ApiOperation(value="\u544a\u8b66\u5217\u8868", notes="")
    @RequestMapping(value={"monitor-alerts"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<MonitorAlertVO>> getMonitorAlertHistory(@RequestParam(value="monitorId") Long monitorId, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime) {
        Result alertResult = this.monitorService.getMonitorAlertHistory(monitorId, startTime, endTime);
        if (!Constant.SUCCESS.equals(alertResult.getCode())) {
            return new Result(Integer.valueOf(alertResult.getCode()), alertResult.getMessage());
        }
        return new Result((Object)MonitorRuleConverter.convert2MonitorAlertVOList((List)((List)alertResult.getData())));
    }

    @ApiOperation(value="\u544a\u8b66\u8be6\u60c5", notes="")
    @RequestMapping(value={"monitor-alerts/{alertId}/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<MonitorAlertDetailVO> getMonitorAlertDetail(@PathVariable(value="alertId") Long alertId) {
        Result alertResult = this.monitorService.getMonitorAlertDetail(alertId);
        if (!Constant.SUCCESS.equals(alertResult.getCode())) {
            return new Result(Integer.valueOf(alertResult.getCode()), alertResult.getMessage());
        }
        return new Result((Object)MonitorRuleConverter.convert2MonitorAlertDetailVO((MonitorAlertDetail)((MonitorAlertDetail)alertResult.getData())));
    }

    @ApiOperation(value="\u544a\u8b66\u5c4f\u853d\u521b\u5efa", notes="")
    @RequestMapping(value={"monitor-silences"}, method={RequestMethod.POST})
    @ResponseBody
    public Result createMonitorSilences(@RequestBody MonitorSilenceDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return this.monitorService.createSilence(dto, SpringTool.getUserName());
    }

    @ApiOperation(value="\u544a\u8b66\u5c4f\u853d\u4fee\u6539", notes="")
    @RequestMapping(value={"monitor-silences"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyMonitorSilences(@RequestBody MonitorSilenceDTO dto) {
        if (!dto.paramLegal() || ValidateUtils.isNull((Object)dto.getId())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return this.monitorService.modifySilence(dto, SpringTool.getUserName());
    }

    @ApiOperation(value="\u544a\u8b66\u5c4f\u853d\u5220\u9664", notes="")
    @RequestMapping(value={"monitor-silences"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result releaseMonitorSilences(@RequestParam(value="monitorId") Long monitorId, @RequestParam(value="silenceId") Long silenceId) {
        Boolean status = this.monitorService.releaseSilence(silenceId);
        if (ValidateUtils.isNull((Object)status) || !status.booleanValue()) {
            return Result.buildFrom((ResultStatus)ResultStatus.CALL_MONITOR_SYSTEM_ERROR);
        }
        return new Result();
    }

    @ApiOperation(value="\u544a\u8b66\u5c4f\u853d\u5217\u8868", notes="")
    @RequestMapping(value={"monitor-silences"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<MonitorSilenceVO>> getMonitorSilences(@RequestParam(value="monitorId") Long monitorId) {
        MonitorRuleDO monitorRuleDO = this.monitorService.getById(monitorId);
        if (ValidateUtils.isNull((Object)monitorRuleDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.MONITOR_NOT_EXIST);
        }
        Result listResult = this.monitorService.getSilences(monitorRuleDO.getStrategyId());
        if (!Constant.SUCCESS.equals(listResult.getCode())) {
            return new Result(Integer.valueOf(listResult.getCode()), listResult.getMessage());
        }
        return new Result((Object)MonitorRuleConverter.convert2MonitorSilenceVOList((MonitorRuleDO)monitorRuleDO, (List)((List)listResult.getData())));
    }

    @ApiOperation(value="\u544a\u8b66\u5c4f\u853d\u8be6\u60c5", notes="")
    @RequestMapping(value={"monitor-silences/{silenceId}/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<MonitorSilenceVO> getMonitorSilence(@PathVariable(value="silenceId") Long silenceId) {
        Silence silence = this.monitorService.getSilenceById(silenceId);
        if (ValidateUtils.isNull((Object)silence)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CALL_MONITOR_SYSTEM_ERROR);
        }
        MonitorRuleDO monitorRuleDO = this.monitorService.getByStrategyId(silence.getStrategyId());
        if (ValidateUtils.isNull((Object)monitorRuleDO)) {
            return Result.buildFrom((ResultStatus)ResultStatus.MONITOR_NOT_EXIST);
        }
        return new Result((Object)MonitorRuleConverter.convert2MonitorSilenceVO((MonitorRuleDO)monitorRuleDO, (Silence)silence));
    }

    @ApiOperation(value="\u544a\u8b66\u7ec4\u5217\u8868", notes="")
    @RequestMapping(value={"monitor-notify-groups"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<MonitorNotifyGroupVO>> getNotifyGroups() {
        List notifyGroupList = this.monitorService.getNotifyGroups();
        if (ValidateUtils.isNull((Object)notifyGroupList)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CALL_MONITOR_SYSTEM_ERROR);
        }
        return new Result((Object)MonitorRuleConverter.convert2MonitorNotifyGroupVOList((List)notifyGroupList));
    }
}

