/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.bpm.OrderService;
import com.xiaojukeji.kafka.manager.bpm.common.OrderStatusEnum;
import com.xiaojukeji.kafka.manager.bpm.common.OrderTypeEnum;
import com.xiaojukeji.kafka.manager.bpm.common.entry.BaseOrderDetailData;
import com.xiaojukeji.kafka.manager.bpm.common.entry.apply.OrderDTO;
import com.xiaojukeji.kafka.manager.bpm.common.handle.OrderHandleBaseDTO;
import com.xiaojukeji.kafka.manager.bpm.common.handle.OrderHandleBatchDTO;
import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.pojo.OrderDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.OrderResultVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.OrderTypeVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.OrderVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.order.detail.OrderDetailBaseVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.web.converters.OrderConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-\u5de5\u5355\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalOrderController {
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u5de5\u5355\u7c7b\u578b", notes="")
    @RequestMapping(value={"orders/type-enums"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<OrderTypeVO>> getOrderTypes() {
        ArrayList<OrderTypeVO> voList = new ArrayList<OrderTypeVO>();
        for (OrderTypeEnum elem : OrderTypeEnum.values()) {
            voList.add(new OrderTypeVO(elem.getCode(), elem.getMessage()));
        }
        return new Result(voList);
    }

    @ApiOperation(value="\u5de5\u5355\u7533\u8bf7", notes="")
    @RequestMapping(value={"orders"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<OrderVO> createOrder(@RequestBody OrderDTO dto) {
        dto.setApplicant(SpringTool.getUserName());
        Result result = this.orderService.createOrder(dto);
        if (!Constant.SUCCESS.equals(result.getCode())) {
            return result;
        }
        return new Result((Object)OrderConverter.convert2OrderVO((OrderDO)((OrderDO)result.getData())));
    }

    @ApiOperation(value="\u5de5\u5355\u64a4\u9500", notes="")
    @RequestMapping(value={"orders"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result cancelOrder(@RequestParam(value="id") Long id) {
        return Result.buildFrom((ResultStatus)this.orderService.cancelOrder(id, SpringTool.getUserName()));
    }

    @ApiOperation(value="\u5de5\u5355\u7533\u8bf7\u5217\u8868", notes="")
    @RequestMapping(value={"orders"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<OrderVO>> getOrderApplyList(@RequestParam(value="status") Integer status) {
        return new Result((Object)OrderConverter.convert2OrderVOList((List)this.orderService.getOrderApplyList(SpringTool.getUserName(), status)));
    }

    @ApiOperation(value="\u5de5\u5355\u5ba1\u6838\u5217\u8868", notes="")
    @RequestMapping(value={"approvals"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<OrderVO>> getOrderApprovalList(@RequestParam(value="status") Integer status) {
        List orderDOList = new ArrayList();
        String userName = SpringTool.getUserName();
        if (ValidateUtils.isNull((Object)status)) {
            orderDOList = this.orderService.getApprovalList(userName);
        } else if (OrderStatusEnum.WAIT_DEAL.getCode().equals(status)) {
            orderDOList = this.orderService.getWaitApprovalList(userName);
        } else if (OrderStatusEnum.PASSED.getCode().equals(status)) {
            orderDOList = this.orderService.getPassApprovalList(userName);
        }
        return new Result((Object)OrderConverter.convert2OrderVOList(orderDOList));
    }

    @ApiOperation(value="\u5de5\u5355\u8be6\u60c5", notes="")
    @RequestMapping(value={"orders/{orderId}/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<OrderDetailBaseVO> getOrderDetail(@PathVariable Long orderId) {
        Result result = this.orderService.getOrderDetailData(orderId);
        if (!Constant.SUCCESS.equals(result.getCode())) {
            return result;
        }
        return new Result((Object)OrderConverter.convert2DetailBaseVO((BaseOrderDetailData)((BaseOrderDetailData)result.getData())));
    }

    @ApiOperation(value="\u5de5\u5355\u5ba1\u6279", notes="")
    @RequestMapping(value={"orders"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result handleOrder(@RequestBody OrderHandleBaseDTO dto) {
        return Result.buildFrom((ResultStatus)this.orderService.handleOrder(dto));
    }

    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279", notes="")
    @RequestMapping(value={"orders/batch"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result<List<OrderResultVO>> handleOrderBatch(@RequestBody OrderHandleBatchDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return new Result((Object)OrderConverter.convert2OrderResultVOList((List)this.orderService.handleOrderBatch(dto, SpringTool.getUserName())));
    }
}

