/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicBasicDTO;
import com.xiaojukeji.kafka.manager.common.entity.ao.topic.TopicBusinessInfo;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.TopicDataSampleDTO;
import com.xiaojukeji.kafka.manager.common.entity.metrics.BaseMetrics;
import com.xiaojukeji.kafka.manager.common.entity.pojo.ClusterDO;
import com.xiaojukeji.kafka.manager.common.entity.pojo.KafkaBillDO;
import com.xiaojukeji.kafka.manager.common.entity.vo.common.RealTimeMetricsVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.TopicBusinessInfoVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicAuthorizedAppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicBasicVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicBillVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicConnectionVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicDataSampleVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicMetricVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicMyAppVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicPartitionVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicRequestTimeDetailVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicRequestTimeVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.common.utils.jmx.JmxAttributeEnum;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.cache.PhysicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.service.service.KafkaBillService;
import com.xiaojukeji.kafka.manager.service.service.TopicManagerService;
import com.xiaojukeji.kafka.manager.service.service.TopicService;
import com.xiaojukeji.kafka.manager.service.service.gateway.TopicConnectionService;
import com.xiaojukeji.kafka.manager.web.converters.CommonModelConverter;
import com.xiaojukeji.kafka.manager.web.converters.TopicModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Topic\u8be6\u60c5\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalTopicController {
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private TopicService topicService;
    @Autowired
    private TopicManagerService topicManagerService;
    @Autowired
    private TopicConnectionService connectionService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;
    @Autowired
    private KafkaBillService kafkaBillService;

    @ApiOperation(value="Topic\u57fa\u672c\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/basic-info"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<TopicBasicVO> getTopicBasic(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicBasicVO((TopicBasicDTO)this.topicService.getTopicBasicDTO(physicalClusterId, topicName), (ClusterDO)this.clusterService.getById(physicalClusterId), (Long)this.logicalClusterMetadataManager.getTopicLogicalClusterId(physicalClusterId, topicName)));
    }

    @ApiOperation(value="Topic\u5b9e\u65f6\u6d41\u91cf\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/metrics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<RealTimeMetricsVO> getTopicMetrics(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)CommonModelConverter.convert2RealTimeMetricsVO((BaseMetrics)this.topicService.getTopicMetricsFromJMX(physicalClusterId, topicName, Integer.valueOf(0), Boolean.valueOf(true))));
    }

    @ApiOperation(value="Topic\u5386\u53f2\u6d41\u91cf\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/metrics-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicMetricVO>> getTopicMetrics(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        if (ValidateUtils.isBlank((String)appId)) {
            return new Result((Object)TopicModelConverter.convert2TopicMetricsVOList((List)this.topicService.getTopicMetricsFromDB(physicalClusterId, topicName, new Date(startTime), new Date(endTime))));
        }
        return new Result((Object)TopicModelConverter.convert2TopicMetricVOList((List)this.topicService.getTopicMetricsFromDB(appId, physicalClusterId, topicName, new Date(startTime), new Date(endTime))));
    }

    @ApiOperation(value="Topic\u5b9e\u65f6\u8bf7\u6c42\u8017\u65f6\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/request-time"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicRequestTimeDetailVO>> getTopicRequestMetrics(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId, @RequestParam(value="percentile", required=false, defaultValue="75thPercentile") String percentile) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        Boolean isPercentileLegal = Arrays.stream(JmxAttributeEnum.PERCENTILE_ATTRIBUTE.getAttribute()).anyMatch(percentile::equals);
        if (!isPercentileLegal.booleanValue()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        BaseMetrics metrics = this.topicService.getTopicMetricsFromJMX(physicalClusterId, topicName, Integer.valueOf(205), Boolean.valueOf(false));
        return new Result((Object)TopicModelConverter.convert2TopicRequestTimeDetailVOList((BaseMetrics)metrics, (String)percentile));
    }

    @ApiOperation(value="Topic\u5386\u53f2\u8bf7\u6c42\u8017\u65f6\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/request-time-history"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicRequestTimeVO>> getTopicRequestMetrics(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicRequestTimeMetricsVOList((List)this.topicService.getTopicRequestMetricsFromDB(physicalClusterId, topicName, new Date(startTime), new Date(endTime))));
    }

    @ApiOperation(value="Topic\u8fde\u63a5\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/connections"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicConnectionVO>> getTopicConnections(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        List connections = ValidateUtils.isBlank((String)appId) ? this.connectionService.getByTopicName(physicalClusterId, topicName, new Date(System.currentTimeMillis() - Constant.TOPIC_CONNECTION_LATEST_TIME_MS), new Date()) : this.connectionService.getByTopicName(physicalClusterId, topicName, appId, new Date(System.currentTimeMillis() - Constant.TOPIC_CONNECTION_LATEST_TIME_MS), new Date());
        return new Result((Object)TopicModelConverter.convert2TopicConnectionVOList((List)connections));
    }

    @ApiOperation(value="Topic\u5206\u533a\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/partitions"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicPartitionVO>> getTopicPartitions(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (clusterDO == null || !PhysicalClusterMetadataManager.isTopicExist((Long)physicalClusterId, (String)topicName)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        List dtoList = this.topicService.getTopicPartitionDTO(clusterDO, topicName, Boolean.valueOf(true));
        return new Result((Object)TopicModelConverter.convert2TopicPartitionVOList((List)dtoList));
    }

    @ApiOperation(value="Topic\u91c7\u6837\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/sample"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<List<TopicDataSampleVO>> previewTopic(@PathVariable Long clusterId, @PathVariable String topicName, @RequestBody TopicDataSampleDTO reqObj) {
        reqObj.adjustConfig();
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, reqObj.getIsPhysicalClusterId());
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        ClusterDO clusterDO = this.clusterService.getById(physicalClusterId);
        if (ValidateUtils.isNull((Object)clusterDO) || !PhysicalClusterMetadataManager.isTopicExist((Long)physicalClusterId, (String)topicName)) {
            return Result.buildFrom((ResultStatus)ResultStatus.TOPIC_NOT_EXIST);
        }
        List dataList = this.topicService.fetchTopicData(clusterDO, topicName, reqObj);
        if (ValidateUtils.isNull((Object)dataList)) {
            return Result.buildFrom((ResultStatus)ResultStatus.OPERATION_FAILED);
        }
        return new Result((Object)TopicModelConverter.convert2TopicDataSampleVOList((List)dataList));
    }

    @ApiOperation(value="Topic\u8d26\u5355\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/bills"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicBillVO>> getTopicBills(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        List kafkaBillDOList = this.kafkaBillService.getByTopicName(physicalClusterId, topicName, new Date(startTime), new Date(endTime));
        ArrayList<TopicBillVO> voList = new ArrayList<TopicBillVO>();
        for (KafkaBillDO kafkaBillDO : kafkaBillDOList) {
            TopicBillVO vo = new TopicBillVO();
            vo.setQuota(Long.valueOf(kafkaBillDO.getQuota().longValue()));
            vo.setCost(kafkaBillDO.getCost());
            vo.setGmtMonth(kafkaBillDO.getGmtDay());
            voList.add(vo);
        }
        return new Result(voList);
    }

    @ApiOperation(value="\u83b7\u53d6Topic\u4e1a\u52a1\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/business"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<TopicBusinessInfoVO> getTopicBusinessInfo(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicBusinessInfoVO((TopicBusinessInfo)this.topicManagerService.getTopicBusinessInfo(physicalClusterId, topicName)));
    }

    @ApiOperation(value="Topic\u6709\u6743\u9650\u7684\u5e94\u7528\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/apps"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicAuthorizedAppVO>> getTopicAuthorizedApps(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicAuthorizedAppVOList((List)this.topicManagerService.getTopicAuthorizedApps(physicalClusterId, topicName)));
    }

    @ApiOperation(value="Topic\u6211\u7684\u5e94\u7528\u4fe1\u606f", notes="")
    @RequestMapping(value={"{clusterId}/topics/{topicName}/my-apps"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicMyAppVO>> getTopicMyApps(@PathVariable Long clusterId, @PathVariable String topicName, @RequestParam(value="isPhysicalClusterId", required=false) Boolean isPhysicalClusterId) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(clusterId, isPhysicalClusterId);
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return new Result((Object)TopicModelConverter.convert2TopicMineAppVOList((List)this.topicManagerService.getTopicMineApps(physicalClusterId, topicName, SpringTool.getUserName())));
    }
}

