/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.normal;

import com.xiaojukeji.kafka.manager.common.constant.Constant;
import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.TopicModifyDTO;
import com.xiaojukeji.kafka.manager.common.entity.dto.normal.TopicRetainDTO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicExpiredVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicMineVO;
import com.xiaojukeji.kafka.manager.common.entity.vo.normal.topic.TopicVO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.cache.LogicalClusterMetadataManager;
import com.xiaojukeji.kafka.manager.service.service.TopicExpiredService;
import com.xiaojukeji.kafka.manager.service.service.TopicManagerService;
import com.xiaojukeji.kafka.manager.web.converters.TopicMineConverter;
import com.xiaojukeji.kafka.manager.web.utils.ResultCache;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Normal-Topic\u64cd\u4f5c\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/normal/"})
public class NormalTopicMineController {
    @Autowired
    private TopicExpiredService topicExpiredService;
    @Autowired
    private TopicManagerService topicManagerService;
    @Autowired
    private LogicalClusterMetadataManager logicalClusterMetadataManager;

    @ApiOperation(value="\u6211\u7684Topic", notes="")
    @RequestMapping(value={"topics/mine"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicMineVO>> getMineTopics() {
        return new Result((Object)TopicMineConverter.convert2TopicMineVOList((List)this.topicManagerService.getMyTopics(SpringTool.getUserName())));
    }

    @ApiOperation(value="\u5168\u90e8Topic", notes="")
    @RequestMapping(value={"topics"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicVO>> getTopics() {
        Result r = ResultCache.get((String)"/api/v1/normal/topics");
        if (ValidateUtils.isNull((Object)r) || !Constant.SUCCESS.equals(r.getCode())) {
            r = new Result((Object)TopicMineConverter.convert2TopicVOList((List)this.topicManagerService.getTopics(SpringTool.getUserName())));
            ResultCache.put((String)"/api/v1/normal/topics", (Result)r);
        }
        return r;
    }

    @ApiOperation(value="\u4fee\u6539Topic\u4fe1\u606f", notes="\u5ef6\u957f\u4fdd\u7559, \u4fee\u6539\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"topics"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyTopic(@RequestBody TopicModifyDTO dto) {
        if (!dto.paramLegal()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(dto.getClusterId());
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return Result.buildFrom((ResultStatus)this.topicManagerService.modifyTopic(physicalClusterId, dto.getTopicName(), dto.getDescription(), SpringTool.getUserName()));
    }

    @ApiOperation(value="\u8fc7\u671fTopic\u4fe1\u606f", notes="")
    @RequestMapping(value={"topics/expired"}, method={RequestMethod.GET})
    @ResponseBody
    public Result<List<TopicExpiredVO>> getExpiredTopics() {
        return new Result((Object)TopicMineConverter.convert2TopicExpiredVOList((List)this.topicExpiredService.getExpiredTopicDataList(SpringTool.getUserName())));
    }

    @ApiOperation(value="\u8fc7\u671fTopic\u4fdd\u7559", notes="")
    @RequestMapping(value={"topics/expired"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result retainExpiredTopic(@RequestBody TopicRetainDTO dto) {
        Long physicalClusterId = this.logicalClusterMetadataManager.getPhysicalClusterId(dto.getClusterId());
        if (ValidateUtils.isNull((Object)physicalClusterId)) {
            return Result.buildFrom((ResultStatus)ResultStatus.CLUSTER_NOT_EXIST);
        }
        return Result.buildFrom((ResultStatus)this.topicExpiredService.retainExpiredTopic(physicalClusterId, dto.getTopicName(), dto.getRetainDays()));
    }
}

