/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojukeji.kafka.manager.web.api.versionone.op;

import com.xiaojukeji.kafka.manager.common.entity.Result;
import com.xiaojukeji.kafka.manager.common.entity.ResultStatus;
import com.xiaojukeji.kafka.manager.common.entity.dto.rd.ClusterDTO;
import com.xiaojukeji.kafka.manager.common.utils.SpringTool;
import com.xiaojukeji.kafka.manager.common.utils.ValidateUtils;
import com.xiaojukeji.kafka.manager.service.service.ClusterService;
import com.xiaojukeji.kafka.manager.web.converters.ClusterModelConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"OP-Cluster\u7ef4\u5ea6\u76f8\u5173\u63a5\u53e3(REST)"})
@RestController
@RequestMapping(value={"/api/v1/op/"})
public class OpClusterController {
    @Autowired
    private ClusterService clusterService;

    @ApiOperation(value="\u63a5\u5165\u96c6\u7fa4")
    @RequestMapping(value={"clusters"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addNew(@RequestBody ClusterDTO dto) {
        if (ValidateUtils.isNull((Object)dto) || !dto.legal().booleanValue()) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        return Result.buildFrom((ResultStatus)this.clusterService.addNew(ClusterModelConverter.convert2ClusterDO((ClusterDTO)dto), SpringTool.getUserName()));
    }

    @ApiOperation(value="\u5220\u9664\u96c6\u7fa4")
    @RequestMapping(value={"clusters"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Result delete(@RequestParam(value="clusterId") Long clusterId) {
        return Result.buildFrom((ResultStatus)this.clusterService.deleteById(clusterId));
    }

    @ApiOperation(value="\u4fee\u6539\u96c6\u7fa4\u4fe1\u606f")
    @RequestMapping(value={"clusters"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modify(@RequestBody ClusterDTO reqObj) {
        if (ValidateUtils.isNull((Object)reqObj) || !reqObj.legal().booleanValue() || ValidateUtils.isNull((Object)reqObj.getClusterId())) {
            return Result.buildFrom((ResultStatus)ResultStatus.PARAM_ILLEGAL);
        }
        ResultStatus rs = this.clusterService.updateById(ClusterModelConverter.convert2ClusterDO((ClusterDTO)reqObj), SpringTool.getUserName());
        return Result.buildFrom((ResultStatus)rs);
    }

    @ApiOperation(value="\u5f00\u542f|\u5173\u95ed\u96c6\u7fa4\u76d1\u63a7")
    @RequestMapping(value={"clusters/{clusterId}/monitor"}, method={RequestMethod.PUT})
    @ResponseBody
    public Result modifyStatus(@PathVariable Long clusterId, @RequestParam(value="status") Integer status) {
        return Result.buildFrom((ResultStatus)this.clusterService.modifyStatus(clusterId, status, SpringTool.getUserName()));
    }
}

